/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.security;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.CompositeDestinationInterceptor;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationInterceptor;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.Message;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.security.AuthorizationDestinationInterceptor;
import com.bes.mq.security.AuthorizationMap;
import com.bes.mq.security.SecurityAdminMBean;
import com.bes.mq.security.SecurityContext;
import java.util.Arrays;
import java.util.Set;

public class AuthorizationBroker
extends BrokerFilter
implements SecurityAdminMBean {
    private final AuthorizationMap authorizationMap;

    public AuthorizationBroker(Broker next, AuthorizationMap authorizationMap) {
        super(next);
        this.authorizationMap = authorizationMap;
        RegionBroker regionBroker = (RegionBroker)next.getAdaptor(RegionBroker.class);
        CompositeDestinationInterceptor compositeInterceptor = (CompositeDestinationInterceptor)regionBroker.getDestinationInterceptor();
        DestinationInterceptor[] interceptors = compositeInterceptor.getInterceptors();
        interceptors = Arrays.copyOf(interceptors, interceptors.length + 1);
        interceptors[interceptors.length - 1] = new AuthorizationDestinationInterceptor(this);
        compositeInterceptor.setInterceptors(interceptors);
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.addDestination(context, info.getDestination(), true);
        super.addDestinationInfo(context, info);
    }

    public Destination addDestination(ConnectionContext context, BESMQDestination destination, boolean create) throws Exception {
        SecurityContext securityContext = context.getSecurityContext();
        if (securityContext == null) {
            throw new SecurityException("User is not authenticated.");
        }
        Destination existing = this.getDestinationMap().get(destination);
        if (existing != null) {
            return super.addDestination(context, destination, create);
        }
        if (!securityContext.isBrokerContext()) {
            Set<?> allowedACLs = null;
            allowedACLs = !destination.isTemporary() ? this.authorizationMap.getAdminACLs(destination) : this.authorizationMap.getTempDestinationAdminACLs();
            if (allowedACLs != null && !securityContext.isInOneOf(allowedACLs)) {
                throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to create: " + destination);
            }
        }
        return super.addDestination(context, destination, create);
    }

    public void removeDestination(ConnectionContext context, BESMQDestination destination, long timeout) throws Exception {
        SecurityContext securityContext = context.getSecurityContext();
        if (securityContext == null) {
            throw new SecurityException("User is not authenticated.");
        }
        Set<?> allowedACLs = null;
        allowedACLs = !destination.isTemporary() ? this.authorizationMap.getAdminACLs(destination) : this.authorizationMap.getTempDestinationAdminACLs();
        if (!securityContext.isBrokerContext() && allowedACLs != null && !securityContext.isInOneOf(allowedACLs)) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to remove: " + destination);
        }
        super.removeDestination(context, destination, timeout);
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        SecurityContext subject = context.getSecurityContext();
        if (subject == null) {
            throw new SecurityException("User is not authenticated.");
        }
        Set<?> allowedACLs = null;
        allowedACLs = !info.getDestination().isTemporary() ? this.authorizationMap.getReadACLs(info.getDestination()) : this.authorizationMap.getTempDestinationReadACLs();
        if (!subject.isBrokerContext() && allowedACLs != null && !subject.isInOneOf(allowedACLs)) {
            throw new SecurityException("User " + subject.getUserName() + " is not authorized to read from: " + info.getDestination());
        }
        subject.getAuthorizedReadDests().put(info.getDestination(), info.getDestination());
        return super.addConsumer(context, info);
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        SecurityContext subject = context.getSecurityContext();
        if (subject == null) {
            throw new SecurityException("User is not authenticated.");
        }
        if (!subject.isBrokerContext() && info.getDestination() != null) {
            Set<?> allowedACLs = null;
            allowedACLs = !info.getDestination().isTemporary() ? this.authorizationMap.getWriteACLs(info.getDestination()) : this.authorizationMap.getTempDestinationWriteACLs();
            if (allowedACLs != null && !subject.isInOneOf(allowedACLs)) {
                throw new SecurityException("User " + subject.getUserName() + " is not authorized to write to: " + info.getDestination());
            }
            subject.getAuthorizedWriteDests().put(info.getDestination(), info.getDestination());
        }
        super.addProducer(context, info);
    }

    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        SecurityContext subject = producerExchange.getConnectionContext().getSecurityContext();
        if (subject == null) {
            throw new SecurityException("User is not authenticated.");
        }
        if (!subject.isBrokerContext() && !subject.getAuthorizedWriteDests().contains(messageSend.getDestination())) {
            Set<?> allowedACLs = null;
            allowedACLs = !messageSend.getDestination().isTemporary() ? this.authorizationMap.getWriteACLs(messageSend.getDestination()) : this.authorizationMap.getTempDestinationWriteACLs();
            if (allowedACLs != null && !subject.isInOneOf(allowedACLs)) {
                throw new SecurityException("User " + subject.getUserName() + " is not authorized to write to: " + messageSend.getDestination());
            }
            subject.getAuthorizedWriteDests().put(messageSend.getDestination(), messageSend.getDestination());
        }
        super.send(producerExchange, messageSend);
    }

    public void addQueueRole(String queue, String operation, String role) {
        this.addDestinationRole(new BESMQQueue(queue), operation, role);
    }

    public void addTopicRole(String topic, String operation, String role) {
        this.addDestinationRole(new BESMQTopic(topic), operation, role);
    }

    public void removeQueueRole(String queue, String operation, String role) {
        this.removeDestinationRole(new BESMQQueue(queue), operation, role);
    }

    public void removeTopicRole(String topic, String operation, String role) {
        this.removeDestinationRole(new BESMQTopic(topic), operation, role);
    }

    public void addDestinationRole(javax.jms.Destination destination, String operation, String role) {
    }

    public void removeDestinationRole(javax.jms.Destination destination, String operation, String role) {
    }

    public void addRole(String role) {
    }

    public void addUserRole(String user, String role) {
    }

    public void removeRole(String role) {
    }

    public void removeUserRole(String user, String role) {
    }

    public AuthorizationMap getAuthorizationMap() {
        return this.authorizationMap;
    }

    protected SecurityContext checkSecurityContext(ConnectionContext context) throws SecurityException {
        SecurityContext securityContext = context.getSecurityContext();
        if (securityContext == null) {
            throw new SecurityException("User is not authenticated.");
        }
        return securityContext;
    }
}

