/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.security;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFilter;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.security.AuthorizationBroker;
import com.bes.mq.security.AuthorizationMap;
import com.bes.mq.security.SecurityContext;
import java.util.Set;

public class AuthorizationDestinationFilter
extends DestinationFilter {
    private final AuthorizationBroker broker;

    public AuthorizationDestinationFilter(Destination destination, AuthorizationBroker broker) {
        super(destination);
        this.broker = broker;
    }

    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        SecurityContext securityContext = this.broker.checkSecurityContext(context);
        AuthorizationMap authorizationMap = this.broker.getAuthorizationMap();
        BESMQDestination destination = this.next.getBESMQDestination();
        Set<?> allowedACLs = !destination.isTemporary() ? authorizationMap.getReadACLs(destination) : authorizationMap.getTempDestinationReadACLs();
        if (!securityContext.isBrokerContext() && allowedACLs != null && !securityContext.isInOneOf(allowedACLs)) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to read from: " + destination);
        }
        securityContext.getAuthorizedReadDests().put(destination, destination);
        super.addSubscription(context, sub);
    }
}

