/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.security;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.filter.DestinationMap;
import com.bes.mq.filter.DestinationMapEntry;
import com.bes.mq.security.AuthorizationEntry;
import com.bes.mq.security.AuthorizationMap;
import com.bes.mq.security.TempDestinationAuthorizationEntry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthorizationMap
extends DestinationMap
implements AuthorizationMap {
    private AuthorizationEntry defaultEntry;
    private TempDestinationAuthorizationEntry tempDestinationAuthorizationEntry;

    public DefaultAuthorizationMap() {
    }

    public DefaultAuthorizationMap(List<DestinationMapEntry> authorizationEntries) {
        this.setAuthorizationEntries(authorizationEntries);
    }

    public void setTempDestinationAuthorizationEntry(TempDestinationAuthorizationEntry tempDestinationAuthorizationEntry) {
        this.tempDestinationAuthorizationEntry = tempDestinationAuthorizationEntry;
    }

    public TempDestinationAuthorizationEntry getTempDestinationAuthorizationEntry() {
        return this.tempDestinationAuthorizationEntry;
    }

    public Set<Object> getTempDestinationAdminACLs() {
        if (this.tempDestinationAuthorizationEntry != null) {
            return this.tempDestinationAuthorizationEntry.getAdminACLs();
        }
        return null;
    }

    public Set<Object> getTempDestinationReadACLs() {
        if (this.tempDestinationAuthorizationEntry != null) {
            return this.tempDestinationAuthorizationEntry.getReadACLs();
        }
        return null;
    }

    public Set<Object> getTempDestinationWriteACLs() {
        if (this.tempDestinationAuthorizationEntry != null) {
            return this.tempDestinationAuthorizationEntry.getWriteACLs();
        }
        return null;
    }

    public Set<Object> getAdminACLs(BESMQDestination destination) {
        Set<AuthorizationEntry> entries = this.getAllEntries(destination);
        HashSet<Object> answer = new HashSet<Object>();
        for (AuthorizationEntry entry : entries) {
            answer.addAll(entry.getAdminACLs());
        }
        return answer;
    }

    public Set<Object> getReadACLs(BESMQDestination destination) {
        Set<AuthorizationEntry> entries = this.getAllEntries(destination);
        HashSet<Object> answer = new HashSet<Object>();
        for (AuthorizationEntry entry : entries) {
            answer.addAll(entry.getReadACLs());
        }
        return answer;
    }

    public Set<Object> getWriteACLs(BESMQDestination destination) {
        Set<AuthorizationEntry> entries = this.getAllEntries(destination);
        HashSet<Object> answer = new HashSet<Object>();
        for (AuthorizationEntry entry : entries) {
            answer.addAll(entry.getWriteACLs());
        }
        return answer;
    }

    public AuthorizationEntry getEntryFor(BESMQDestination destination) {
        AuthorizationEntry answer = (AuthorizationEntry)this.chooseValue(destination);
        if (answer == null) {
            answer = this.getDefaultEntry();
        }
        return answer;
    }

    @Override
    public synchronized Set get(BESMQDestination key) {
        if (key.isComposite()) {
            BESMQDestination childDestination;
            BESMQDestination[] destinations = key.getCompositeDestinations();
            Set answer = null;
            for (int i = 0; i < destinations.length && (answer = DefaultAuthorizationMap.union(answer, this.get(childDestination = destinations[i]))) != null && !answer.isEmpty(); ++i) {
            }
            return answer;
        }
        return this.findWildcardMatches(key);
    }

    public void setAuthorizationEntries(List<DestinationMapEntry> entries) {
        super.setEntries(entries);
    }

    public AuthorizationEntry getDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(AuthorizationEntry defaultEntry) {
        this.defaultEntry = defaultEntry;
    }

    @Override
    protected Class<? extends DestinationMapEntry> getEntryClass() {
        return AuthorizationEntry.class;
    }

    protected Set<AuthorizationEntry> getAllEntries(BESMQDestination destination) {
        Set entries = this.get(destination);
        if (this.defaultEntry != null) {
            entries.add(this.defaultEntry);
        }
        return entries;
    }
}

