/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.security;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.jaas.JassCredentialCallbackHandler;
import com.bes.mq.security.SecurityContext;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;

public class JaasAuthenticationBroker
extends BrokerFilter {
    private final String jassConfiguration;
    private final CopyOnWriteArrayList<SecurityContext> securityContexts = new CopyOnWriteArrayList();

    public JaasAuthenticationBroker(Broker next, String jassConfiguration) {
        super(next);
        this.jassConfiguration = jassConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        if (context.getSecurityContext() == null) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(JaasAuthenticationBroker.class.getClassLoader());
            try {
                try {
                    JassCredentialCallbackHandler callback = new JassCredentialCallbackHandler(info.getUserName(), info.getPassword());
                    LoginContext lc = new LoginContext(this.jassConfiguration, (CallbackHandler)callback);
                    lc.login();
                    Subject subject = lc.getSubject();
                    JaasSecurityContext s = new JaasSecurityContext(info.getUserName(), subject);
                    context.setSecurityContext(s);
                    this.securityContexts.add(s);
                }
                catch (Exception e) {
                    throw (SecurityException)new SecurityException("User name [" + info.getUserName() + "] or password is invalid.").initCause(e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        super.addConnection(context, info);
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        if (this.securityContexts.remove(context.getSecurityContext())) {
            context.setSecurityContext(null);
        }
    }

    public void refresh() {
        for (SecurityContext sc : this.securityContexts) {
            sc.getAuthorizedReadDests().clear();
            sc.getAuthorizedWriteDests().clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JaasSecurityContext
    extends SecurityContext {
        private final Subject subject;

        public JaasSecurityContext(String userName, Subject subject) {
            super(userName);
            this.subject = subject;
        }

        @Override
        public Set<Principal> getPrincipals() {
            return this.subject.getPrincipals();
        }
    }
}

