/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.security;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.jaas.JaasCertificateCallbackHandler;
import com.bes.mq.jaas.UserPrincipal;
import com.bes.mq.security.JaasAuthenticationBroker;
import com.bes.mq.security.JaasCertificateSecurityContext;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;

public class JaasCertificateAuthenticationBroker
extends BrokerFilter {
    private final String jaasConfiguration;

    public JaasCertificateAuthenticationBroker(Broker next, String jaasConfiguration) {
        super(next);
        this.jaasConfiguration = jaasConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        if (context.getSecurityContext() == null) {
            if (!(info.getTransportContext() instanceof X509Certificate[])) {
                throw new SecurityException("Unable to authenticate transport without SSL certificate.");
            }
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(JaasAuthenticationBroker.class.getClassLoader());
            try {
                try {
                    JaasCertificateCallbackHandler callback = new JaasCertificateCallbackHandler((X509Certificate[])info.getTransportContext());
                    LoginContext lc = new LoginContext(this.jaasConfiguration, (CallbackHandler)callback);
                    lc.login();
                    Subject subject = lc.getSubject();
                    String dnName = "";
                    for (Principal principal : subject.getPrincipals()) {
                        if (!(principal instanceof UserPrincipal)) continue;
                        dnName = ((UserPrincipal)principal).getName();
                        break;
                    }
                    JaasCertificateSecurityContext s = new JaasCertificateSecurityContext(dnName, subject, (X509Certificate[])info.getTransportContext());
                    context.setSecurityContext(s);
                }
                catch (Exception e) {
                    throw new SecurityException("User name [" + info.getUserName() + "] or password is invalid. " + e.getMessage(), e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        super.addConnection(context, info);
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        context.setSecurityContext(null);
    }
}

