/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.security;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.Connector;
import com.bes.mq.broker.EmptyBroker;
import com.bes.mq.broker.TransportConnector;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.security.JaasAuthenticationBroker;
import com.bes.mq.security.JaasCertificateAuthenticationBroker;
import com.bes.mq.transport.tcp.SslTransportServer;

public class JaasDualAuthenticationBroker
extends BrokerFilter {
    private final JaasCertificateAuthenticationBroker sslBroker;
    private final JaasAuthenticationBroker nonSslBroker;

    public JaasDualAuthenticationBroker(Broker next, String jaasConfiguration, String jaasSslConfiguration) {
        super(next);
        this.nonSslBroker = new JaasAuthenticationBroker(new EmptyBroker(), jaasConfiguration);
        this.sslBroker = new JaasCertificateAuthenticationBroker(new EmptyBroker(), jaasSslConfiguration);
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        if (context.getSecurityContext() == null) {
            boolean isSSL;
            Connector connector = context.getConnector();
            if (connector instanceof TransportConnector) {
                TransportConnector transportConnector = (TransportConnector)connector;
                isSSL = transportConnector.getServer() instanceof SslTransportServer;
            } else {
                isSSL = false;
            }
            if (isSSL) {
                this.sslBroker.addConnection(context, info);
            } else {
                this.nonSslBroker.addConnection(context, info);
            }
            super.addConnection(context, info);
        }
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        boolean isSSL;
        Connector connector = context.getConnector();
        if (connector instanceof TransportConnector) {
            TransportConnector transportConnector = (TransportConnector)connector;
            isSSL = transportConnector.getServer() instanceof SslTransportServer;
        } else {
            isSSL = false;
        }
        super.removeConnection(context, info, error);
        if (isSSL) {
            this.sslBroker.removeConnection(context, info, error);
        } else {
            this.nonSslBroker.removeConnection(context, info, error);
        }
    }
}

