/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.security;

import com.bes.mq.command.BESMQDestination;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityContext {
    public static final SecurityContext BROKER_SECURITY_CONTEXT = new SecurityContext("BESMQBroker"){

        @Override
        public boolean isBrokerContext() {
            return true;
        }

        @Override
        public Set<Principal> getPrincipals() {
            return Collections.emptySet();
        }
    };
    final String userName;
    final ConcurrentHashMap<BESMQDestination, BESMQDestination> authorizedReadDests = new ConcurrentHashMap();
    final ConcurrentHashMap<BESMQDestination, BESMQDestination> authorizedWriteDests = new ConcurrentHashMap();

    public SecurityContext(String userName) {
        this.userName = userName;
    }

    public boolean isInOneOf(Set<?> allowedPrincipals) {
        Iterator<?> allowedIter = allowedPrincipals.iterator();
        HashSet<Principal> userPrincipals = new HashSet<Principal>(this.getPrincipals());
        while (allowedIter.hasNext()) {
            Iterator<Principal> userIter = userPrincipals.iterator();
            Object allowedPrincipal = allowedIter.next();
            while (userIter.hasNext()) {
                if (!allowedPrincipal.equals(userIter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Set<Principal> getPrincipals();

    public String getUserName() {
        return this.userName;
    }

    public ConcurrentHashMap<BESMQDestination, BESMQDestination> getAuthorizedReadDests() {
        return this.authorizedReadDests;
    }

    public ConcurrentHashMap<BESMQDestination, BESMQDestination> getAuthorizedWriteDests() {
        return this.authorizedWriteDests;
    }

    public boolean isBrokerContext() {
        return false;
    }
}

