/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.security;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerPlugin;
import com.bes.mq.jaas.GroupPrincipal;
import com.bes.mq.security.AuthenticationUser;
import com.bes.mq.security.SimpleAuthenticationBroker;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAuthenticationPlugin
implements BrokerPlugin {
    private Map<String, String> userPasswords;
    private Map<String, Set<Principal>> userGroups;
    private static final String DEFAULT_ANONYMOUS_USER = "anonymous";
    private static final String DEFAULT_ANONYMOUS_GROUP = "anonymous";
    private String anonymousUser = "anonymous";
    private String anonymousGroup = "anonymous";
    private boolean anonymousAccessAllowed = false;

    public SimpleAuthenticationPlugin() {
    }

    public SimpleAuthenticationPlugin(List<?> users) {
        this.setUsers(users);
    }

    @Override
    public Broker installPlugin(Broker parent) {
        SimpleAuthenticationBroker broker = new SimpleAuthenticationBroker(parent, this.userPasswords, this.userGroups);
        broker.setAnonymousAccessAllowed(this.anonymousAccessAllowed);
        broker.setAnonymousUser(this.anonymousUser);
        broker.setAnonymousGroup(this.anonymousGroup);
        return broker;
    }

    public Map<String, Set<Principal>> getUserGroups() {
        return this.userGroups;
    }

    public void setUsers(List<?> users) {
        this.userPasswords = new HashMap<String, String>();
        this.userGroups = new HashMap<String, Set<Principal>>();
        for (AuthenticationUser user : users) {
            this.userPasswords.put(user.getUsername(), user.getPassword());
            HashSet<GroupPrincipal> groups = new HashSet<GroupPrincipal>();
            StringTokenizer iter = new StringTokenizer(user.getGroups(), ",");
            while (iter.hasMoreTokens()) {
                String name = iter.nextToken().trim();
                groups.add(new GroupPrincipal(name));
            }
            this.userGroups.put(user.getUsername(), groups);
        }
    }

    public void setAnonymousAccessAllowed(boolean anonymousAccessAllowed) {
        this.anonymousAccessAllowed = anonymousAccessAllowed;
    }

    public void setAnonymousUser(String anonymousUser) {
        this.anonymousUser = anonymousUser;
    }

    public void setAnonymousGroup(String anonymousGroup) {
        this.anonymousGroup = anonymousGroup;
    }

    public void setUserGroups(Map<String, Set<Principal>> userGroups) {
        this.userGroups = userGroups;
    }

    public Map<String, String> getUserPasswords() {
        return this.userPasswords;
    }

    public void setUserPasswords(Map<String, String> userPasswords) {
        this.userPasswords = userPasswords;
    }
}

