/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.spring;

import com.bes.enterprise.gmssl.GMKeyStore;
import com.bes.mq.Utils;
import com.bes.mq.broker.JSSEKeyManager;
import com.bes.mq.broker.SslContext;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSslContext
extends SslContext {
    private String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "jks");
    private String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", "jks");
    private String secureRandomAlgorithm = "SHA1PRNG";
    private String keyStoreAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String trustStoreAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private String keyStore = System.getProperty("javax.net.ssl.keyStore");
    private String trustStore = System.getProperty("javax.net.ssl.trustStore");
    private String keyStoreKeyPassword = System.getProperty("javax.net.ssl.keyPassword");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.keyManagers.addAll(this.createKeyManagers());
        this.trustManagers.addAll(this.createTrustManagers());
        if (this.secureRandom == null) {
            this.secureRandom = this.createSecureRandom();
        }
    }

    private SecureRandom createSecureRandom() throws NoSuchAlgorithmException {
        return SecureRandom.getInstance(this.secureRandomAlgorithm);
    }

    private Collection<TrustManager> createTrustManagers() throws Exception {
        KeyStore ks = this.createTrustManagerKeyStore();
        if (ks == null) {
            return new ArrayList<TrustManager>(0);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.trustStoreAlgorithm);
        tmf.init(ks);
        return Arrays.asList(tmf.getTrustManagers());
    }

    private Collection<KeyManager> createKeyManagers() throws Exception {
        KeyStore ks = this.createKeyManagerKeyStore();
        if (ks == null) {
            return new ArrayList<KeyManager>(0);
        }
        KeyManagerFactory tmf = KeyManagerFactory.getInstance(this.keyStoreAlgorithm);
        tmf.init(ks, !this.isOk(this.keyStoreKeyPassword) ? null : this.keyStoreKeyPassword.toCharArray());
        KeyManager[] keystoreManagers = tmf.getKeyManagers();
        if (keystoreManagers != null && "bks".equalsIgnoreCase(this.keyStoreType)) {
            String alias = this.getKeyAlias();
            if ("JKS".equalsIgnoreCase(this.keyStoreType)) {
                alias = alias.toLowerCase(Locale.ENGLISH);
            }
            for (int i = 0; i < keystoreManagers.length; ++i) {
                keystoreManagers[i] = new JSSEKeyManager((X509KeyManager)keystoreManagers[i], alias);
            }
        }
        return Arrays.asList(tmf.getKeyManagers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore createTrustManagerKeyStore() throws Exception {
        if (!this.isOk(this.trustStore)) {
            return null;
        }
        KeyStore ks = null;
        ks = "bks".equalsIgnoreCase(this.keyStoreType) ? GMKeyStore.getInstance() : KeyStore.getInstance(this.trustStoreType);
        InputStream is = Utils.tryGetInputStream(this.trustStore);
        try {
            ks.load(is, !this.isOk(this.trustStorePassword) ? null : this.trustStorePassword.toCharArray());
        }
        finally {
            is.close();
        }
        return ks;
    }

    private boolean isOk(String s) {
        return s != null && s.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore createKeyManagerKeyStore() throws Exception {
        if (!this.isOk(this.keyStore)) {
            return null;
        }
        KeyStore ks = null;
        ks = "bks".equalsIgnoreCase(this.keyStoreType) ? GMKeyStore.getInstance() : KeyStore.getInstance(this.keyStoreType);
        InputStream is = Utils.tryGetInputStream(this.keyStore);
        try {
            ks.load(is, !this.isOk(this.keyStorePassword) ? null : this.keyStorePassword.toCharArray());
        }
        finally {
            is.close();
        }
        return ks;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) throws MalformedURLException {
        this.keyStore = keyStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) throws MalformedURLException {
        this.trustStore = trustStore;
    }

    public String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String keyAlgorithm) {
        this.keyStoreAlgorithm = keyAlgorithm;
    }

    public String getTrustStoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public void setTrustStoreAlgorithm(String trustAlgorithm) {
        this.trustStoreAlgorithm = trustAlgorithm;
    }

    public String getKeyStoreKeyPassword() {
        return this.keyStoreKeyPassword;
    }

    public void setKeyStoreKeyPassword(String keyPassword) {
        this.keyStoreKeyPassword = keyPassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyPassword) {
        this.keyStorePassword = keyPassword;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustPassword) {
        this.trustStorePassword = trustPassword;
    }

    public void setKeyStoreType(String keyType) {
        this.keyStoreType = keyType;
    }

    public void setTrustStoreType(String trustType) {
        this.trustStoreType = trustType;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }
}

