/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.state;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.SessionId;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.command.TransactionId;
import com.bes.mq.state.SessionState;
import com.bes.mq.state.TransactionState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionState {
    ConnectionInfo info;
    private final ConcurrentHashMap<TransactionId, TransactionState> transactions = new ConcurrentHashMap();
    private final ConcurrentHashMap<SessionId, SessionState> sessions = new ConcurrentHashMap();
    private final List<DestinationInfo> tempDestinations = Collections.synchronizedList(new ArrayList());
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean connectionInterruptProcessingComplete = true;
    private HashMap<ConsumerId, ConsumerInfo> recoveringPullConsumers;

    public ConnectionState(ConnectionInfo info) {
        this.info = info;
        this.addSession(new SessionInfo(info, -1L));
    }

    public String toString() {
        return this.info.toString();
    }

    public void reset(ConnectionInfo info) {
        this.info = info;
        this.transactions.clear();
        this.sessions.clear();
        this.tempDestinations.clear();
        this.shutdown.set(false);
        this.addSession(new SessionInfo(info, -1L));
    }

    public void addTempDestination(DestinationInfo info) {
        this.checkShutdown();
        this.tempDestinations.add(info);
    }

    public void removeTempDestination(BESMQDestination destination) {
        Iterator<DestinationInfo> iter = this.tempDestinations.iterator();
        while (iter.hasNext()) {
            DestinationInfo di = iter.next();
            if (!di.getDestination().equals(destination)) continue;
            iter.remove();
        }
    }

    public void addTransactionState(TransactionId id) {
        this.checkShutdown();
        this.transactions.put(id, new TransactionState(id));
    }

    public TransactionState getTransactionState(TransactionId id) {
        return this.transactions.get(id);
    }

    public Collection<TransactionState> getTransactionStates() {
        return this.transactions.values();
    }

    public TransactionState removeTransactionState(TransactionId id) {
        return this.transactions.remove(id);
    }

    public void addSession(SessionInfo info) {
        this.checkShutdown();
        this.sessions.put(info.getSessionId(), new SessionState(info));
    }

    public SessionState removeSession(SessionId id) {
        return this.sessions.remove(id);
    }

    public SessionState getSessionState(SessionId id) {
        return this.sessions.get(id);
    }

    public ConnectionInfo getInfo() {
        return this.info;
    }

    public Set<SessionId> getSessionIds() {
        return this.sessions.keySet();
    }

    public List<DestinationInfo> getTempDestinations() {
        return this.tempDestinations;
    }

    public Collection<SessionState> getSessionStates() {
        return this.sessions.values();
    }

    private void checkShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("Disposed");
        }
    }

    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            for (SessionState ss : this.sessions.values()) {
                ss.shutdown();
            }
        }
    }

    public Map<ConsumerId, ConsumerInfo> getRecoveringPullConsumers() {
        if (this.recoveringPullConsumers == null) {
            this.recoveringPullConsumers = new HashMap();
        }
        return this.recoveringPullConsumers;
    }

    public void setConnectionInterruptProcessingComplete(boolean connectionInterruptProcessingComplete) {
        this.connectionInterruptProcessingComplete = connectionInterruptProcessingComplete;
    }

    public boolean isConnectionInterruptProcessingComplete() {
        return this.connectionInterruptProcessingComplete;
    }
}

