/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.state;

import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.state.ConsumerState;
import com.bes.mq.state.ProducerState;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionState {
    final SessionInfo info;
    private final Map<ProducerId, ProducerState> producers = new ConcurrentHashMap<ProducerId, ProducerState>();
    private final Map<ConsumerId, ConsumerState> consumers = new ConcurrentHashMap<ConsumerId, ConsumerState>();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public SessionState(SessionInfo info) {
        this.info = info;
    }

    public String toString() {
        return this.info.toString();
    }

    public void addProducer(ProducerInfo info) {
        this.checkShutdown();
        this.producers.put(info.getProducerId(), new ProducerState(info));
    }

    public ProducerState removeProducer(ProducerId id) {
        ProducerState producerState = this.producers.remove(id);
        if (producerState != null && producerState.getTransactionState() != null) {
            producerState.getTransactionState().addProducerState(producerState);
        }
        return producerState;
    }

    public void addConsumer(ConsumerInfo info) {
        this.checkShutdown();
        this.consumers.put(info.getConsumerId(), new ConsumerState(info));
    }

    public ConsumerState removeConsumer(ConsumerId id) {
        return this.consumers.remove(id);
    }

    public SessionInfo getInfo() {
        return this.info;
    }

    public Set<ConsumerId> getConsumerIds() {
        return this.consumers.keySet();
    }

    public Set<ProducerId> getProducerIds() {
        return this.producers.keySet();
    }

    public Collection<ProducerState> getProducerStates() {
        return this.producers.values();
    }

    public ProducerState getProducerState(ProducerId producerId) {
        return this.producers.get(producerId);
    }

    public Collection<ConsumerState> getConsumerStates() {
        return this.consumers.values();
    }

    public ConsumerState getConsumerState(ConsumerId consumerId) {
        return this.consumers.get(consumerId);
    }

    private void checkShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("Disposed");
        }
    }

    public void shutdown() {
        this.shutdown.set(false);
    }
}

