/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.store.MessageStore;
import com.bes.mq.usage.MemoryUsage;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageStore
implements MessageStore {
    public static final FutureTask<Object> FUTURE = new FutureTask<Object>(new CallableImplementation());
    protected final BESMQDestination destination;
    protected boolean prioritizedMessages;

    public AbstractMessageStore(BESMQDestination destination) {
        this.destination = destination;
    }

    @Override
    public void dispose(ConnectionContext context) {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public BESMQDestination getDestination() {
        return this.destination;
    }

    @Override
    public void setMemoryUsage(MemoryUsage memoryUsage) {
    }

    @Override
    public void setBatch(MessageId messageId) throws IOException, Exception {
    }

    @Override
    public boolean isEmpty() throws Exception {
        return this.getMessageCount() == 0;
    }

    @Override
    public void setPrioritizedMessages(boolean prioritizedMessages) {
        this.prioritizedMessages = prioritizedMessages;
    }

    @Override
    public boolean isPrioritizedMessages() {
        return this.prioritizedMessages;
    }

    @Override
    public void addMessage(ConnectionContext context, Message message, boolean canOptimizeHint) throws IOException {
        this.addMessage(context, message);
    }

    @Override
    public Future<Object> asyncAddQueueMessage(ConnectionContext context, Message message) throws IOException {
        this.addMessage(context, message);
        return FUTURE;
    }

    @Override
    public Future<Object> asyncAddQueueMessage(ConnectionContext context, Message message, boolean canOptimizeHint) throws IOException {
        this.addMessage(context, message, canOptimizeHint);
        return FUTURE;
    }

    @Override
    public Future<Object> asyncAddTopicMessage(ConnectionContext context, Message message, boolean canOptimizeHint) throws IOException {
        this.addMessage(context, message, canOptimizeHint);
        return FUTURE;
    }

    @Override
    public Future<Object> asyncAddTopicMessage(ConnectionContext context, Message message) throws IOException {
        this.addMessage(context, message);
        return FUTURE;
    }

    @Override
    public void removeAsyncMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.removeMessage(context, ack);
    }

    static {
        FUTURE.run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CallableImplementation
    implements Callable<Object> {
        CallableImplementation() {
        }

        @Override
        public Object call() throws Exception {
            return null;
        }
    }
}

