/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store;

import com.bes.hsdb.util.LockFile;
import com.bes.mq.broker.AbstractLocker;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.hsdb.MessageDatabase;
import com.bes.mq.util.ServiceStopper;
import java.io.File;
import java.io.IOException;

public class SharedFileLocker
extends AbstractLocker {
    private static final Logger LOG = LoggerFactory.getLogger(SharedFileLocker.class);
    private LockFile lockFile;
    protected File directory = MessageDatabase.DEFAULT_DIRECTORY;

    public void doStart() throws Exception {
        if (this.lockFile == null) {
            File lockFileName = new File(this.directory, "lock");
            this.lockFile = new LockFile(lockFileName, true);
            if (this.failIfLocked) {
                this.lockFile.lock();
            } else {
                boolean locked = false;
                while (!this.isStopped() && !this.isStopping()) {
                    try {
                        this.lockFile.lock();
                        locked = true;
                        break;
                    }
                    catch (IOException e) {
                        this.lockAcquireFailed(e);
                        try {
                            Thread.sleep(this.lockAcquireSleepInterval);
                        }
                        catch (InterruptedException e1) {}
                    }
                }
                if (!locked) {
                    throw new IOException("Attempting to obtain lock aborted due to shutdown");
                }
            }
        }
    }

    public void doStop(ServiceStopper stopper) throws Exception {
        if (this.lockFile != null) {
            this.lockFile.unlock();
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void configure(PersistenceAdapter persistenceAdapter) throws IOException {
        this.setDirectory(persistenceAdapter.getDirectory());
    }

    protected Logger getLogger() {
        return LOG;
    }
}

