/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.hsdb;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.LockableServiceSupport;
import com.bes.mq.broker.Locker;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.LocalTransactionId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.XATransactionId;
import com.bes.mq.protobuf.Buffer;
import com.bes.mq.store.MessageStore;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.SharedFileLocker;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.TransactionStore;
import com.bes.mq.store.hsdb.HSDBStore;
import com.bes.mq.store.hsdb.data.HSLocalTransactionId;
import com.bes.mq.store.hsdb.data.HSTransactionInfo;
import com.bes.mq.store.hsdb.data.HSXATransactionId;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.util.ServiceStopper;
import java.io.File;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSDBPersistenceAdapter
extends LockableServiceSupport
implements PersistenceAdapter {
    private final HSDBStore letter = new HSDBStore();

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        this.letter.beginTransaction(context);
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
        this.letter.checkpoint(sync);
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        this.letter.commitTransaction(context);
    }

    @Override
    public MessageStore createQueueMessageStore(BESMQQueue destination) throws IOException {
        return this.letter.createQueueMessageStore(destination);
    }

    @Override
    public TopicMessageStore createTopicMessageStore(BESMQTopic destination) throws IOException {
        return this.letter.createTopicMessageStore(destination);
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        return this.letter.createTransactionStore();
    }

    @Override
    public void deleteAllMessages() throws IOException {
        this.letter.deleteAllMessages();
    }

    @Override
    public Set<BESMQDestination> getDestinations() {
        return this.letter.getDestinations();
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return this.letter.getLastMessageBrokerSequenceId();
    }

    @Override
    public long getLastProducerSequenceId(ProducerId id) throws IOException {
        return this.letter.getLastProducerSequenceId(id);
    }

    @Override
    public void removeQueueMessageStore(BESMQQueue destination) {
        this.letter.removeQueueMessageStore(destination);
    }

    @Override
    public void removeTopicMessageStore(BESMQTopic destination) {
        this.letter.removeTopicMessageStore(destination);
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        this.letter.rollbackTransaction(context);
    }

    @Override
    public void setBrokerName(String brokerName) {
        this.letter.setBrokerName(brokerName);
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
        this.letter.setUsageManager(usageManager);
    }

    @Override
    public long size() {
        return this.letter.size();
    }

    @Override
    public void doStart() throws Exception {
        this.letter.start();
    }

    @Override
    public void doStop(ServiceStopper stopper) throws Exception {
        this.letter.stop();
    }

    public long getJournalMaxFileLength() {
        return this.letter.getJournalMaxFileLength();
    }

    public void setJournalMaxFileLength(long journalMaxFileLength) {
        this.letter.setJournalMaxFileLength(journalMaxFileLength);
    }

    public void setMaxFailoverProducersToTrack(int maxFailoverProducersToTrack) {
        this.letter.setMaxFailoverProducersToTrack(maxFailoverProducersToTrack);
    }

    public int getMaxFailoverProducersToTrack() {
        return this.letter.getMaxFailoverProducersToTrack();
    }

    public void setFailoverProducersAuditDepth(int failoverProducersAuditDepth) {
        this.letter.setFailoverProducersAuditDepth(failoverProducersAuditDepth);
    }

    public int getFailoverProducersAuditDepth() {
        return this.letter.getFailoverProducersAuditDepth();
    }

    public long getCheckpointInterval() {
        return this.letter.getCheckpointInterval();
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.letter.setCheckpointInterval(checkpointInterval);
    }

    public long getCleanupInterval() {
        return this.letter.getCleanupInterval();
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.letter.setCleanupInterval(cleanupInterval);
    }

    public int getIndexWriteBatchSize() {
        return this.letter.getIndexWriteBatchSize();
    }

    public void setIndexWriteBatchSize(int indexWriteBatchSize) {
        this.letter.setIndexWriteBatchSize(indexWriteBatchSize);
    }

    public int getJournalMaxWriteBatchSize() {
        return this.letter.getJournalMaxWriteBatchSize();
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.letter.setJournalMaxWriteBatchSize(journalMaxWriteBatchSize);
    }

    public boolean isEnableIndexWriteAsync() {
        return this.letter.isEnableIndexWriteAsync();
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.letter.setEnableIndexWriteAsync(enableIndexWriteAsync);
    }

    @Override
    public File getDirectory() {
        return this.letter.getDirectory();
    }

    @Override
    public void setDirectory(File dir) {
        this.letter.setDirectory(dir);
    }

    public boolean isEnableJournalDiskSyncs() {
        return this.letter.isEnableJournalDiskSyncs();
    }

    public void setEnableJournalDiskSyncs(boolean enableJournalDiskSyncs) {
        this.letter.setEnableJournalDiskSyncs(enableJournalDiskSyncs);
    }

    public boolean isSyncJournalFileMetaData() {
        return this.letter.isSyncJournalFileMetaData();
    }

    public void setSyncJournalFileMetaData(boolean syncJournalFileMetaData) {
        this.letter.setSyncJournalFileMetaData(syncJournalFileMetaData);
    }

    public boolean isInitJournalFileAhead() {
        return this.letter.isInitJournalFileAhead();
    }

    public void setInitJournalFileAhead(boolean initJournalFileAhead) {
        this.letter.setInitJournalFileAhead(initJournalFileAhead);
    }

    public int getIndexCacheSize() {
        return this.letter.getIndexCacheSize();
    }

    public void setIndexCacheSize(int indexCacheSize) {
        this.letter.setIndexCacheSize(indexCacheSize);
    }

    public boolean isIgnoreMissingJournalfiles() {
        return this.letter.isIgnoreMissingJournalfiles();
    }

    public void setIgnoreMissingJournalfiles(boolean ignoreMissingJournalfiles) {
        this.letter.setIgnoreMissingJournalfiles(ignoreMissingJournalfiles);
    }

    public boolean isChecksumJournalFiles() {
        return this.letter.isChecksumJournalFiles();
    }

    public boolean isCheckForCorruptJournalFiles() {
        return this.letter.isCheckForCorruptJournalFiles();
    }

    public void setChecksumJournalFiles(boolean checksumJournalFiles) {
        this.letter.setChecksumJournalFiles(checksumJournalFiles);
    }

    public void setCheckForCorruptJournalFiles(boolean checkForCorruptJournalFiles) {
        this.letter.setCheckForCorruptJournalFiles(checkForCorruptJournalFiles);
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        super.setBrokerService(brokerService);
        this.letter.setBrokerService(brokerService);
    }

    public boolean isArchiveDataLogs() {
        return this.letter.isArchiveDataLogs();
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.letter.setArchiveDataLogs(archiveDataLogs);
    }

    public File getDirectoryArchive() {
        return this.letter.getDirectoryArchive();
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.letter.setDirectoryArchive(directoryArchive);
    }

    public boolean isConcurrentStoreAndDispatchQueues() {
        return this.letter.isConcurrentStoreAndDispatchQueues();
    }

    public void setConcurrentStoreAndDispatchQueues(boolean concurrentStoreAndDispatch) {
        this.letter.setConcurrentStoreAndDispatchQueues(concurrentStoreAndDispatch);
    }

    public boolean isConcurrentStoreAndDispatchTopics() {
        return this.letter.isConcurrentStoreAndDispatchTopics();
    }

    public void setConcurrentStoreAndDispatchTopics(boolean concurrentStoreAndDispatch) {
        this.letter.setConcurrentStoreAndDispatchTopics(concurrentStoreAndDispatch);
    }

    public int getMaxAsyncJobs() {
        return this.letter.getMaxAsyncJobs();
    }

    public void setMaxAsyncJobs(int maxAsyncJobs) {
        this.letter.setMaxAsyncJobs(maxAsyncJobs);
    }

    @Deprecated
    public void setDatabaseLockedWaitDelay(int databaseLockedWaitDelay) throws IOException {
        this.getLocker().setLockAcquireSleepInterval(databaseLockedWaitDelay);
    }

    public boolean getForceRecoverIndex() {
        return this.letter.getForceRecoverIndex();
    }

    public void setForceRecoverIndex(boolean forceRecoverIndex) {
        this.letter.setForceRecoverIndex(forceRecoverIndex);
    }

    public boolean isArchiveCorruptedIndex() {
        return this.letter.isArchiveCorruptedIndex();
    }

    public void setArchiveCorruptedIndex(boolean archiveCorruptedIndex) {
        this.letter.setArchiveCorruptedIndex(archiveCorruptedIndex);
    }

    public void setRewriteOnRedelivery(boolean rewriteOnRedelivery) {
        this.letter.setRewriteOnRedelivery(rewriteOnRedelivery);
    }

    public boolean isRewriteOnRedelivery() {
        return this.letter.isRewriteOnRedelivery();
    }

    public float getIndexLFUEvictionFactor() {
        return this.letter.getIndexLFUEvictionFactor();
    }

    public void setIndexLFUEvictionFactor(float indexLFUEvictionFactor) {
        this.letter.setIndexLFUEvictionFactor(indexLFUEvictionFactor);
    }

    public boolean isUseIndexLFRUEviction() {
        return this.letter.isUseIndexLFRUEviction();
    }

    public void setUseIndexLFRUEviction(boolean useIndexLFRUEviction) {
        this.letter.setUseIndexLFRUEviction(useIndexLFRUEviction);
    }

    public void setEnableIndexDiskSyncs(boolean diskSyncs) {
        this.letter.setEnableIndexDiskSyncs(diskSyncs);
    }

    public boolean isEnableIndexDiskSyncs() {
        return this.letter.isEnableIndexDiskSyncs();
    }

    public void setEnableIndexRecoveryFile(boolean enable) {
        this.letter.setEnableIndexRecoveryFile(enable);
    }

    public boolean isEnableIndexRecoveryFile() {
        return this.letter.isEnableIndexRecoveryFile();
    }

    public void setEnableIndexPageCaching(boolean enable) {
        this.letter.setEnableIndexPageCaching(enable);
    }

    public boolean isEnableIndexPageCaching() {
        return this.letter.isEnableIndexPageCaching();
    }

    public HSDBStore getStore() {
        return this.letter;
    }

    public HSTransactionInfo createTransactionInfo(TransactionId txid) {
        if (txid == null) {
            return null;
        }
        HSTransactionInfo rc = new HSTransactionInfo();
        if (txid.isLocalTransaction()) {
            LocalTransactionId t = (LocalTransactionId)txid;
            HSLocalTransactionId hsTxId = new HSLocalTransactionId();
            hsTxId.setConnectionId(t.getConnectionId().getValue());
            hsTxId.setTransactionId(t.getValue());
            rc.setLocalTransactionId(hsTxId);
        } else {
            XATransactionId t = (XATransactionId)txid;
            HSXATransactionId hsTxId = new HSXATransactionId();
            hsTxId.setBranchQualifier(new Buffer(t.getBranchQualifier()));
            hsTxId.setGlobalTransactionId(new Buffer(t.getGlobalTransactionId()));
            hsTxId.setFormatId(t.getFormatId());
            rc.setXaTransactionId(hsTxId);
        }
        return rc;
    }

    @Override
    public Locker createDefaultLocker() throws IOException {
        SharedFileLocker locker = new SharedFileLocker();
        locker.configure(this);
        return locker;
    }

    @Override
    public void init() throws Exception {
    }

    public String toString() {
        String path = this.getDirectory() != null ? this.getDirectory().getAbsolutePath() : "DIRECTORY_NOT_SET";
        return "HSDBPersistenceAdapter[" + path + "]";
    }
}

