/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.hsdb;

import com.bes.hsdb.journal.Location;
import com.bes.hsdb.page.Transaction;
import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTempQueue;
import com.bes.mq.command.BESMQTempTopic;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.SubscriptionInfo;
import com.bes.mq.command.TransactionId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protobuf.Buffer;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.store.AbstractMessageStore;
import com.bes.mq.store.MessageRecoveryListener;
import com.bes.mq.store.MessageStore;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.TransactionStore;
import com.bes.mq.store.hsdb.HSDBTransactionStore;
import com.bes.mq.store.hsdb.MessageDatabase;
import com.bes.mq.store.hsdb.TopicMessageStoreExt;
import com.bes.mq.store.hsdb.TransactionIdConversion;
import com.bes.mq.store.hsdb.TransactionIdTransformer;
import com.bes.mq.store.hsdb.data.HSAddMessageCommand;
import com.bes.mq.store.hsdb.data.HSDestination;
import com.bes.mq.store.hsdb.data.HSLocation;
import com.bes.mq.store.hsdb.data.HSRemoveDestinationCommand;
import com.bes.mq.store.hsdb.data.HSRemoveMessageCommand;
import com.bes.mq.store.hsdb.data.HSSubscriptionCommand;
import com.bes.mq.store.hsdb.data.HSTransactionInfo;
import com.bes.mq.usage.MemoryUsage;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ThreadPoolUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSDBStore
extends MessageDatabase
implements PersistenceAdapter {
    static final Logger LOG = LoggerFactory.getLogger(HSDBStore.class);
    private static final int MAX_ASYNC_JOBS = 10000;
    public static final String PROPERTY_CANCELED_TASK_MOD_METRIC = "com.bes.mq.store.hsdb.CANCELED_TASK_MOD_METRIC";
    public static final int cancelledTaskModMetric = Integer.parseInt(System.getProperty("com.bes.mq.store.hsdb.CANCELED_TASK_MOD_METRIC", "0"), 10);
    public static final String PROPERTY_ASYNC_EXECUTOR_MAX_THREADS = "com.bes.mq.store.hsdb.ASYNC_EXECUTOR_MAX_THREADS";
    private static final int asyncExecutorMaxThreads = Integer.parseInt(System.getProperty("com.bes.mq.store.hsdb.ASYNC_EXECUTOR_MAX_THREADS", "1"), 10);
    protected ExecutorService queueExecutor;
    protected ExecutorService topicExecutor;
    protected final List<Map<AsyncJobKey, StoreTask>> asyncQueueMaps = new LinkedList<Map<AsyncJobKey, StoreTask>>();
    protected final List<Map<AsyncJobKey, StoreTask>> asyncTopicMaps = new LinkedList<Map<AsyncJobKey, StoreTask>>();
    final ProtocolFormat protocolFormat = new BESMPFormat();
    private SystemUsage usageManager;
    private LinkedBlockingQueue<Runnable> asyncQueueJobQueue;
    private LinkedBlockingQueue<Runnable> asyncTopicJobQueue;
    Semaphore globalQueueSemaphore;
    Semaphore globalTopicSemaphore;
    private boolean concurrentStoreAndDispatchQueues = true;
    private boolean concurrentStoreAndDispatchTopics = false;
    private boolean concurrentStoreAndDispatchTransactions = false;
    private int maxAsyncJobs = 10000;
    private final HSDBTransactionStore transactionStore = new HSDBTransactionStore(this);
    private TransactionIdTransformer transactionIdTransformer = new TransactionIdTransformer(){

        public HSTransactionInfo transform(TransactionId txid) {
            return TransactionIdConversion.convert(txid);
        }
    };

    public String toString() {
        return "HSDB:[" + this.directory.getAbsolutePath() + "]";
    }

    @Override
    public void setBrokerName(String brokerName) {
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
        this.usageManager = usageManager;
    }

    public SystemUsage getUsageManager() {
        return this.usageManager;
    }

    public boolean isConcurrentStoreAndDispatchQueues() {
        return this.concurrentStoreAndDispatchQueues;
    }

    public void setConcurrentStoreAndDispatchQueues(boolean concurrentStoreAndDispatch) {
        this.concurrentStoreAndDispatchQueues = concurrentStoreAndDispatch;
    }

    public boolean isConcurrentStoreAndDispatchTopics() {
        return this.concurrentStoreAndDispatchTopics;
    }

    public void setConcurrentStoreAndDispatchTopics(boolean concurrentStoreAndDispatch) {
        this.concurrentStoreAndDispatchTopics = concurrentStoreAndDispatch;
    }

    public boolean isConcurrentStoreAndDispatchTransactions() {
        return this.concurrentStoreAndDispatchTransactions;
    }

    public int getMaxAsyncJobs() {
        return this.maxAsyncJobs;
    }

    public void setMaxAsyncJobs(int maxAsyncJobs) {
        this.maxAsyncJobs = maxAsyncJobs;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.globalQueueSemaphore = new Semaphore(this.getMaxAsyncJobs());
        this.globalTopicSemaphore = new Semaphore(this.getMaxAsyncJobs());
        this.asyncQueueJobQueue = new LinkedBlockingQueue(this.getMaxAsyncJobs());
        this.asyncTopicJobQueue = new LinkedBlockingQueue(this.getMaxAsyncJobs());
        this.queueExecutor = new StoreTaskExecutor(1, asyncExecutorMaxThreads, 0L, TimeUnit.MILLISECONDS, this.asyncQueueJobQueue, new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "ConcurrentQueueStoreAndDispatch");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.topicExecutor = new StoreTaskExecutor(1, asyncExecutorMaxThreads, 0L, TimeUnit.MILLISECONDS, this.asyncTopicJobQueue, new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "ConcurrentTopicStoreAndDispatch");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop(ServiceStopper stopper) throws Exception {
        Map<AsyncJobKey, StoreTask> map;
        Map<AsyncJobKey, StoreTask> m;
        Iterator<Map<AsyncJobKey, StoreTask>> i$;
        LOG.info("Stopping async queue tasks");
        if (this.globalQueueSemaphore != null) {
            this.globalQueueSemaphore.tryAcquire(this.maxAsyncJobs, 60L, TimeUnit.SECONDS);
        }
        List<Map<AsyncJobKey, StoreTask>> list = this.asyncQueueMaps;
        synchronized (list) {
            i$ = this.asyncQueueMaps.iterator();
            while (i$.hasNext()) {
                map = m = i$.next();
                synchronized (map) {
                    for (StoreTask task : m.values()) {
                        task.cancel();
                    }
                }
            }
            this.asyncQueueMaps.clear();
        }
        LOG.info("Stopping async topic tasks");
        if (this.globalTopicSemaphore != null) {
            this.globalTopicSemaphore.tryAcquire(this.maxAsyncJobs, 60L, TimeUnit.SECONDS);
        }
        list = this.asyncTopicMaps;
        synchronized (list) {
            i$ = this.asyncTopicMaps.iterator();
            while (i$.hasNext()) {
                map = m = i$.next();
                synchronized (map) {
                    for (StoreTask task : m.values()) {
                        task.cancel();
                    }
                }
            }
            this.asyncTopicMaps.clear();
        }
        if (this.globalQueueSemaphore != null) {
            this.globalQueueSemaphore.drainPermits();
        }
        if (this.globalTopicSemaphore != null) {
            this.globalTopicSemaphore.drainPermits();
        }
        if (this.queueExecutor != null) {
            ThreadPoolUtils.shutdownNow(this.queueExecutor);
            this.queueExecutor = null;
        }
        if (this.topicExecutor != null) {
            ThreadPoolUtils.shutdownNow(this.topicExecutor);
            this.topicExecutor = null;
        }
        LOG.info("Stopped HSDB");
        super.doStop(stopper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void incrementRedeliveryAndReWrite(final String key, final HSDestination destination) throws IOException {
        Location location;
        this.indexLock.writeLock().lock();
        try {
            location = this.findMessageLocation(key, destination);
            Object var5_4 = null;
            this.indexLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.indexLock.writeLock().unlock();
            throw throwable;
        }
        if (location != null) {
            HSAddMessageCommand addMessage = (HSAddMessageCommand)this.load(location);
            Message message = (Message)this.protocolFormat.unmarshal(new DataInputStream((InputStream)addMessage.getMessage().newInput()));
            message.incrementRedeliveryCounter();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Rewriting: " + key + " with deliveryCount: " + message.getRedeliveryCounter());
            }
            ByteSequence packet = this.protocolFormat.marshal(message);
            addMessage.setMessage(new Buffer(packet.getData(), packet.getOffset(), packet.getLength()));
            final Location rewriteLocation = this.journal.write(this.toByteSequence(addMessage), true);
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                    public void execute(Transaction tx) throws IOException {
                        MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(destination, tx);
                        Long sequence = (Long)sd.messageIdIndex.get(tx, (Object)key);
                        MessageDatabase.MessageKeys keys = sd.orderIndex.get(tx, sequence);
                        sd.orderIndex.put(tx, sd.orderIndex.lastGetPriority(), sequence, new MessageDatabase.MessageKeys(keys.messageId, rewriteLocation));
                    }
                });
                Object var9_10 = null;
                this.indexLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.indexLock.writeLock().unlock();
                throw throwable;
            }
        }
    }

    @Override
    void rollbackStatsOnDuplicate(HSDestination commandDestination) {
        RegionBroker regionBroker;
        if (this.brokerService != null && (regionBroker = (RegionBroker)this.brokerService.getRegionBroker()) != null) {
            Set<Destination> destinationSet = regionBroker.getDestinations(this.convert(commandDestination));
            for (Destination destination : destinationSet) {
                destination.getDestinationStatistics().getMessages().decrement();
                destination.getDestinationStatistics().getEnqueues().decrement();
            }
        }
    }

    private Location findMessageLocation(final String key, final HSDestination destination) throws IOException {
        return (Location)this.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<Location, IOException>(){

            public Location execute(Transaction tx) throws IOException {
                MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(destination, tx);
                Long sequence = (Long)sd.messageIdIndex.get(tx, (Object)key);
                if (sequence == null) {
                    return null;
                }
                return sd.orderIndex.get((Transaction)tx, (Long)sequence).location;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoreQueueTask removeQueueTask(HSDBMessageStore store, MessageId id) {
        StoreQueueTask task = null;
        Map<AsyncJobKey, StoreTask> map = store.asyncTaskMap;
        synchronized (map) {
            task = (StoreQueueTask)store.asyncTaskMap.remove(new AsyncJobKey(id, store.getDestination()));
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addQueueTask(HSDBMessageStore store, StoreQueueTask task) throws IOException {
        Map<AsyncJobKey, StoreTask> map = store.asyncTaskMap;
        synchronized (map) {
            store.asyncTaskMap.put(new AsyncJobKey(task.getMessage().getMessageId(), store.getDestination()), task);
        }
        this.queueExecutor.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoreTopicTask removeTopicTask(HSDBTopicMessageStore store, MessageId id) {
        StoreTopicTask task = null;
        Map map = store.asyncTaskMap;
        synchronized (map) {
            task = (StoreTopicTask)store.asyncTaskMap.remove(new AsyncJobKey(id, store.getDestination()));
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTopicTask(HSDBTopicMessageStore store, StoreTopicTask task) throws IOException {
        Map map = store.asyncTaskMap;
        synchronized (map) {
            store.asyncTaskMap.put(new AsyncJobKey(task.getMessage().getMessageId(), store.getDestination()), task);
        }
        this.topicExecutor.execute(task);
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        return this.transactionStore;
    }

    public boolean getForceRecoverIndex() {
        return this.forceRecoverIndex;
    }

    public void setForceRecoverIndex(boolean forceRecoverIndex) {
        this.forceRecoverIndex = forceRecoverIndex;
    }

    String subscriptionKey(String clientId, String subscriptionName) {
        return clientId + ":" + subscriptionName;
    }

    @Override
    public MessageStore createQueueMessageStore(BESMQQueue destination) throws IOException {
        return this.transactionStore.proxy(new HSDBMessageStore(destination));
    }

    @Override
    public TopicMessageStore createTopicMessageStore(BESMQTopic destination) throws IOException {
        return this.transactionStore.proxy(new HSDBTopicMessageStore(destination));
    }

    @Override
    public void removeQueueMessageStore(BESMQQueue destination) {
    }

    @Override
    public void removeTopicMessageStore(BESMQTopic destination) {
    }

    @Override
    public void deleteAllMessages() throws IOException {
        this.deleteAllMessages = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BESMQDestination> getDestinations() {
        try {
            final HashSet<BESMQDestination> rc = new HashSet<BESMQDestination>();
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                    public void execute(Transaction tx) throws IOException {
                        Iterator iterator = HSDBStore.this.metadata.destinations.iterator(tx);
                        while (iterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator.next();
                            if (this.isEmptyTopic(entry, tx)) continue;
                            rc.add(HSDBStore.this.convert((String)entry.getKey()));
                        }
                    }

                    private boolean isEmptyTopic(Map.Entry<String, MessageDatabase.StoredDestination> entry, Transaction tx) throws IOException {
                        boolean isEmptyTopic = false;
                        BESMQDestination dest = HSDBStore.this.convert(entry.getKey());
                        if (dest.isTopic()) {
                            MessageDatabase.StoredDestination loadedStore = HSDBStore.this.getStoredDestination(HSDBStore.this.convert(dest), tx);
                            if (loadedStore.subscriptionAcks.isEmpty(tx)) {
                                isEmptyTopic = true;
                            }
                        }
                        return isEmptyTopic;
                    }
                });
                Object var3_3 = null;
                this.indexLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.indexLock.writeLock().unlock();
                throw throwable;
            }
            return rc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastProducerSequenceId(ProducerId id) {
        this.indexLock.readLock().lock();
        try {
            long l = this.metadata.producerSequenceIdTracker.getLastSeqId(id);
            Object var5_3 = null;
            this.indexLock.readLock().unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.indexLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public long size() {
        try {
            return this.journalSize.get() + this.getPageFile().getDiskSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
        super.checkpointCleanup(sync);
    }

    Message loadMessage(Location location) throws IOException {
        HSAddMessageCommand addMessage = (HSAddMessageCommand)this.load(location);
        Message msg = (Message)this.protocolFormat.unmarshal(new DataInputStream((InputStream)addMessage.getMessage().newInput()));
        return msg;
    }

    HSLocation convert(Location location) {
        HSLocation rc = new HSLocation();
        rc.setLogId(location.getDataFileId());
        rc.setOffset(location.getOffset());
        return rc;
    }

    HSDestination convert(BESMQDestination dest) {
        HSDestination rc = new HSDestination();
        rc.setName(dest.getPhysicalName());
        switch (dest.getDestinationType()) {
            case 1: {
                rc.setType(HSDestination.DestinationType.QUEUE);
                return rc;
            }
            case 2: {
                rc.setType(HSDestination.DestinationType.TOPIC);
                return rc;
            }
            case 5: {
                rc.setType(HSDestination.DestinationType.TEMP_QUEUE);
                return rc;
            }
            case 6: {
                rc.setType(HSDestination.DestinationType.TEMP_TOPIC);
                return rc;
            }
        }
        return null;
    }

    BESMQDestination convert(String dest) {
        int p = dest.indexOf(":");
        if (p < 0) {
            throw new IllegalArgumentException("Not in the valid destination format");
        }
        int type = Integer.parseInt(dest.substring(0, p));
        String name = dest.substring(p + 1);
        return this.convert(type, name);
    }

    private BESMQDestination convert(HSDestination commandDestination) {
        return this.convert(commandDestination.getType().getNumber(), commandDestination.getName());
    }

    private BESMQDestination convert(int type, String name) {
        switch (HSDestination.DestinationType.valueOf(type)) {
            case QUEUE: {
                return new BESMQQueue(name);
            }
            case TOPIC: {
                return new BESMQTopic(name);
            }
            case TEMP_QUEUE: {
                return new BESMQTempQueue(name);
            }
            case TEMP_TOPIC: {
                return new BESMQTempTopic(name);
            }
        }
        throw new IllegalArgumentException("Not in the valid destination format");
    }

    public TransactionIdTransformer getTransactionIdTransformer() {
        return this.transactionIdTransformer;
    }

    public void setTransactionIdTransformer(TransactionIdTransformer transactionIdTransformer) {
        this.transactionIdTransformer = transactionIdTransformer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StoreTaskExecutor
    extends ThreadPoolExecutor {
        public StoreTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit timeUnit, BlockingQueue<Runnable> queue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, queue, threadFactory);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            super.afterExecute(runnable, throwable);
            if (runnable instanceof StoreTask) {
                ((StoreTask)((Object)runnable)).releaseLocks();
            }
        }
    }

    class StoreTopicTask
    extends StoreQueueTask {
        private final int subscriptionCount;
        private final List<String> subscriptionKeys;
        private final HSDBTopicMessageStore topicStore;

        public StoreTopicTask(HSDBTopicMessageStore store, ConnectionContext context, Message message, int subscriptionCount) {
            super(store, context, message);
            this.subscriptionKeys = new ArrayList<String>(1);
            this.topicStore = store;
            this.subscriptionCount = subscriptionCount;
        }

        public void aquireLocks() {
            if (this.locked.compareAndSet(false, true)) {
                try {
                    HSDBStore.this.globalTopicSemaphore.acquire();
                    this.store.acquireLocalAsyncLock();
                    this.message.incrementReferenceCount();
                }
                catch (InterruptedException e) {
                    LOG.warn("Failed to acquire lock", e);
                }
            }
        }

        public void releaseLocks() {
            if (this.locked.compareAndSet(true, false)) {
                this.message.decrementReferenceCount();
                this.store.releaseLocalAsyncLock();
                HSDBStore.this.globalTopicSemaphore.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addSubscriptionKey(String key) {
            List<String> list = this.subscriptionKeys;
            synchronized (list) {
                this.subscriptionKeys.add(key);
            }
            return this.subscriptionKeys.size() >= this.subscriptionCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                this.store.doneTasks += 1.0;
                try {
                    if (this.done.compareAndSet(false, true)) {
                        this.topicStore.addMessage(this.context, this.message);
                        List<String> list = this.subscriptionKeys;
                        synchronized (list) {
                            for (String key : this.subscriptionKeys) {
                                this.topicStore.doAcknowledge(this.context, key, this.message.getMessageId(), null);
                            }
                        }
                        HSDBStore.this.removeTopicTask(this.topicStore, this.message.getMessageId());
                        this.future.complete();
                        break block9;
                    }
                    if (cancelledTaskModMetric > 0) {
                        double d = this.store.canceledTasks;
                        this.store.canceledTasks = d + 1.0;
                        if (d % (double)cancelledTaskModMetric == 0.0) {
                            System.err.println(this.store.dest.getName() + " cancelled: " + this.store.canceledTasks / this.store.doneTasks * 100.0);
                            this.store.doneTasks = 0.0;
                            this.store.canceledTasks = 0.0;
                        }
                    }
                }
                catch (Exception e) {
                    this.future.setException(e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StoreQueueTask
    implements Runnable,
    StoreTask {
        protected final Message message;
        protected final ConnectionContext context;
        protected final HSDBMessageStore store;
        protected final InnerFutureTask future;
        protected final AtomicBoolean done = new AtomicBoolean();
        protected final AtomicBoolean locked = new AtomicBoolean();

        public StoreQueueTask(HSDBMessageStore store, ConnectionContext context, Message message) {
            this.store = store;
            this.context = context;
            this.message = message;
            this.future = new InnerFutureTask(this);
        }

        public Future<Object> getFuture() {
            return this.future;
        }

        @Override
        public boolean cancel() {
            if (this.done.compareAndSet(false, true)) {
                return this.future.cancel(false);
            }
            return false;
        }

        @Override
        public void aquireLocks() {
            if (this.locked.compareAndSet(false, true)) {
                try {
                    HSDBStore.this.globalQueueSemaphore.acquire();
                    this.store.acquireLocalAsyncLock();
                    this.message.incrementReferenceCount();
                }
                catch (InterruptedException e) {
                    LOG.warn("Failed to acquire lock", e);
                }
            }
        }

        @Override
        public void releaseLocks() {
            if (this.locked.compareAndSet(true, false)) {
                this.store.releaseLocalAsyncLock();
                HSDBStore.this.globalQueueSemaphore.release();
                this.message.decrementReferenceCount();
            }
        }

        @Override
        public void run() {
            this.store.doneTasks += 1.0;
            try {
                if (this.done.compareAndSet(false, true)) {
                    this.store.addMessage(this.context, this.message);
                    HSDBStore.this.removeQueueTask(this.store, this.message.getMessageId());
                    this.future.complete();
                } else if (cancelledTaskModMetric > 0) {
                    double d = this.store.canceledTasks;
                    this.store.canceledTasks = d + 1.0;
                    if (d % (double)cancelledTaskModMetric == 0.0) {
                        System.err.println(this.store.dest.getName() + " cancelled: " + this.store.canceledTasks / this.store.doneTasks * 100.0);
                        this.store.doneTasks = 0.0;
                        this.store.canceledTasks = 0.0;
                    }
                }
            }
            catch (Exception e) {
                this.future.setException(e);
            }
        }

        protected Message getMessage() {
            return this.message;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class InnerFutureTask
        extends FutureTask<Object> {
            public InnerFutureTask(Runnable runnable) {
                super(runnable, null);
            }

            public void setException(Exception e) {
                super.setException(e);
            }

            public void complete() {
                super.set(null);
            }
        }
    }

    public static interface StoreTask {
        public boolean cancel();

        public void aquireLocks();

        public void releaseLocks();
    }

    static class AsyncJobKey {
        MessageId id;
        BESMQDestination destination;

        AsyncJobKey(MessageId id, BESMQDestination destination) {
            this.id = id;
            this.destination = destination;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof AsyncJobKey && this.id.equals(((AsyncJobKey)obj).id) && this.destination.equals(((AsyncJobKey)obj).destination);
        }

        public int hashCode() {
            return this.id.hashCode() + this.destination.hashCode();
        }

        public String toString() {
            return this.destination.getPhysicalName() + "-" + this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HSDBTopicMessageStore
    extends HSDBMessageStore
    implements TopicMessageStore,
    TopicMessageStoreExt {
        private final AtomicInteger subscriptionCount;

        public HSDBTopicMessageStore(BESMQTopic destination) throws IOException {
            super(destination);
            this.subscriptionCount = new AtomicInteger();
            this.subscriptionCount.set(this.getAllSubscriptions().length);
            HSDBStore.this.asyncTopicMaps.add(this.asyncTaskMap);
        }

        @Override
        public Future<Object> asyncAddTopicMessage(ConnectionContext context, Message message) throws IOException {
            if (HSDBStore.this.isConcurrentStoreAndDispatchTopics()) {
                StoreTopicTask result = new StoreTopicTask(this, context, message, this.subscriptionCount.get());
                result.aquireLocks();
                HSDBStore.this.addTopicTask(this, result);
                return result.getFuture();
            }
            return super.asyncAddTopicMessage(context, message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
            String subscriptionKey = HSDBStore.this.subscriptionKey(clientId, subscriptionName).toString();
            if (HSDBStore.this.isConcurrentStoreAndDispatchTopics()) {
                AsyncJobKey key = new AsyncJobKey(messageId, this.getDestination());
                StoreTopicTask task = null;
                Map map = this.asyncTaskMap;
                synchronized (map) {
                    task = (StoreTopicTask)this.asyncTaskMap.get(key);
                }
                if (task != null) {
                    if (task.addSubscriptionKey(subscriptionKey)) {
                        HSDBStore.this.removeTopicTask(this, messageId);
                        if (task.cancel()) {
                            map = this.asyncTaskMap;
                            synchronized (map) {
                                this.asyncTaskMap.remove(key);
                            }
                        }
                    }
                } else {
                    this.doAcknowledge(context, subscriptionKey, messageId, ack);
                }
            } else {
                this.doAcknowledge(context, subscriptionKey, messageId, ack);
            }
        }

        protected void doAcknowledge(ConnectionContext context, String subscriptionKey, MessageId messageId, MessageAck ack) throws IOException {
            HSRemoveMessageCommand command = new HSRemoveMessageCommand();
            command.setDestination(this.dest);
            command.setSubscriptionKey(subscriptionKey);
            command.setMessageId(messageId.toString());
            command.setTransactionInfo(ack != null ? HSDBStore.this.transactionIdTransformer.transform(ack.getTransactionId()) : null);
            if (ack != null && ack.isUnmatchedAck()) {
                command.setAck(MessageDatabase.UNMATCHED);
            } else {
                ByteSequence packet = HSDBStore.this.protocolFormat.marshal(ack);
                command.setAck(new Buffer(packet.getData(), packet.getOffset(), packet.getLength()));
            }
            HSDBStore.this.store(command, false, null, null);
        }

        @Override
        public void addSubsciption(SubscriptionInfo subscriptionInfo, boolean retroactive) throws IOException {
            String subscriptionKey = HSDBStore.this.subscriptionKey(subscriptionInfo.getClientId(), subscriptionInfo.getSubscriptionName());
            HSSubscriptionCommand command = new HSSubscriptionCommand();
            command.setDestination(this.dest);
            command.setSubscriptionKey(subscriptionKey.toString());
            command.setRetroactive(retroactive);
            ByteSequence packet = HSDBStore.this.protocolFormat.marshal(subscriptionInfo);
            command.setSubscriptionInfo(new Buffer(packet.getData(), packet.getOffset(), packet.getLength()));
            HSDBStore.this.store(command, HSDBStore.this.isEnableJournalDiskSyncs(), null, null);
            this.subscriptionCount.incrementAndGet();
        }

        @Override
        public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
            HSSubscriptionCommand command = new HSSubscriptionCommand();
            command.setDestination(this.dest);
            command.setSubscriptionKey(HSDBStore.this.subscriptionKey(clientId, subscriptionName).toString());
            HSDBStore.this.store(command, HSDBStore.this.isEnableJournalDiskSyncs(), null, null);
            this.subscriptionCount.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SubscriptionInfo[] getAllSubscriptions() throws IOException {
            final ArrayList subscriptions = new ArrayList();
            HSDBStore.this.indexLock.writeLock().lock();
            try {
                HSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                    public void execute(Transaction tx) throws IOException {
                        MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                        Iterator iterator = sd.subscriptions.iterator(tx);
                        while (iterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator.next();
                            SubscriptionInfo info = (SubscriptionInfo)HSDBStore.this.protocolFormat.unmarshal(new DataInputStream((InputStream)((HSSubscriptionCommand)entry.getValue()).getSubscriptionInfo().newInput()));
                            subscriptions.add(info);
                        }
                    }
                });
                Object var3_2 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                throw throwable;
            }
            SubscriptionInfo[] rc = new SubscriptionInfo[subscriptions.size()];
            subscriptions.toArray(rc);
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
            final String subscriptionKey = HSDBStore.this.subscriptionKey(clientId, subscriptionName);
            HSDBStore.this.indexLock.writeLock().lock();
            try {
                SubscriptionInfo subscriptionInfo = (SubscriptionInfo)HSDBStore.this.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<SubscriptionInfo, IOException>(){

                    public SubscriptionInfo execute(Transaction tx) throws IOException {
                        MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                        HSSubscriptionCommand command = (HSSubscriptionCommand)sd.subscriptions.get(tx, (Object)subscriptionKey);
                        if (command == null) {
                            return null;
                        }
                        return (SubscriptionInfo)HSDBStore.this.protocolFormat.unmarshal(new DataInputStream((InputStream)command.getSubscriptionInfo().newInput()));
                    }
                });
                Object var6_5 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                return subscriptionInfo;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getMessageCount(String clientId, String subscriptionName) throws IOException {
            final String subscriptionKey = HSDBStore.this.subscriptionKey(clientId, subscriptionName);
            HSDBStore.this.indexLock.writeLock().lock();
            try {
                int n = (Integer)HSDBStore.this.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<Integer, IOException>(){

                    public Integer execute(Transaction tx) throws IOException {
                        MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                        MessageDatabase.LastAck cursorPos = HSDBStore.this.getLastAck(tx, sd, subscriptionKey);
                        if (cursorPos == null) {
                            return 0;
                        }
                        return (int)HSDBStore.this.getStoredMessageCount(tx, sd, subscriptionKey);
                    }
                });
                Object var6_5 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recoverSubscription(String clientId, String subscriptionName, final MessageRecoveryListener listener) throws Exception {
            final String subscriptionKey = HSDBStore.this.subscriptionKey(clientId, subscriptionName);
            SubscriptionInfo info = this.lookupSubscription(clientId, subscriptionName);
            HSDBStore.this.indexLock.writeLock().lock();
            try {
                HSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<Exception>(){

                    public void execute(Transaction tx) throws Exception {
                        MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                        MessageDatabase.LastAck cursorPos = HSDBStore.this.getLastAck(tx, sd, subscriptionKey);
                        sd.orderIndex.setBatch(tx, cursorPos);
                        Iterator<Map.Entry<Long, MessageDatabase.MessageKeys>> iterator = sd.orderIndex.iterator(tx);
                        while (iterator.hasNext()) {
                            Map.Entry<Long, MessageDatabase.MessageKeys> entry = iterator.next();
                            if (HSDBStore.this.ackedAndPrepared.contains(entry.getValue().messageId)) continue;
                            listener.recoverMessage(HSDBStore.this.loadMessage(entry.getValue().location));
                        }
                        sd.orderIndex.resetCursorPosition();
                    }
                });
                Object var7_6 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recoverNextMessages(String clientId, String subscriptionName, final int maxReturned, final MessageRecoveryListener listener) throws Exception {
            final String subscriptionKey = HSDBStore.this.subscriptionKey(clientId, subscriptionName);
            SubscriptionInfo info = this.lookupSubscription(clientId, subscriptionName);
            HSDBStore.this.indexLock.writeLock().lock();
            try {
                HSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<Exception>(){

                    public void execute(Transaction tx) throws Exception {
                        MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                        sd.orderIndex.resetCursorPosition();
                        MessageDatabase.MessageOrderCursor moc = sd.subscriptionCursors.get(subscriptionKey);
                        if (moc == null) {
                            MessageDatabase.LastAck pos = HSDBStore.this.getLastAck(tx, sd, subscriptionKey);
                            if (pos == null) {
                                return;
                            }
                            sd.orderIndex.setBatch(tx, pos);
                            moc = sd.orderIndex.cursor;
                        } else {
                            sd.orderIndex.cursor.sync(moc);
                        }
                        Map.Entry<Long, MessageDatabase.MessageKeys> entry = null;
                        int counter = 0;
                        Iterator<Map.Entry<Long, MessageDatabase.MessageKeys>> iterator = sd.orderIndex.iterator(tx, moc);
                        while (iterator.hasNext() && listener.hasSpace()) {
                            entry = iterator.next();
                            if (HSDBStore.this.ackedAndPrepared.contains(entry.getValue().messageId)) continue;
                            if (listener.recoverMessage(HSDBStore.this.loadMessage(entry.getValue().location))) {
                                ++counter;
                            }
                            if (counter < maxReturned) continue;
                        }
                        sd.orderIndex.stoppedIterating();
                        if (entry != null) {
                            MessageDatabase.MessageOrderCursor copy = sd.orderIndex.cursor.copy();
                            sd.subscriptionCursors.put(subscriptionKey, copy);
                        }
                    }
                });
                Object var8_7 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBatch(final String clientId, final String subscriptionName, final MessageId identity, final int priority) throws IOException {
            try {
                this.lockAsyncJobQueue();
                HSDBStore.this.indexLock.writeLock().lock();
                try {
                    HSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                        public void execute(Transaction tx) throws IOException {
                            MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                            String subscriptionKey = HSDBStore.this.subscriptionKey(clientId, subscriptionName);
                            String key = identity.toString();
                            Long location = (Long)sd.messageIdIndex.get(tx, (Object)key);
                            if (location != null) {
                                this.resetSubscriptionCursor(sd, subscriptionKey, location);
                            }
                        }

                        private void resetSubscriptionCursor(MessageDatabase.StoredDestination sd, String subscriptionKey, Long location) {
                            MessageDatabase.MessageOrderCursor moc = sd.subscriptionCursors.get(subscriptionKey);
                            if (moc == null) {
                                moc = new MessageDatabase.MessageOrderCursor(HSDBStore.this);
                                sd.subscriptionCursors.put(subscriptionKey, moc);
                            }
                            sd.orderIndex.setOrderCursor(moc, location, (byte)priority);
                        }
                    });
                    Object var6_5 = null;
                    HSDBStore.this.indexLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    HSDBStore.this.indexLock.writeLock().unlock();
                    throw throwable;
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.unlockAsyncJobQueue();
                throw throwable;
            }
            this.unlockAsyncJobQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetBatching(String clientId, String subscriptionName) {
            try {
                final String subscriptionKey = HSDBStore.this.subscriptionKey(clientId, subscriptionName);
                HSDBStore.this.indexLock.writeLock().lock();
                try {
                    HSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                        public void execute(Transaction tx) throws IOException {
                            MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                            sd.subscriptionCursors.remove(subscriptionKey);
                        }
                    });
                    Object var5_5 = null;
                    HSDBStore.this.indexLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    HSDBStore.this.indexLock.writeLock().unlock();
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HSDBMessageStore
    extends AbstractMessageStore {
        protected final Map<AsyncJobKey, StoreTask> asyncTaskMap;
        protected HSDestination dest;
        private final int maxAsyncJobs;
        private final Semaphore localDestinationSemaphore;
        double doneTasks;
        double canceledTasks;

        public HSDBMessageStore(BESMQDestination destination) {
            super(destination);
            this.asyncTaskMap = new HashMap<AsyncJobKey, StoreTask>();
            this.canceledTasks = 0.0;
            this.dest = HSDBStore.this.convert(destination);
            this.maxAsyncJobs = HSDBStore.this.getMaxAsyncJobs();
            this.localDestinationSemaphore = new Semaphore(this.maxAsyncJobs);
        }

        @Override
        public BESMQDestination getDestination() {
            return this.destination;
        }

        @Override
        public Future<Object> asyncAddQueueMessage(ConnectionContext context, Message message) throws IOException {
            if (HSDBStore.this.isConcurrentStoreAndDispatchQueues()) {
                StoreQueueTask result = new StoreQueueTask(this, context, message);
                result.aquireLocks();
                HSDBStore.this.addQueueTask(this, result);
                return result.getFuture();
            }
            return super.asyncAddQueueMessage(context, message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void removeAsyncMessage(ConnectionContext context, MessageAck ack) throws IOException {
            if (HSDBStore.this.isConcurrentStoreAndDispatchQueues()) {
                AsyncJobKey key = new AsyncJobKey(ack.getLastMessageId(), this.getDestination());
                StoreQueueTask task = null;
                Map<AsyncJobKey, StoreTask> map = this.asyncTaskMap;
                synchronized (map) {
                    task = (StoreQueueTask)this.asyncTaskMap.get(key);
                }
                if (task != null) {
                    if (!task.cancel()) {
                        try {
                            task.future.get();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException(e.toString());
                        }
                        catch (Exception ignored) {
                            LOG.debug("removeAsync: waiting for adding result in ex", ignored);
                        }
                        this.removeMessage(context, ack);
                        return;
                    }
                    map = this.asyncTaskMap;
                    synchronized (map) {
                        this.asyncTaskMap.remove(key);
                        return;
                    }
                }
                this.removeMessage(context, ack);
                return;
            }
            this.removeMessage(context, ack);
        }

        @Override
        public void addMessage(ConnectionContext context, Message message) throws IOException {
            HSAddMessageCommand command = new HSAddMessageCommand();
            command.setDestination(this.dest);
            command.setMessageId(message.getMessageId().toString());
            command.setTransactionInfo(HSDBStore.this.transactionIdTransformer.transform(message.getTransactionId()));
            command.setPriority(message.getPriority());
            command.setPrioritySupported(this.isPrioritizedMessages());
            ByteSequence packet = HSDBStore.this.protocolFormat.marshal(message);
            command.setMessage(new Buffer(packet.getData(), packet.getOffset(), packet.getLength()));
            HSDBStore.this.store(command, HSDBStore.this.isEnableJournalDiskSyncs() && message.isResponseRequired(), null, null);
        }

        @Override
        public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
            HSRemoveMessageCommand command = new HSRemoveMessageCommand();
            command.setDestination(this.dest);
            command.setMessageId(ack.getLastMessageId().toString());
            command.setTransactionInfo(HSDBStore.this.transactionIdTransformer.transform(ack.getTransactionId()));
            ByteSequence packet = HSDBStore.this.protocolFormat.marshal(ack);
            command.setAck(new Buffer(packet.getData(), packet.getOffset(), packet.getLength()));
            HSDBStore.this.store(command, HSDBStore.this.isEnableJournalDiskSyncs() && ack.isResponseRequired(), null, null);
        }

        @Override
        public void removeAllMessages(ConnectionContext context) throws IOException {
            HSRemoveDestinationCommand command = new HSRemoveDestinationCommand();
            command.setDestination(this.dest);
            HSDBStore.this.store(command, true, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message getMessage(MessageId identity) throws IOException {
            Location location;
            String key = identity.toString();
            HSDBStore.this.indexLock.writeLock().lock();
            try {
                location = HSDBStore.this.findMessageLocation(key, this.dest);
                Object var5_4 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                throw throwable;
            }
            if (location == null) {
                return null;
            }
            return HSDBStore.this.loadMessage(location);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int getMessageCount() throws IOException {
            try {
                int n;
                this.lockAsyncJobQueue();
                HSDBStore.this.indexLock.writeLock().lock();
                try {
                    n = (Integer)HSDBStore.this.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<Integer, IOException>(){

                        public Integer execute(Transaction tx) throws IOException {
                            MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBMessageStore.this.dest, tx);
                            int rc = 0;
                            Iterator iterator = sd.locationIndex.iterator(tx);
                            while (iterator.hasNext()) {
                                iterator.next();
                                ++rc;
                            }
                            return rc;
                        }
                    });
                    Object var3_2 = null;
                    HSDBStore.this.indexLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    HSDBStore.this.indexLock.writeLock().unlock();
                    throw throwable;
                }
                Object var5_4 = null;
                this.unlockAsyncJobQueue();
                return n;
            }
            catch (Throwable throwable2) {
                Object var5_5 = null;
                this.unlockAsyncJobQueue();
                throw throwable2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() throws IOException {
            HSDBStore.this.indexLock.writeLock().lock();
            try {
                boolean bl = (Boolean)HSDBStore.this.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<Boolean, IOException>(){

                    public Boolean execute(Transaction tx) throws IOException {
                        MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBMessageStore.this.dest, tx);
                        return sd.locationIndex.isEmpty(tx);
                    }
                });
                Object var3_2 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recover(final MessageRecoveryListener listener) throws Exception {
            HSDBStore.this.indexLock.writeLock().lock();
            try {
                HSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<Exception>(){

                    public void execute(Transaction tx) throws Exception {
                        MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBMessageStore.this.dest, tx);
                        sd.orderIndex.resetCursorPosition();
                        Iterator<Map.Entry<Long, MessageDatabase.MessageKeys>> iterator = sd.orderIndex.iterator(tx);
                        while (listener.hasSpace() && iterator.hasNext()) {
                            Map.Entry<Long, MessageDatabase.MessageKeys> entry = iterator.next();
                            if (HSDBStore.this.ackedAndPrepared.contains(entry.getValue().messageId)) continue;
                            Message msg = HSDBStore.this.loadMessage(entry.getValue().location);
                            listener.recoverMessage(msg);
                        }
                    }
                });
                Object var3_2 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recoverNextMessages(final int maxReturned, final MessageRecoveryListener listener) throws Exception {
            HSDBStore.this.indexLock.writeLock().lock();
            try {
                HSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<Exception>(){

                    public void execute(Transaction tx) throws Exception {
                        MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBMessageStore.this.dest, tx);
                        Map.Entry<Long, MessageDatabase.MessageKeys> entry = null;
                        int counter = 0;
                        Iterator<Map.Entry<Long, MessageDatabase.MessageKeys>> iterator = sd.orderIndex.iterator(tx);
                        while (listener.hasSpace() && iterator.hasNext()) {
                            entry = iterator.next();
                            if (HSDBStore.this.ackedAndPrepared.contains(entry.getValue().messageId)) continue;
                            Message msg = HSDBStore.this.loadMessage(entry.getValue().location);
                            listener.recoverMessage(msg);
                            if (++counter < maxReturned) continue;
                            break;
                        }
                        sd.orderIndex.stoppedIterating();
                    }
                });
                Object var4_3 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                HSDBStore.this.indexLock.writeLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetBatching() {
            if (HSDBStore.this.pageFile.isLoaded()) {
                HSDBStore.this.indexLock.writeLock().lock();
                try {
                    try {
                        HSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<Exception>(){

                            public void execute(Transaction tx) throws Exception {
                                MessageDatabase.StoredDestination sd = HSDBStore.this.getExistingStoredDestination(HSDBMessageStore.this.dest, tx);
                                if (sd != null) {
                                    sd.orderIndex.resetCursorPosition();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        LOG.error("Failed to reset batching", e);
                        Object var3_2 = null;
                        HSDBStore.this.indexLock.writeLock().unlock();
                    }
                    Object var3_1 = null;
                    HSDBStore.this.indexLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    HSDBStore.this.indexLock.writeLock().unlock();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBatch(MessageId identity) throws IOException {
            try {
                final String key = identity.toString();
                this.lockAsyncJobQueue();
                HSDBStore.this.indexLock.writeLock().lock();
                try {
                    HSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                        public void execute(Transaction tx) throws IOException {
                            MessageDatabase.StoredDestination sd = HSDBStore.this.getStoredDestination(HSDBMessageStore.this.dest, tx);
                            Long location = (Long)sd.messageIdIndex.get(tx, (Object)key);
                            if (location != null) {
                                sd.orderIndex.setBatch(tx, location);
                            }
                        }
                    });
                    Object var4_3 = null;
                    HSDBStore.this.indexLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    HSDBStore.this.indexLock.writeLock().unlock();
                    throw throwable;
                }
                Object var6_6 = null;
                this.unlockAsyncJobQueue();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.unlockAsyncJobQueue();
                throw throwable;
            }
        }

        @Override
        public void setMemoryUsage(MemoryUsage memoeyUSage) {
        }

        @Override
        public void start() throws Exception {
            super.start();
        }

        @Override
        public void stop() throws Exception {
            super.stop();
        }

        protected void lockAsyncJobQueue() {
            try {
                this.localDestinationSemaphore.tryAcquire(this.maxAsyncJobs, 60L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("Failed to lock async jobs for " + this.destination, e);
            }
        }

        protected void unlockAsyncJobQueue() {
            this.localDestinationSemaphore.release(this.maxAsyncJobs);
        }

        protected void acquireLocalAsyncLock() {
            try {
                this.localDestinationSemaphore.acquire();
            }
            catch (InterruptedException e) {
                LOG.error("Failed to aquire async lock for " + this.destination, e);
            }
        }

        protected void releaseLocalAsyncLock() {
            this.localDestinationSemaphore.release();
        }
    }
}

