/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.hsdb;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.LocalTransactionId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.XATransactionId;
import com.bes.mq.filter.AnyDestination;
import com.bes.mq.filter.DestinationMap;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protobuf.Buffer;
import com.bes.mq.store.MessageStore;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.TransactionStore;
import com.bes.mq.store.hsdb.FilteredHSDBPersistenceAdapter;
import com.bes.mq.store.hsdb.HSDBPersistenceAdapter;
import com.bes.mq.store.hsdb.MessageDatabase;
import com.bes.mq.store.hsdb.MultiHSDBTransactionStore;
import com.bes.mq.store.hsdb.TransactionIdTransformer;
import com.bes.mq.store.hsdb.data.HSTransactionInfo;
import com.bes.mq.store.hsdb.data.HSXATransactionId;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.util.IOHelper;
import com.bes.mq.util.IntrospectionSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiHSDBPersistenceAdapter
extends DestinationMap
implements PersistenceAdapter,
BrokerServiceAware {
    static final Logger LOG = LoggerFactory.getLogger(MultiHSDBPersistenceAdapter.class);
    static final BESMQDestination matchAll = new AnyDestination(new BESMQDestination[]{new BESMQQueue(">"), new BESMQTopic(">")});
    final int LOCAL_FORMAT_ID_MAGIC = Integer.valueOf(System.getProperty("com.bes.mq.store.hsdb.MultiHSDBTransactionStore.localXaFormatId", "3200"));
    BrokerService brokerService;
    List<HSDBPersistenceAdapter> adapters = new LinkedList<HSDBPersistenceAdapter>();
    private File directory = new File(IOHelper.getDefaultDataDirectory() + File.separator + "mHSDB");
    MultiHSDBTransactionStore transactionStore = new MultiHSDBTransactionStore(this);
    TransactionIdTransformer transactionIdTransformer = new TransactionIdTransformer(){

        public HSTransactionInfo transform(TransactionId txid) {
            if (txid == null) {
                return null;
            }
            HSTransactionInfo rc = new HSTransactionInfo();
            HSXATransactionId hsTxId = new HSXATransactionId();
            if (txid.isLocalTransaction()) {
                LocalTransactionId t = (LocalTransactionId)txid;
                hsTxId.setBranchQualifier(new Buffer(Long.toString(t.getValue()).getBytes(Charset.forName("utf-8"))));
                hsTxId.setGlobalTransactionId(new Buffer(t.getConnectionId().getValue().getBytes(Charset.forName("utf-8"))));
                hsTxId.setFormatId(MultiHSDBPersistenceAdapter.this.LOCAL_FORMAT_ID_MAGIC);
            } else {
                XATransactionId t = (XATransactionId)txid;
                hsTxId.setBranchQualifier(new Buffer(t.getBranchQualifier()));
                hsTxId.setGlobalTransactionId(new Buffer(t.getGlobalTransactionId()));
                hsTxId.setFormatId(t.getFormatId());
            }
            rc.setXaTransactionId(hsTxId);
            return rc;
        }
    };

    public void setFilteredPersistenceAdapters(List entries) {
        for (Object entry : entries) {
            FilteredHSDBPersistenceAdapter filteredAdapter = (FilteredHSDBPersistenceAdapter)entry;
            HSDBPersistenceAdapter adapter = filteredAdapter.getPersistenceAdapter();
            if (filteredAdapter.getDestination() == null) {
                filteredAdapter.setDestination(matchAll);
            }
            if (filteredAdapter.isPerDestination()) {
                this.configureDirectory(adapter, null);
                continue;
            }
            this.configureDirectory(adapter, this.nameFromDestinationFilter(filteredAdapter.getDestination()));
            this.configureAdapter(adapter);
            this.adapters.add(adapter);
        }
        super.setEntries(entries);
    }

    private String nameFromDestinationFilter(BESMQDestination destination) {
        return IOHelper.toFileSystemSafeName(destination.getQualifiedName());
    }

    public boolean isLocalXid(TransactionId xid) {
        return xid instanceof XATransactionId && ((XATransactionId)xid).getFormatId() == this.LOCAL_FORMAT_ID_MAGIC;
    }

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.checkpoint(sync);
        }
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public MessageStore createQueueMessageStore(BESMQQueue destination) throws IOException {
        PersistenceAdapter persistenceAdapter = this.getMatchingPersistenceAdapter(destination);
        return this.transactionStore.proxy(persistenceAdapter.createTransactionStore(), persistenceAdapter.createQueueMessageStore(destination));
    }

    private PersistenceAdapter getMatchingPersistenceAdapter(BESMQDestination destination) {
        Object result = this.chooseValue(destination);
        if (result == null) {
            throw new RuntimeException("No matching persistence adapter configured for destination: " + destination + ", options:" + this.adapters);
        }
        FilteredHSDBPersistenceAdapter filteredAdapter = (FilteredHSDBPersistenceAdapter)result;
        if (filteredAdapter.getDestination() == matchAll && filteredAdapter.isPerDestination()) {
            result = this.addAdapter(filteredAdapter, destination);
            this.startAdapter(((FilteredHSDBPersistenceAdapter)result).getPersistenceAdapter(), destination.getQualifiedName());
            if (LOG.isTraceEnabled()) {
                LOG.info("Created per destination adapter for: " + destination + ", " + result);
            }
        }
        return ((FilteredHSDBPersistenceAdapter)result).getPersistenceAdapter();
    }

    private void startAdapter(HSDBPersistenceAdapter hsDBPersistenceAdapter, String destination) {
        try {
            hsDBPersistenceAdapter.start();
        }
        catch (Exception e) {
            RuntimeException detail = new RuntimeException("Failed to start per destination persistence adapter for destination: " + destination + ", options:" + this.adapters, e);
            LOG.error(detail.toString(), e);
            throw detail;
        }
    }

    private void stopAdapter(HSDBPersistenceAdapter hsDBPersistenceAdapter, String destination) {
        try {
            hsDBPersistenceAdapter.stop();
        }
        catch (Exception e) {
            RuntimeException detail = new RuntimeException("Failed to stop per destination persistence adapter for destination: " + destination + ", options:" + this.adapters, e);
            LOG.error(detail.toString(), e);
            throw detail;
        }
    }

    @Override
    public TopicMessageStore createTopicMessageStore(BESMQTopic destination) throws IOException {
        PersistenceAdapter persistenceAdapter = this.getMatchingPersistenceAdapter(destination);
        return this.transactionStore.proxy(persistenceAdapter.createTransactionStore(), persistenceAdapter.createTopicMessageStore(destination));
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        return this.transactionStore;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.deleteAllMessages();
        }
        this.transactionStore.deleteAllMessages();
        IOHelper.deleteChildren(this.getDirectory());
    }

    @Override
    public Set<BESMQDestination> getDestinations() {
        HashSet<BESMQDestination> results = new HashSet<BESMQDestination>();
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            results.addAll(persistenceAdapter.getDestinations());
        }
        return results;
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        long maxId = -1L;
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            maxId = Math.max(maxId, persistenceAdapter.getLastMessageBrokerSequenceId());
        }
        return maxId;
    }

    @Override
    public long getLastProducerSequenceId(ProducerId id) throws IOException {
        long maxId = -1L;
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            maxId = Math.max(maxId, persistenceAdapter.getLastProducerSequenceId(id));
        }
        return maxId;
    }

    @Override
    public void removeQueueMessageStore(BESMQQueue destination) {
        PersistenceAdapter adapter = this.getMatchingPersistenceAdapter(destination);
        adapter.removeQueueMessageStore(destination);
        if (adapter instanceof HSDBPersistenceAdapter) {
            adapter.removeQueueMessageStore(destination);
            this.removeMessageStore((HSDBPersistenceAdapter)adapter, destination);
        }
    }

    @Override
    public void removeTopicMessageStore(BESMQTopic destination) {
        PersistenceAdapter adapter = this.getMatchingPersistenceAdapter(destination);
        if (adapter instanceof HSDBPersistenceAdapter) {
            adapter.removeTopicMessageStore(destination);
            this.removeMessageStore((HSDBPersistenceAdapter)adapter, destination);
        }
    }

    private void removeMessageStore(HSDBPersistenceAdapter adapter, BESMQDestination destination) {
        if (adapter.getDestinations().isEmpty()) {
            this.stopAdapter(adapter, destination.toString());
            File adapterDir = adapter.getDirectory();
            if (adapterDir != null) {
                if (IOHelper.deleteFile(adapterDir)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.info("Deleted per destination adapter directory for: " + destination);
                    }
                } else if (LOG.isTraceEnabled()) {
                    LOG.info("Failed to deleted per destination adapter directory for: " + destination);
                }
            }
        }
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void setBrokerName(String brokerName) {
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.setBrokerName(brokerName);
        }
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.setUsageManager(usageManager);
        }
    }

    @Override
    public long size() {
        long size = 0L;
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            size += persistenceAdapter.size();
        }
        return size;
    }

    @Override
    public void start() throws Exception {
        FilteredHSDBPersistenceAdapter filteredAdapter;
        Object result = this.chooseValue(matchAll);
        if (result != null && (filteredAdapter = (FilteredHSDBPersistenceAdapter)result).getDestination() == matchAll && filteredAdapter.isPerDestination()) {
            this.findAndRegisterExistingAdapters(filteredAdapter);
        }
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.start();
        }
    }

    private void findAndRegisterExistingAdapters(FilteredHSDBPersistenceAdapter template) {
        FileFilter destinationNames = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith("queue#") || file.getName().startsWith("topic#");
            }
        };
        File[] candidates = template.getPersistenceAdapter().getDirectory().listFiles(destinationNames);
        if (candidates != null) {
            for (File candidate : candidates) {
                this.registerExistingAdapter(template, candidate);
            }
        }
    }

    private void registerExistingAdapter(FilteredHSDBPersistenceAdapter filteredAdapter, File candidate) {
        HSDBPersistenceAdapter adapter = this.adapterFromTemplate(filteredAdapter.getPersistenceAdapter(), candidate.getName());
        this.startAdapter(adapter, candidate.getName());
        Set<BESMQDestination> destinations = adapter.getDestinations();
        if (destinations.size() != 0) {
            this.registerAdapter(adapter, destinations.toArray(new BESMQDestination[0])[0]);
        } else {
            this.stopAdapter(adapter, candidate.getName());
        }
    }

    private FilteredHSDBPersistenceAdapter addAdapter(FilteredHSDBPersistenceAdapter filteredAdapter, BESMQDestination destination) {
        HSDBPersistenceAdapter adapter = this.adapterFromTemplate(filteredAdapter.getPersistenceAdapter(), this.nameFromDestinationFilter(destination));
        return this.registerAdapter(adapter, destination);
    }

    private HSDBPersistenceAdapter adapterFromTemplate(HSDBPersistenceAdapter template, String destinationName) {
        HSDBPersistenceAdapter adapter = this.hsDBFromTemplate(template);
        this.configureAdapter(adapter);
        this.configureDirectory(adapter, destinationName);
        return adapter;
    }

    private void configureDirectory(HSDBPersistenceAdapter adapter, String fileName) {
        File directory = null;
        directory = MessageDatabase.DEFAULT_DIRECTORY.equals(adapter.getDirectory()) ? this.getDirectory() : adapter.getDirectory();
        if (fileName != null) {
            directory = new File(directory, fileName);
        }
        adapter.setDirectory(directory);
    }

    private FilteredHSDBPersistenceAdapter registerAdapter(HSDBPersistenceAdapter adapter, BESMQDestination destination) {
        this.adapters.add(adapter);
        FilteredHSDBPersistenceAdapter result = new FilteredHSDBPersistenceAdapter(destination, adapter);
        this.put(destination, result);
        return result;
    }

    private void configureAdapter(HSDBPersistenceAdapter adapter) {
        adapter.getStore().setTransactionIdTransformer(this.transactionIdTransformer);
        adapter.setBrokerService(this.getBrokerService());
    }

    private HSDBPersistenceAdapter hsDBFromTemplate(HSDBPersistenceAdapter template) {
        HashMap configuration = new HashMap();
        IntrospectionSupport.getProperties(template, configuration, null);
        HSDBPersistenceAdapter adapter = new HSDBPersistenceAdapter();
        IntrospectionSupport.setProperties(adapter, configuration);
        return adapter;
    }

    @Override
    public void stop() throws Exception {
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.stop();
        }
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        for (HSDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.setBrokerService(brokerService);
        }
        this.brokerService = brokerService;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public void setTransactionStore(MultiHSDBTransactionStore transactionStore) {
        this.transactionStore = transactionStore;
    }

    public void setJournalMaxFileLength(long maxFileLength) {
        this.transactionStore.setJournalMaxFileLength(maxFileLength);
    }

    public long getJournalMaxFileLength() {
        return this.transactionStore.getJournalMaxFileLength();
    }

    public void setJournalWriteBatchSize(int journalWriteBatchSize) {
        this.transactionStore.setJournalMaxWriteBatchSize(journalWriteBatchSize);
    }

    public int getJournalWriteBatchSize() {
        return this.transactionStore.getJournalMaxWriteBatchSize();
    }

    public String toString() {
        String path = this.getDirectory() != null ? this.getDirectory().getAbsolutePath() : "DIRECTORY_NOT_SET";
        return "MultiHSDBPersistenceAdapter[" + path + "]" + this.adapters;
    }
}

