/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.hsdb;

import com.bes.hsdb.journal.Journal;
import com.bes.hsdb.journal.Location;
import com.bes.hsdb.util.DataByteArrayInputStream;
import com.bes.hsdb.util.DataByteArrayOutputStream;
import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.XATransactionId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.AbstractMessageStore;
import com.bes.mq.store.MessageStore;
import com.bes.mq.store.ProxyMessageStore;
import com.bes.mq.store.ProxyTopicMessageStore;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.TransactionRecoveryListener;
import com.bes.mq.store.TransactionStore;
import com.bes.mq.store.hsdb.HSDBPersistenceAdapter;
import com.bes.mq.store.hsdb.JournalCommand;
import com.bes.mq.store.hsdb.MultiHSDBPersistenceAdapter;
import com.bes.mq.store.hsdb.TransactionIdConversion;
import com.bes.mq.store.hsdb.data.HSCommitCommand;
import com.bes.mq.store.hsdb.data.HSEntryType;
import com.bes.mq.store.hsdb.data.HSPrepareCommand;
import com.bes.mq.store.hsdb.data.HSTraceCommand;
import com.bes.mq.util.IOHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiHSDBTransactionStore
implements TransactionStore {
    static final Logger LOG = LoggerFactory.getLogger(MultiHSDBTransactionStore.class);
    final MultiHSDBPersistenceAdapter multiHSDBPersistenceAdapter;
    final ConcurrentHashMap<TransactionId, Tx> inflightTransactions = new ConcurrentHashMap();
    final Set<TransactionId> recoveredPendingCommit = new HashSet<TransactionId>();
    private Journal journal;
    private long journalMaxFileLength = 0x2000000L;
    private int journalWriteBatchSize = 0x400000;

    public MultiHSDBTransactionStore(MultiHSDBPersistenceAdapter multiHSDBPersistenceAdapter) {
        this.multiHSDBPersistenceAdapter = multiHSDBPersistenceAdapter;
    }

    public MessageStore proxy(final TransactionStore transactionStore, MessageStore messageStore) {
        return new ProxyMessageStore(messageStore){

            @Override
            public void addMessage(ConnectionContext context, Message send) throws IOException {
                MultiHSDBTransactionStore.this.addMessage(transactionStore, context, this.getDelegate(), send);
            }

            @Override
            public void addMessage(ConnectionContext context, Message send, boolean canOptimizeHint) throws IOException {
                MultiHSDBTransactionStore.this.addMessage(transactionStore, context, this.getDelegate(), send);
            }

            @Override
            public Future<Object> asyncAddQueueMessage(ConnectionContext context, Message message) throws IOException {
                return MultiHSDBTransactionStore.this.asyncAddQueueMessage(transactionStore, context, this.getDelegate(), message);
            }

            @Override
            public Future<Object> asyncAddQueueMessage(ConnectionContext context, Message message, boolean canOptimizeHint) throws IOException {
                return MultiHSDBTransactionStore.this.asyncAddQueueMessage(transactionStore, context, this.getDelegate(), message);
            }

            @Override
            public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
                MultiHSDBTransactionStore.this.removeMessage(transactionStore, context, this.getDelegate(), ack);
            }

            @Override
            public void removeAsyncMessage(ConnectionContext context, MessageAck ack) throws IOException {
                MultiHSDBTransactionStore.this.removeAsyncMessage(transactionStore, context, this.getDelegate(), ack);
            }
        };
    }

    public TopicMessageStore proxy(final TransactionStore transactionStore, TopicMessageStore messageStore) {
        return new ProxyTopicMessageStore(messageStore){

            @Override
            public void addMessage(ConnectionContext context, Message send, boolean canOptimizeHint) throws IOException {
                MultiHSDBTransactionStore.this.addMessage(transactionStore, context, this.getDelegate(), send);
            }

            @Override
            public void addMessage(ConnectionContext context, Message send) throws IOException {
                MultiHSDBTransactionStore.this.addMessage(transactionStore, context, this.getDelegate(), send);
            }

            @Override
            public Future<Object> asyncAddTopicMessage(ConnectionContext context, Message message, boolean canOptimizeHint) throws IOException {
                return MultiHSDBTransactionStore.this.asyncAddTopicMessage(transactionStore, context, this.getDelegate(), message);
            }

            @Override
            public Future<Object> asyncAddTopicMessage(ConnectionContext context, Message message) throws IOException {
                return MultiHSDBTransactionStore.this.asyncAddTopicMessage(transactionStore, context, this.getDelegate(), message);
            }

            @Override
            public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
                MultiHSDBTransactionStore.this.removeMessage(transactionStore, context, this.getDelegate(), ack);
            }

            @Override
            public void removeAsyncMessage(ConnectionContext context, MessageAck ack) throws IOException {
                MultiHSDBTransactionStore.this.removeAsyncMessage(transactionStore, context, this.getDelegate(), ack);
            }

            @Override
            public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
                MultiHSDBTransactionStore.this.acknowledge(transactionStore, context, (TopicMessageStore)this.getDelegate(), clientId, subscriptionName, messageId, ack);
            }
        };
    }

    public void deleteAllMessages() {
        IOHelper.deleteChildren(this.getDirectory());
    }

    public long getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public void setJournalMaxFileLength(long journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxWriteBatchSize() {
        return this.journalWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalWriteBatchSize) {
        this.journalWriteBatchSize = journalWriteBatchSize;
    }

    public Tx getTx(TransactionId txid) {
        Tx tx = this.inflightTransactions.get(txid);
        if (tx == null) {
            tx = new Tx();
            this.inflightTransactions.put(txid, tx);
        }
        return tx;
    }

    public Tx removeTx(TransactionId txid) {
        return this.inflightTransactions.remove(txid);
    }

    @Override
    public void prepare(TransactionId txid) throws IOException {
        Tx tx = this.getTx(txid);
        for (TransactionStore store : tx.getStores()) {
            store.prepare(txid);
        }
    }

    @Override
    public void commit(TransactionId txid, boolean wasPrepared, Runnable preCommit, Runnable postCommit) throws IOException {
        if (preCommit != null) {
            preCommit.run();
        }
        Tx tx = this.getTx(txid);
        if (wasPrepared) {
            for (TransactionStore store : tx.getStores()) {
                store.commit(txid, true, null, null);
            }
        } else if (tx.getStores().size() == 1) {
            for (TransactionStore store : tx.getStores()) {
                store.commit(txid, false, null, null);
            }
        } else {
            for (TransactionStore store : tx.getStores()) {
                store.prepare(txid);
            }
            this.persistOutcome(tx, txid);
            for (TransactionStore store : tx.getStores()) {
                store.commit(txid, true, null, null);
            }
            this.persistCompletion(txid);
        }
        this.removeTx(txid);
        if (postCommit != null) {
            postCommit.run();
        }
    }

    public void persistOutcome(Tx tx, TransactionId txid) throws IOException {
        tx.trackPrepareLocation(this.store((JournalCommand)new HSPrepareCommand().setTransactionInfo(this.multiHSDBPersistenceAdapter.transactionIdTransformer.transform(txid))));
    }

    public void persistCompletion(TransactionId txid) throws IOException {
        this.store((JournalCommand)new HSCommitCommand().setTransactionInfo(this.multiHSDBPersistenceAdapter.transactionIdTransformer.transform(txid)));
    }

    private Location store(JournalCommand<?> data) throws IOException {
        int size = data.serializedSizeFramed();
        DataByteArrayOutputStream os = new DataByteArrayOutputStream(size + 1);
        os.writeByte(data.type().getNumber());
        data.writeFramed((OutputStream)os);
        Location location = this.journal.write(os.toByteSequence(), true);
        this.journal.setLastAppendLocation(location);
        return location;
    }

    @Override
    public void rollback(TransactionId txid) throws IOException {
        Tx tx = this.removeTx(txid);
        if (tx != null) {
            for (TransactionStore store : tx.getStores()) {
                store.rollback(txid);
            }
        }
    }

    @Override
    public void start() throws Exception {
        this.journal = new Journal(){

            protected void cleanup() {
                super.cleanup();
                MultiHSDBTransactionStore.this.txStoreCleanup();
            }
        };
        this.journal.setDirectory(this.getDirectory());
        this.journal.setMaxFileLength(this.journalMaxFileLength);
        this.journal.setWriteBatchSize(this.journalWriteBatchSize);
        IOHelper.mkdirs(this.journal.getDirectory());
        this.journal.start();
        this.recoverPendingLocalTransactions();
        this.store((JournalCommand)new HSTraceCommand().setMessage("LOADED " + new Date()));
    }

    private void txStoreCleanup() {
        TreeSet knownDataFileIds = new TreeSet(this.journal.getFileMap().keySet());
        for (Tx tx : this.inflightTransactions.values()) {
            knownDataFileIds.remove(tx.getPreparedLocationId());
        }
        try {
            this.journal.removeDataFiles(knownDataFileIds);
        }
        catch (Exception e) {
            LOG.error(this + ", Failed to remove tx journal datafiles " + knownDataFileIds);
        }
    }

    private File getDirectory() {
        return new File(this.multiHSDBPersistenceAdapter.getDirectory(), "txStore");
    }

    @Override
    public void stop() throws Exception {
        this.journal.close();
        this.journal = null;
    }

    private void recoverPendingLocalTransactions() throws IOException {
        Location location = this.journal.getNextLocation(null);
        while (location != null) {
            this.process(this.load(location));
            location = this.journal.getNextLocation(location);
        }
        this.recoveredPendingCommit.addAll(this.inflightTransactions.keySet());
        LOG.info("Pending local transactions: " + this.recoveredPendingCommit);
    }

    public JournalCommand<?> load(Location location) throws IOException {
        DataByteArrayInputStream is = new DataByteArrayInputStream(this.journal.read(location));
        byte readByte = is.readByte();
        HSEntryType type = HSEntryType.valueOf(readByte);
        if (type == null) {
            throw new IOException("Could not load journal record. Invalid location: " + location);
        }
        JournalCommand message = (JournalCommand)type.createMessage();
        message.mergeFramed((InputStream)is);
        return message;
    }

    public void process(JournalCommand<?> command) throws IOException {
        switch (command.type()) {
            case H_S_PREPARE_COMMAND: {
                HSPrepareCommand prepareCommand = (HSPrepareCommand)command;
                this.getTx(TransactionIdConversion.convert(prepareCommand.getTransactionInfo()));
                break;
            }
            case H_S_COMMIT_COMMAND: {
                HSCommitCommand commitCommand = (HSCommitCommand)command;
                this.removeTx(TransactionIdConversion.convert(commitCommand.getTransactionInfo()));
                break;
            }
            case H_S_TRACE_COMMAND: {
                break;
            }
            default: {
                throw new IOException("Unexpected command in transaction journal: " + command);
            }
        }
    }

    @Override
    public synchronized void recover(final TransactionRecoveryListener listener) throws IOException {
        for (final HSDBPersistenceAdapter adapter : this.multiHSDBPersistenceAdapter.adapters) {
            adapter.createTransactionStore().recover(new TransactionRecoveryListener(){

                public void recover(XATransactionId xid, Message[] addedMessages, MessageAck[] acks) {
                    try {
                        MultiHSDBTransactionStore.this.getTx(xid).trackStore(adapter.createTransactionStore());
                    }
                    catch (IOException e) {
                        LOG.error("Failed to access transaction store: " + adapter + " for prepared xa tid: " + xid, e);
                    }
                    listener.recover(xid, addedMessages, acks);
                }
            });
        }
        try {
            Broker broker = this.multiHSDBPersistenceAdapter.getBrokerService().getBroker();
            for (TransactionId txid : broker.getPreparedTransactions(null)) {
                if (!this.multiHSDBPersistenceAdapter.isLocalXid(txid)) continue;
                try {
                    if (this.recoveredPendingCommit.contains(txid)) {
                        LOG.info("Delivering pending commit outcome for tid: " + txid);
                        broker.commitTransaction(null, txid, false);
                    } else {
                        LOG.info("Delivering rollback outcome to store for tid: " + txid);
                        broker.forgetTransaction(null, txid);
                    }
                    this.persistCompletion(txid);
                }
                catch (Exception ex) {
                    LOG.error("Failed to deliver pending outcome for tid: " + txid, ex);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to resolve pending local transactions", e);
        }
    }

    void addMessage(TransactionStore transactionStore, ConnectionContext context, MessageStore destination, Message message) throws IOException {
        if (message.getTransactionId() != null) {
            this.getTx(message.getTransactionId()).trackStore(transactionStore);
        }
        destination.addMessage(context, message);
    }

    Future<Object> asyncAddQueueMessage(TransactionStore transactionStore, ConnectionContext context, MessageStore destination, Message message) throws IOException {
        if (message.getTransactionId() != null) {
            this.getTx(message.getTransactionId()).trackStore(transactionStore);
            destination.addMessage(context, message);
            return AbstractMessageStore.FUTURE;
        }
        return destination.asyncAddQueueMessage(context, message);
    }

    Future<Object> asyncAddTopicMessage(TransactionStore transactionStore, ConnectionContext context, MessageStore destination, Message message) throws IOException {
        if (message.getTransactionId() != null) {
            this.getTx(message.getTransactionId()).trackStore(transactionStore);
            destination.addMessage(context, message);
            return AbstractMessageStore.FUTURE;
        }
        return destination.asyncAddTopicMessage(context, message);
    }

    final void removeMessage(TransactionStore transactionStore, ConnectionContext context, MessageStore destination, MessageAck ack) throws IOException {
        if (ack.getTransactionId() != null) {
            this.getTx(ack.getTransactionId()).trackStore(transactionStore);
        }
        destination.removeMessage(context, ack);
    }

    final void removeAsyncMessage(TransactionStore transactionStore, ConnectionContext context, MessageStore destination, MessageAck ack) throws IOException {
        if (ack.getTransactionId() != null) {
            this.getTx(ack.getTransactionId()).trackStore(transactionStore);
        }
        destination.removeAsyncMessage(context, ack);
    }

    final void acknowledge(TransactionStore transactionStore, ConnectionContext context, TopicMessageStore destination, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
        if (ack.getTransactionId() != null) {
            this.getTx(ack.getTransactionId()).trackStore(transactionStore);
        }
        destination.acknowledge(context, clientId, subscriptionName, messageId, ack);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Tx {
        private final Set<TransactionStore> stores = new HashSet<TransactionStore>();
        private int prepareLocationId = 0;

        public void trackStore(TransactionStore store) {
            this.stores.add(store);
        }

        public Set<TransactionStore> getStores() {
            return this.stores;
        }

        public void trackPrepareLocation(Location location) {
            this.prepareLocationId = location.getDataFileId();
        }

        public int getPreparedLocationId() {
            return this.prepareLocationId;
        }
    }
}

