/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.hsdb;

import com.bes.hsdb.journal.Location;
import com.bes.hsdb.page.Transaction;
import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTempQueue;
import com.bes.mq.command.BESMQTempTopic;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.SubscriptionInfo;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.XATransactionId;
import com.bes.mq.protobuf.Buffer;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.store.AbstractMessageStore;
import com.bes.mq.store.MessageRecoveryListener;
import com.bes.mq.store.MessageStore;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.TransactionRecoveryListener;
import com.bes.mq.store.TransactionStore;
import com.bes.mq.store.hsdb.TempMessageDatabase;
import com.bes.mq.store.hsdb.data.HSAddMessageCommand;
import com.bes.mq.store.hsdb.data.HSDestination;
import com.bes.mq.store.hsdb.data.HSLocation;
import com.bes.mq.store.hsdb.data.HSRemoveDestinationCommand;
import com.bes.mq.store.hsdb.data.HSRemoveMessageCommand;
import com.bes.mq.store.hsdb.data.HSSubscriptionCommand;
import com.bes.mq.usage.MemoryUsage;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.util.ByteSequence;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempHSDBStore
extends TempMessageDatabase
implements PersistenceAdapter {
    private final ProtocolFormat protocolFormat = new BESMPFormat();

    @Override
    public void setBrokerName(String brokerName) {
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        return new TransactionStore(){

            public void commit(TransactionId txid, boolean wasPrepared, Runnable preCommit, Runnable postCommit) throws IOException {
                if (preCommit != null) {
                    preCommit.run();
                }
                TempHSDBStore.this.processCommit(txid);
                if (postCommit != null) {
                    postCommit.run();
                }
            }

            public void prepare(TransactionId txid) throws IOException {
                TempHSDBStore.this.processPrepare(txid);
            }

            public void rollback(TransactionId txid) throws IOException {
                TempHSDBStore.this.processRollback(txid);
            }

            public void recover(TransactionRecoveryListener listener) throws IOException {
                for (Map.Entry entry : TempHSDBStore.this.preparedTransactions.entrySet()) {
                    XATransactionId xid = (XATransactionId)entry.getKey();
                    ArrayList<Message> messageList = new ArrayList<Message>();
                    ArrayList<MessageAck> ackList = new ArrayList<MessageAck>();
                    for (TempMessageDatabase.Operation op : (ArrayList)entry.getValue()) {
                        if (op.getClass() == TempMessageDatabase.AddOpperation.class) {
                            TempMessageDatabase.AddOpperation addOp = (TempMessageDatabase.AddOpperation)op;
                            Message msg = (Message)TempHSDBStore.this.protocolFormat.unmarshal(new DataInputStream((InputStream)addOp.getCommand().getMessage().newInput()));
                            messageList.add(msg);
                            continue;
                        }
                        TempMessageDatabase.RemoveOpperation rmOp = (TempMessageDatabase.RemoveOpperation)op;
                        MessageAck ack = (MessageAck)TempHSDBStore.this.protocolFormat.unmarshal(new DataInputStream((InputStream)rmOp.getCommand().getAck().newInput()));
                        ackList.add(ack);
                    }
                    Message[] addedMessages = new Message[messageList.size()];
                    MessageAck[] acks = new MessageAck[ackList.size()];
                    messageList.toArray(addedMessages);
                    ackList.toArray(acks);
                    listener.recover(xid, addedMessages, acks);
                }
            }

            public void start() throws Exception {
            }

            public void stop() throws Exception {
            }
        };
    }

    String subscriptionKey(String clientId, String subscriptionName) {
        return clientId + ":" + subscriptionName;
    }

    @Override
    public MessageStore createQueueMessageStore(BESMQQueue destination) throws IOException {
        return new HSDBMessageStore(destination);
    }

    @Override
    public TopicMessageStore createTopicMessageStore(BESMQTopic destination) throws IOException {
        return new HSDBTopicMessageStore(destination);
    }

    @Override
    public void removeQueueMessageStore(BESMQQueue destination) {
    }

    @Override
    public void removeTopicMessageStore(BESMQTopic destination) {
    }

    @Override
    public void deleteAllMessages() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BESMQDestination> getDestinations() {
        try {
            final HashSet<BESMQDestination> rc = new HashSet<BESMQDestination>();
            Object object = this.indexMutex;
            synchronized (object) {
                this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                    public void execute(Transaction tx) throws IOException {
                        Iterator iterator = TempHSDBStore.this.destinations.iterator(tx);
                        while (iterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator.next();
                            rc.add(TempHSDBStore.this.convert((String)entry.getKey()));
                        }
                    }
                });
            }
            return rc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return 0L;
    }

    @Override
    public long size() {
        if (!this.started.get()) {
            return 0L;
        }
        try {
            return this.pageFile.getDiskSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
    }

    HSLocation convert(Location location) {
        HSLocation rc = new HSLocation();
        rc.setLogId(location.getDataFileId());
        rc.setOffset(location.getOffset());
        return rc;
    }

    HSDestination convert(BESMQDestination dest) {
        HSDestination rc = new HSDestination();
        rc.setName(dest.getPhysicalName());
        switch (dest.getDestinationType()) {
            case 1: {
                rc.setType(HSDestination.DestinationType.QUEUE);
                return rc;
            }
            case 2: {
                rc.setType(HSDestination.DestinationType.TOPIC);
                return rc;
            }
            case 5: {
                rc.setType(HSDestination.DestinationType.TEMP_QUEUE);
                return rc;
            }
            case 6: {
                rc.setType(HSDestination.DestinationType.TEMP_TOPIC);
                return rc;
            }
        }
        return null;
    }

    BESMQDestination convert(String dest) {
        int p = dest.indexOf(":");
        if (p < 0) {
            throw new IllegalArgumentException("Not in the valid destination format");
        }
        int type = Integer.parseInt(dest.substring(0, p));
        String name = dest.substring(p + 1);
        switch (HSDestination.DestinationType.valueOf(type)) {
            case QUEUE: {
                return new BESMQQueue(name);
            }
            case TOPIC: {
                return new BESMQTopic(name);
            }
            case TEMP_QUEUE: {
                return new BESMQTempQueue(name);
            }
            case TEMP_TOPIC: {
                return new BESMQTempTopic(name);
            }
        }
        throw new IllegalArgumentException("Not in the valid destination format");
    }

    @Override
    public long getLastProducerSequenceId(ProducerId id) {
        return -1L;
    }

    class HSDBTopicMessageStore
    extends HSDBMessageStore
    implements TopicMessageStore {
        public HSDBTopicMessageStore(BESMQTopic destination) {
            super(destination);
        }

        public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
            HSRemoveMessageCommand command = new HSRemoveMessageCommand();
            command.setDestination(this.dest);
            command.setSubscriptionKey(TempHSDBStore.this.subscriptionKey(clientId, subscriptionName));
            command.setMessageId(messageId.toString());
            TempHSDBStore.this.processRemove(command, null);
        }

        public void addSubsciption(SubscriptionInfo subscriptionInfo, boolean retroactive) throws IOException {
            String subscriptionKey = TempHSDBStore.this.subscriptionKey(subscriptionInfo.getClientId(), subscriptionInfo.getSubscriptionName());
            HSSubscriptionCommand command = new HSSubscriptionCommand();
            command.setDestination(this.dest);
            command.setSubscriptionKey(subscriptionKey);
            command.setRetroactive(retroactive);
            ByteSequence packet = TempHSDBStore.this.protocolFormat.marshal(subscriptionInfo);
            command.setSubscriptionInfo(new Buffer(packet.getData(), packet.getOffset(), packet.getLength()));
            TempHSDBStore.this.process(command);
        }

        public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
            HSSubscriptionCommand command = new HSSubscriptionCommand();
            command.setDestination(this.dest);
            command.setSubscriptionKey(TempHSDBStore.this.subscriptionKey(clientId, subscriptionName));
            TempHSDBStore.this.process(command);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubscriptionInfo[] getAllSubscriptions() throws IOException {
            final ArrayList subscriptions = new ArrayList();
            Object object = TempHSDBStore.this.indexMutex;
            synchronized (object) {
                TempHSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                    public void execute(Transaction tx) throws IOException {
                        TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                        Iterator iterator = sd.subscriptions.iterator(tx);
                        while (iterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator.next();
                            SubscriptionInfo info = (SubscriptionInfo)TempHSDBStore.this.protocolFormat.unmarshal(new DataInputStream((InputStream)((HSSubscriptionCommand)entry.getValue()).getSubscriptionInfo().newInput()));
                            subscriptions.add(info);
                        }
                    }
                });
            }
            SubscriptionInfo[] rc = new SubscriptionInfo[subscriptions.size()];
            subscriptions.toArray(rc);
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
            final String subscriptionKey = TempHSDBStore.this.subscriptionKey(clientId, subscriptionName);
            Object object = TempHSDBStore.this.indexMutex;
            synchronized (object) {
                return (SubscriptionInfo)TempHSDBStore.this.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<SubscriptionInfo, IOException>(){

                    public SubscriptionInfo execute(Transaction tx) throws IOException {
                        TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                        HSSubscriptionCommand command = (HSSubscriptionCommand)sd.subscriptions.get(tx, (Object)subscriptionKey);
                        if (command == null) {
                            return null;
                        }
                        return (SubscriptionInfo)TempHSDBStore.this.protocolFormat.unmarshal(new DataInputStream((InputStream)command.getSubscriptionInfo().newInput()));
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getMessageCount(String clientId, String subscriptionName) throws IOException {
            final String subscriptionKey = TempHSDBStore.this.subscriptionKey(clientId, subscriptionName);
            Object object = TempHSDBStore.this.indexMutex;
            synchronized (object) {
                return (Integer)TempHSDBStore.this.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<Integer, IOException>(){

                    public Integer execute(Transaction tx) throws IOException {
                        TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                        Long cursorPos = (Long)sd.subscriptionAcks.get(tx, (Object)subscriptionKey);
                        if (cursorPos == null) {
                            return 0;
                        }
                        cursorPos = cursorPos + 1L;
                        int counter = 0;
                        Iterator iterator = sd.orderIndex.iterator(tx, (Object)cursorPos);
                        while (iterator.hasNext()) {
                            iterator.next();
                            ++counter;
                        }
                        return counter;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recoverSubscription(String clientId, String subscriptionName, final MessageRecoveryListener listener) throws Exception {
            final String subscriptionKey = TempHSDBStore.this.subscriptionKey(clientId, subscriptionName);
            Object object = TempHSDBStore.this.indexMutex;
            synchronized (object) {
                TempHSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<Exception>(){

                    public void execute(Transaction tx) throws Exception {
                        TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                        Long cursorPos = (Long)sd.subscriptionAcks.get(tx, (Object)subscriptionKey);
                        cursorPos = cursorPos + 1L;
                        Iterator iterator = sd.orderIndex.iterator(tx, (Object)cursorPos);
                        while (iterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator.next();
                            listener.recoverMessage((Message)TempHSDBStore.this.protocolFormat.unmarshal(((TempMessageDatabase.MessageRecord)entry.getValue()).data));
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recoverNextMessages(String clientId, String subscriptionName, final int maxReturned, final MessageRecoveryListener listener) throws Exception {
            final String subscriptionKey = TempHSDBStore.this.subscriptionKey(clientId, subscriptionName);
            Object object = TempHSDBStore.this.indexMutex;
            synchronized (object) {
                TempHSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<Exception>(){

                    public void execute(Transaction tx) throws Exception {
                        TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                        Long cursorPos = sd.subscriptionCursors.get(subscriptionKey);
                        if (cursorPos == null) {
                            cursorPos = (Long)sd.subscriptionAcks.get(tx, (Object)subscriptionKey);
                            cursorPos = cursorPos + 1L;
                        }
                        Map.Entry entry = null;
                        int counter = 0;
                        Iterator iterator = sd.orderIndex.iterator(tx, (Object)cursorPos);
                        while (iterator.hasNext()) {
                            entry = (Map.Entry)iterator.next();
                            listener.recoverMessage((Message)TempHSDBStore.this.protocolFormat.unmarshal(((TempMessageDatabase.MessageRecord)entry.getValue()).data));
                            if (++counter < maxReturned) continue;
                        }
                        if (entry != null) {
                            sd.subscriptionCursors.put(subscriptionKey, (Long)entry.getKey() + 1L);
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetBatching(String clientId, String subscriptionName) {
            try {
                final String subscriptionKey = TempHSDBStore.this.subscriptionKey(clientId, subscriptionName);
                Object object = TempHSDBStore.this.indexMutex;
                synchronized (object) {
                    TempHSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                        public void execute(Transaction tx) throws IOException {
                            TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBTopicMessageStore.this.dest, tx);
                            sd.subscriptionCursors.remove(subscriptionKey);
                        }
                    });
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class HSDBMessageStore
    extends AbstractMessageStore {
        protected HSDestination dest;
        long cursorPos;

        public HSDBMessageStore(BESMQDestination destination) {
            super(destination);
            this.cursorPos = 0L;
            this.dest = TempHSDBStore.this.convert(destination);
        }

        public BESMQDestination getDestination() {
            return this.destination;
        }

        public void addMessage(ConnectionContext context, Message message) throws IOException {
            HSAddMessageCommand command = new HSAddMessageCommand();
            command.setDestination(this.dest);
            command.setMessageId(message.getMessageId().toString());
            TempHSDBStore.this.processAdd(command, message.getTransactionId(), TempHSDBStore.this.protocolFormat.marshal(message));
        }

        public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
            HSRemoveMessageCommand command = new HSRemoveMessageCommand();
            command.setDestination(this.dest);
            command.setMessageId(ack.getLastMessageId().toString());
            TempHSDBStore.this.processRemove(command, ack.getTransactionId());
        }

        public void removeAllMessages(ConnectionContext context) throws IOException {
            HSRemoveDestinationCommand command = new HSRemoveDestinationCommand();
            command.setDestination(this.dest);
            TempHSDBStore.this.process(command);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message getMessage(MessageId identity) throws IOException {
            ByteSequence data;
            final String key = identity.toString();
            Object object = TempHSDBStore.this.indexMutex;
            synchronized (object) {
                data = (ByteSequence)TempHSDBStore.this.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<ByteSequence, IOException>(){

                    public ByteSequence execute(Transaction tx) throws IOException {
                        TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBMessageStore.this.dest, tx);
                        Long sequence = (Long)sd.messageIdIndex.get(tx, (Object)key);
                        if (sequence == null) {
                            return null;
                        }
                        return ((TempMessageDatabase.MessageRecord)sd.orderIndex.get((Transaction)tx, (Object)sequence)).data;
                    }
                });
            }
            if (data == null) {
                return null;
            }
            Message msg = (Message)TempHSDBStore.this.protocolFormat.unmarshal(data);
            return msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getMessageCount() throws IOException {
            Object object = TempHSDBStore.this.indexMutex;
            synchronized (object) {
                return (Integer)TempHSDBStore.this.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<Integer, IOException>(){

                    public Integer execute(Transaction tx) throws IOException {
                        TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBMessageStore.this.dest, tx);
                        int rc = 0;
                        Iterator iterator = sd.messageIdIndex.iterator(tx);
                        while (iterator.hasNext()) {
                            iterator.next();
                            ++rc;
                        }
                        return rc;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recover(final MessageRecoveryListener listener) throws Exception {
            Object object = TempHSDBStore.this.indexMutex;
            synchronized (object) {
                TempHSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<Exception>(){

                    public void execute(Transaction tx) throws Exception {
                        TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBMessageStore.this.dest, tx);
                        Iterator iterator = sd.orderIndex.iterator(tx);
                        while (iterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator.next();
                            listener.recoverMessage((Message)TempHSDBStore.this.protocolFormat.unmarshal(((TempMessageDatabase.MessageRecord)entry.getValue()).data));
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recoverNextMessages(final int maxReturned, final MessageRecoveryListener listener) throws Exception {
            Object object = TempHSDBStore.this.indexMutex;
            synchronized (object) {
                TempHSDBStore.this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<Exception>(){

                    public void execute(Transaction tx) throws Exception {
                        TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBMessageStore.this.dest, tx);
                        Map.Entry entry = null;
                        int counter = 0;
                        Iterator iterator = sd.orderIndex.iterator(tx, (Object)HSDBMessageStore.this.cursorPos);
                        while (iterator.hasNext()) {
                            entry = (Map.Entry)iterator.next();
                            listener.recoverMessage((Message)TempHSDBStore.this.protocolFormat.unmarshal(((TempMessageDatabase.MessageRecord)entry.getValue()).data));
                            if (++counter < maxReturned) continue;
                        }
                        if (entry != null) {
                            HSDBMessageStore.this.cursorPos = (Long)entry.getKey() + 1L;
                        }
                    }
                });
            }
        }

        public void resetBatching() {
            this.cursorPos = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBatch(MessageId identity) throws IOException {
            Long location;
            final String key = identity.toString();
            Object object = TempHSDBStore.this.indexMutex;
            synchronized (object) {
                location = (Long)TempHSDBStore.this.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<Long, IOException>(){

                    public Long execute(Transaction tx) throws IOException {
                        TempMessageDatabase.StoredDestination sd = TempHSDBStore.this.getStoredDestination(HSDBMessageStore.this.dest, tx);
                        return (Long)sd.messageIdIndex.get(tx, (Object)key);
                    }
                });
            }
            if (location != null) {
                this.cursorPos = location + 1L;
            }
        }

        public void setMemoryUsage(MemoryUsage memoeyUSage) {
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
        }
    }
}

