/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.hsdb;

import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.LocalTransactionId;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.XATransactionId;
import com.bes.mq.protobuf.Buffer;
import com.bes.mq.store.hsdb.data.HSLocalTransactionId;
import com.bes.mq.store.hsdb.data.HSTransactionInfo;
import com.bes.mq.store.hsdb.data.HSXATransactionId;

public class TransactionIdConversion {
    static HSTransactionInfo convertToLocal(TransactionId tx) {
        HSTransactionInfo rc = new HSTransactionInfo();
        LocalTransactionId t = (LocalTransactionId)tx;
        HSLocalTransactionId hsTxId = new HSLocalTransactionId();
        hsTxId.setConnectionId(t.getConnectionId().getValue());
        hsTxId.setTransactionId(t.getValue());
        rc.setLocalTransactionId(hsTxId);
        return rc;
    }

    static HSTransactionInfo convert(TransactionId txid) {
        HSTransactionInfo rc;
        if (txid == null) {
            return null;
        }
        if (txid.isLocalTransaction()) {
            rc = TransactionIdConversion.convertToLocal(txid);
        } else {
            rc = new HSTransactionInfo();
            XATransactionId t = (XATransactionId)txid;
            HSXATransactionId hsTxId = new HSXATransactionId();
            hsTxId.setBranchQualifier(new Buffer(t.getBranchQualifier()));
            hsTxId.setGlobalTransactionId(new Buffer(t.getGlobalTransactionId()));
            hsTxId.setFormatId(t.getFormatId());
            rc.setXaTransactionId(hsTxId);
        }
        return rc;
    }

    static TransactionId convert(HSTransactionInfo transactionInfo) {
        if (transactionInfo.hasLocalTransactionId()) {
            HSLocalTransactionId tx = transactionInfo.getLocalTransactionId();
            LocalTransactionId rc = new LocalTransactionId();
            rc.setConnectionId(new ConnectionId(tx.getConnectionId()));
            rc.setValue(tx.getTransactionId());
            return rc;
        }
        HSXATransactionId tx = transactionInfo.getXaTransactionId();
        XATransactionId rc = new XATransactionId();
        rc.setBranchQualifier(tx.getBranchQualifier().toByteArray());
        rc.setGlobalTransactionId(tx.getGlobalTransactionId().toByteArray());
        rc.setFormatId(tx.getFormatId());
        return rc;
    }
}

