/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.hsdb.plist;

import com.bes.hsdb.index.ListIndex;
import com.bes.hsdb.journal.Location;
import com.bes.hsdb.page.Transaction;
import com.bes.hsdb.util.ByteSequence;
import com.bes.hsdb.util.LocationMarshaller;
import com.bes.hsdb.util.Marshaller;
import com.bes.hsdb.util.StringMarshaller;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.hsdb.plist.PListEntry;
import com.bes.mq.store.hsdb.plist.PListStore;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PList
extends ListIndex<String, Location> {
    static final Logger LOG = LoggerFactory.getLogger(PList.class);
    final PListStore store;
    private String name;
    Object indexLock;

    PList(PListStore store) {
        this.store = store;
        this.indexLock = store.getIndexLock();
        this.setPageFile(store.getPageFile());
        this.setKeyMarshaller((Marshaller)StringMarshaller.INSTANCE);
        this.setValueMarshaller((Marshaller)LocationMarshaller.INSTANCE);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void read(DataInput in) throws IOException {
        this.setHeadPageId(in.readLong());
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.getHeadPageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    PList.this.clear(tx);
                    PList.this.unload(tx);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(final String id, ByteSequence bs) throws IOException {
        final Location location = this.store.write(bs, false);
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    PList.this.add(tx, id, location);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(final String id, ByteSequence bs) throws IOException {
        final Location location = this.store.write(bs, false);
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    PList.this.addFirst(tx, id, location);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(final String id) throws IOException {
        final AtomicBoolean result = new AtomicBoolean();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    result.set(PList.this.remove(tx, id) != null);
                }
            });
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(final long position) throws IOException {
        final AtomicBoolean result = new AtomicBoolean();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    Iterator iterator = PList.this.iterator(tx, position);
                    if (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                        result.set(true);
                    } else {
                        result.set(false);
                    }
                }
            });
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PListEntry get(final long position) throws IOException {
        PListEntry result = null;
        final AtomicReference ref = new AtomicReference();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    Iterator iterator = PList.this.iterator(tx, position);
                    ref.set(iterator.next());
                }
            });
        }
        if (ref.get() != null) {
            ByteSequence bs = this.store.getPayload((Location)((Map.Entry)ref.get()).getValue());
            result = new PListEntry((String)((Map.Entry)ref.get()).getKey(), bs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PListEntry getFirst() throws IOException {
        PListEntry result = null;
        final AtomicReference ref = new AtomicReference();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    ref.set(PList.this.getFirst(tx));
                }
            });
        }
        if (ref.get() != null) {
            ByteSequence bs = this.store.getPayload((Location)((Map.Entry)ref.get()).getValue());
            result = new PListEntry((String)((Map.Entry)ref.get()).getKey(), bs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PListEntry getLast() throws IOException {
        PListEntry result = null;
        final AtomicReference ref = new AtomicReference();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    ref.set(PList.this.getLast(tx));
                }
            });
        }
        if (ref.get() != null) {
            ByteSequence bs = this.store.getPayload((Location)((Map.Entry)ref.get()).getValue());
            result = new PListEntry((String)((Map.Entry)ref.get()).getKey(), bs);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public PListIterator iterator() throws IOException {
        return new PListIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void claimFileLocations(final Set<Integer> candidates) throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            if (this.loaded.get()) {
                this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                    public void execute(Transaction tx) throws IOException {
                        Iterator iterator = PList.this.iterator(tx);
                        while (iterator.hasNext()) {
                            Location location = (Location)((Map.Entry)iterator.next()).getValue();
                            candidates.remove(location.getDataFileId());
                        }
                    }
                });
            }
        }
    }

    public String toString() {
        return this.name + "[headPageId=" + this.getHeadPageId() + ",tailPageId=" + this.getTailPageId() + ", size=" + this.size() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class PListIterator
    implements Iterator<PListEntry> {
        final Iterator<Map.Entry<String, Location>> iterator;
        final Transaction tx;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PListIterator() throws IOException {
            this.tx = PList.this.store.pageFile.tx();
            Object object = PList.this.indexLock;
            synchronized (object) {
                this.iterator = PList.this.iterator(this.tx);
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public PListEntry next() {
            Map.Entry<String, Location> entry = this.iterator.next();
            ByteSequence bs = null;
            try {
                bs = PList.this.store.getPayload(entry.getValue());
            }
            catch (IOException unexpected) {
                NoSuchElementException e = new NoSuchElementException(unexpected.getLocalizedMessage());
                e.initCause(unexpected);
                throw e;
            }
            return new PListEntry(entry.getKey(), bs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            try {
                Object object = PList.this.indexLock;
                synchronized (object) {
                    this.tx.execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                        public void execute(Transaction tx) throws IOException {
                            PListIterator.this.iterator.remove();
                        }
                    });
                }
            }
            catch (IOException unexpected) {
                IllegalStateException e = new IllegalStateException(unexpected.getLocalizedMessage());
                e.initCause(unexpected);
                throw e;
            }
        }

        public void release() {
            try {
                this.tx.rollback();
            }
            catch (IOException unexpected) {
                IllegalStateException e = new IllegalStateException(unexpected.getLocalizedMessage());
                e.initCause(unexpected);
                throw e;
            }
        }
    }
}

