/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.jdbc;

import com.bes.mq.broker.LockableServiceSupport;
import com.bes.mq.util.IOHelper;
import java.io.File;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;

public abstract class DataSourceServiceSupport
extends LockableServiceSupport {
    private String dataDirectory = IOHelper.getDefaultDataDirectory();
    private File dataDirectoryFile;
    private DataSource dataSource;

    public DataSourceServiceSupport() {
    }

    public DataSourceServiceSupport(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public File getDataDirectoryFile() {
        if (this.dataDirectoryFile == null) {
            this.dataDirectoryFile = new File(this.getDataDirectory());
        }
        return this.dataDirectoryFile;
    }

    public void setDataDirectoryFile(File dataDirectory) {
        this.dataDirectoryFile = dataDirectory;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public DataSource getDataSource() throws IOException {
        if (this.dataSource == null) {
            this.dataSource = DataSourceServiceSupport.createDataSource(this.getDataDirectoryFile().getCanonicalPath());
            if (this.dataSource == null) {
                throw new IllegalArgumentException("No dataSource property has been configured");
            }
        }
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static DataSource createDataSource(String homeDir) throws IOException {
        System.setProperty("derby.system.home", homeDir);
        System.setProperty("derby.storage.fileSyncTransactionLog", "true");
        System.setProperty("derby.storage.pageCacheSize", "100");
        EmbeddedDataSource ds = new EmbeddedDataSource();
        ds.setDatabaseName("derbydb");
        ds.setCreateDatabase("create");
        return ds;
    }

    public String toString() {
        return "" + this.dataSource;
    }
}

