/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.jdbc;

import com.bes.mq.broker.AbstractLocker;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.jdbc.JDBCPersistenceAdapter;
import com.bes.mq.store.jdbc.Statements;
import com.bes.mq.util.Handler;
import com.bes.mq.util.ServiceStopper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;

public class DefaultDatabaseLocker
extends AbstractLocker {
    public static final long DEFAULT_LOCK_ACQUIRE_SLEEP_INTERVAL = 10000L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDatabaseLocker.class);
    protected DataSource dataSource;
    protected Statements statements;
    protected volatile PreparedStatement lockCreateStatement;
    protected volatile PreparedStatement lockUpdateStatement;
    protected volatile Connection connection;
    protected volatile boolean stopping;
    protected Handler<Exception> exceptionHandler;
    protected int queryTimeout = 10;

    public void configure(PersistenceAdapter adapter) throws IOException {
        if (adapter instanceof JDBCPersistenceAdapter) {
            this.dataSource = ((JDBCPersistenceAdapter)adapter).getLockDataSource();
            this.statements = ((JDBCPersistenceAdapter)adapter).getStatements();
        }
        this.lockAcquireSleepInterval = 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doStart() throws Exception {
        this.stopping = false;
        DefaultDatabaseLocker.LOG.info("Attempting to acquire the exclusive lock to become the master broker");
        sql = this.statements.getLockCreateStatement();
        DefaultDatabaseLocker.LOG.debug("Locking Query is " + sql);
        while (!this.stopping) {
            this.connection = this.dataSource.getConnection();
            this.connection.setAutoCommit(false);
            this.lockCreateStatement = this.connection.prepareStatement(sql);
            this.lockCreateStatement.execute();
            var8_8 = null;
            if (null == this.lockCreateStatement) break;
            try {
                this.lockCreateStatement.close();
            }
            catch (SQLException e1) {
                DefaultDatabaseLocker.LOG.debug("Caught while closing statement: " + e1, e1);
            }
            break;
            {
                catch (Exception e) {
                    this.lockAcquireFailed(e);
                    try {
                        if (this.stopping) {
                            throw new Exception("Cannot start broker as being asked to shut down. Interrupted attempt to acquire lock: " + e, e);
                        }
                        if (this.exceptionHandler != null) {
                            try {
                                this.exceptionHandler.handle(e);
                            }
                            catch (Throwable handlerException) {
                                DefaultDatabaseLocker.LOG.error("The exception handler " + this.exceptionHandler.getClass().getCanonicalName() + " threw this exception: " + handlerException + " while trying to handle this exception: " + e, handlerException);
                            }
                        } else {
                            DefaultDatabaseLocker.LOG.debug("Lock failure: " + e, e);
                        }
                        var5_6 = null;
                        ** if (null == this.connection) goto lbl-1000
                    }
                    catch (Throwable var4_10) {
                        var5_6 = null;
                        if (null != this.connection) {
                            try {
                                this.connection.close();
                            }
                            catch (SQLException e1) {
                                DefaultDatabaseLocker.LOG.error("Caught exception while closing connection: " + e1, e1);
                            }
                        }
                        throw var4_10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.connection.close();
                        }
                        catch (SQLException e1) {
                            DefaultDatabaseLocker.LOG.error("Caught exception while closing connection: " + e1, e1);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    var8_8 = null;
                    if (null != this.lockCreateStatement) {
                        try {
                            this.lockCreateStatement.close();
                        }
                        catch (SQLException e1) {
                            DefaultDatabaseLocker.LOG.debug("Caught while closing statement: " + e1, e1);
                        }
                    }
                }
            }
            catch (Throwable var7_11) {
                var8_8 = null;
                if (null != this.lockCreateStatement) {
                    try {
                        this.lockCreateStatement.close();
                    }
                    catch (SQLException e1) {
                        DefaultDatabaseLocker.LOG.debug("Caught while closing statement: " + e1, e1);
                    }
                }
                throw var7_11;
            }
            try {
                Thread.sleep(this.lockAcquireSleepInterval);
            }
            catch (InterruptedException ie) {
                DefaultDatabaseLocker.LOG.warn("Master lock retry sleep interrupted", ie);
            }
        }
        if (this.stopping) {
            throw new RuntimeException("Attempting to obtain lock aborted due to shutdown");
        }
        DefaultDatabaseLocker.LOG.info("Becoming the master broker");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doStop(ServiceStopper stopper) throws Exception {
        block16: {
            this.stopping = true;
            try {
                if (this.lockCreateStatement != null && !this.lockCreateStatement.isClosed()) {
                    this.lockCreateStatement.cancel();
                }
            }
            catch (SQLFeatureNotSupportedException e) {
                LOG.warn("Failed to cancel locking query on dataSource" + this.dataSource, e);
            }
            try {
                if (this.lockUpdateStatement != null && !this.lockUpdateStatement.isClosed()) {
                    this.lockUpdateStatement.cancel();
                }
            }
            catch (SQLFeatureNotSupportedException e) {
                LOG.warn("Failed to cancel locking query on dataSource" + this.dataSource, e);
            }
            if (this.connection != null) {
                block15: {
                    if (this.connection.getAutoCommit()) break block15;
                    this.connection.rollback();
                }
                Object var4_6 = null;
                try {
                    this.connection.close();
                }
                catch (SQLException ignored) {
                    LOG.debug("Exception while closing connection on shutdown. This exception is ignored.", ignored);
                }
                break block16;
                {
                    catch (SQLException sqle) {
                        LOG.warn("Exception while rollbacking the connection on shutdown. This exception is ignored.", sqle);
                        Object var4_7 = null;
                        try {
                            this.connection.close();
                        }
                        catch (SQLException ignored) {
                            LOG.debug("Exception while closing connection on shutdown. This exception is ignored.", ignored);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    try {
                        this.connection.close();
                    }
                    catch (SQLException ignored) {
                        LOG.debug("Exception while closing connection on shutdown. This exception is ignored.", ignored);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean keepAlive() throws IOException {
        boolean result;
        block11: {
            block10: {
                int rows;
                result = false;
                this.lockUpdateStatement = this.connection.prepareStatement(this.statements.getLockUpdateStatement());
                this.lockUpdateStatement.setLong(1, System.currentTimeMillis());
                if (this.queryTimeout > 0) {
                    this.lockUpdateStatement.setQueryTimeout(this.queryTimeout);
                }
                if ((rows = this.lockUpdateStatement.executeUpdate()) != 1) break block10;
                result = true;
            }
            Object var4_4 = null;
            if (this.lockUpdateStatement == null) break block11;
            try {
                this.lockUpdateStatement.close();
            }
            catch (SQLException e2) {
                LOG.error("Failed to close statement", e2);
            }
            this.lockUpdateStatement = null;
            {
                break block11;
                catch (Exception e) {
                    LOG.error("Failed to update database lock: " + e, e);
                    Object var4_5 = null;
                    if (this.lockUpdateStatement == null) break block11;
                    try {
                        this.lockUpdateStatement.close();
                    }
                    catch (SQLException e2) {
                        LOG.error("Failed to close statement", e2);
                    }
                    this.lockUpdateStatement = null;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (this.lockUpdateStatement != null) {
                    try {
                        this.lockUpdateStatement.close();
                    }
                    catch (SQLException e2) {
                        LOG.error("Failed to close statement", e2);
                    }
                    this.lockUpdateStatement = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    public long getLockAcquireSleepInterval() {
        return this.lockAcquireSleepInterval;
    }

    public void setLockAcquireSleepInterval(long lockAcquireSleepInterval) {
        this.lockAcquireSleepInterval = lockAcquireSleepInterval;
    }

    public Handler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(Handler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    protected Logger getLogger() {
        return LOG;
    }
}

