/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.jdbc;

import com.bes.mq.BESMQMessageAudit;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.store.AbstractMessageStore;
import com.bes.mq.store.MessageRecoveryListener;
import com.bes.mq.store.jdbc.JDBCAdapter;
import com.bes.mq.store.jdbc.JDBCMessageRecoveryListener;
import com.bes.mq.store.jdbc.JDBCPersistenceAdapter;
import com.bes.mq.store.jdbc.TransactionContext;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.ByteSequenceData;
import com.bes.mq.util.IOExceptionSupport;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;

public class JDBCMessageStore
extends AbstractMessageStore {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCMessageStore.class);
    protected final ProtocolFormat protocolFormat;
    protected final JDBCAdapter adapter;
    protected final JDBCPersistenceAdapter persistenceAdapter;
    protected AtomicLong lastRecoveredSequenceId = new AtomicLong(-1L);
    protected AtomicLong lastRecoveredPriority = new AtomicLong(126L);
    protected BESMQMessageAudit audit;

    public JDBCMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, ProtocolFormat protocolFormat, BESMQDestination destination, BESMQMessageAudit audit) throws IOException {
        super(destination);
        this.persistenceAdapter = persistenceAdapter;
        this.adapter = adapter;
        this.protocolFormat = protocolFormat;
        this.audit = audit;
        if (destination.isQueue() && persistenceAdapter.getBrokerService().shouldRecordVirtualDestination(destination)) {
            this.recordDestinationCreation(destination);
        }
    }

    private void recordDestinationCreation(BESMQDestination destination) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            block4: {
                try {
                    c = this.persistenceAdapter.getTransactionContext();
                    if (this.adapter.doGetLastAckedDurableSubscriberMessageId(c, destination, destination.getQualifiedName(), destination.getQualifiedName()) >= 0L) break block4;
                    this.adapter.doRecordDestination(c, destination);
                }
                catch (SQLException e) {
                    JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                    throw IOExceptionSupport.create("Failed to record destination: " + destination + ". Reason: " + e, e);
                }
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public void addMessage(ConnectionContext context, Message message) throws IOException {
        byte[] data;
        MessageId messageId = message.getMessageId();
        if (this.audit != null && this.audit.isDuplicate(message)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.destination.getPhysicalName() + " ignoring duplicated (add) message, already stored: " + messageId);
            }
            return;
        }
        long sequenceId = this.persistenceAdapter.getNextSequenceId();
        try {
            ByteSequence packet = this.protocolFormat.marshal(message);
            data = ByteSequenceData.toByteArray(packet);
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to add broker message: " + messageId + " in container: " + e, e);
        }
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            try {
                this.adapter.doAddMessage(c, sequenceId, messageId, this.destination, data, message.getExpiration(), this.isPrioritizedMessages() ? message.getPriority() : (byte)0, context != null ? context.getXid() : null);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to add broker message: " + messageId + " in container: " + e, e);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            c.close();
            throw throwable;
        }
        c.close();
        if (context != null && context.getXid() != null) {
            message.getMessageId().setDataLocator(sequenceId);
        } else {
            this.onAdd(messageId, sequenceId, message.getPriority());
        }
    }

    protected void onAdd(MessageId messageId, long sequenceId, byte priority) {
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            try {
                this.adapter.doAddMessageReference(c, this.persistenceAdapter.getNextSequenceId(), messageId, this.destination, expirationTime, messageRef);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to add broker message: " + messageId + " in container: " + e, e);
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message getMessage(MessageId messageId) throws IOException {
        Message message;
        TransactionContext c;
        block8: {
            Message message2;
            block7: {
                c = this.persistenceAdapter.getTransactionContext();
                try {
                    try {
                        Message answer;
                        byte[] data = this.adapter.doGetMessage(c, messageId);
                        if (data == null) {
                            message2 = null;
                            Object var7_8 = null;
                            break block7;
                        }
                        message = answer = (Message)this.protocolFormat.unmarshal(new ByteSequence(data));
                        break block8;
                    }
                    catch (IOException e) {
                        throw IOExceptionSupport.create("Failed to get broker message: " + messageId + " in container: " + e, e);
                    }
                    catch (SQLException e) {
                        JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                        throw IOExceptionSupport.create("Failed to get broker message: " + messageId + " in container: " + e, e);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    c.close();
                    throw throwable;
                }
            }
            c.close();
            return message2;
        }
        Object var7_9 = null;
        c.close();
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMessageReference(MessageId messageId) throws IOException {
        String string;
        long id = messageId.getBrokerSequenceId();
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            try {
                string = this.adapter.doGetMessageReference(c, id);
                Object var7_7 = null;
            }
            catch (IOException e) {
                throw IOExceptionSupport.create("Failed to get broker message: " + messageId + " in container: " + e, e);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to get broker message: " + messageId + " in container: " + e, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            c.close();
            throw throwable;
        }
        c.close();
        return string;
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        long seq = this.persistenceAdapter.getStoreSequenceIdForMessageId(ack.getLastMessageId(), this.destination)[0];
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            try {
                this.adapter.doRemoveMessage(c, seq, context != null ? context.getXid() : null);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to remove broker message: " + ack.getLastMessageId() + " in container: " + e, e);
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            c.close();
            throw throwable;
        }
        c.close();
        if (context != null && context.getXid() != null) {
            ack.getLastMessageId().setDataLocator(seq);
        }
    }

    public void recover(final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            try {
                c = this.persistenceAdapter.getTransactionContext();
                this.adapter.doRecover(c, this.destination, new JDBCMessageRecoveryListener(){

                    public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
                        Message msg = (Message)JDBCMessageStore.this.protocolFormat.unmarshal(new ByteSequence(data));
                        msg.getMessageId().setBrokerSequenceId(sequenceId);
                        boolean result = listener.recoverMessage(msg);
                        if (result) {
                            return listener.hasSpace();
                        }
                        return result;
                    }

                    public boolean recoverMessageReference(String reference) throws Exception {
                        return listener.recoverMessageReference(new MessageId(reference));
                    }
                });
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to recover container. Reason: " + e, e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            try {
                this.adapter.doRemoveAllMessages(c, this.destination);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to remove all messages: " + e, e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public int getMessageCount() throws IOException {
        int result = 0;
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            try {
                result = this.adapter.doGetMessageCount(c, this.destination);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to get Message Count: " + this.destination + ". Reason: " + e, e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            c.close();
            throw throwable;
        }
        c.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recoverNextMessages(int maxReturned, final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            try {
                this.adapter.doRecoverNextMessages(c, this.destination, this.lastRecoveredSequenceId.get(), this.lastRecoveredPriority.get(), maxReturned, this.isPrioritizedMessages(), new JDBCMessageRecoveryListener(){

                    public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
                        if (listener.hasSpace()) {
                            Message msg = (Message)JDBCMessageStore.this.protocolFormat.unmarshal(new ByteSequence(data));
                            msg.getMessageId().setBrokerSequenceId(sequenceId);
                            listener.recoverMessage(msg);
                            JDBCMessageStore.this.lastRecoveredSequenceId.set(sequenceId);
                            JDBCMessageStore.this.lastRecoveredPriority.set(msg.getPriority());
                            return true;
                        }
                        return false;
                    }

                    public boolean recoverMessageReference(String reference) throws Exception {
                        if (listener.hasSpace()) {
                            listener.recoverMessageReference(new MessageId(reference));
                            return true;
                        }
                        return false;
                    }
                });
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                Object var6_5 = null;
                c.close();
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public void resetBatching() {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.destination.getPhysicalName() + " resetBatching, existing last recovered seqId: " + this.lastRecoveredSequenceId.get());
        }
        this.lastRecoveredSequenceId.set(-1L);
        this.lastRecoveredPriority.set(126L);
    }

    public void setBatch(MessageId messageId) {
        try {
            long[] storedValues = this.persistenceAdapter.getStoreSequenceIdForMessageId(messageId, this.destination);
            this.lastRecoveredSequenceId.set(storedValues[0]);
            this.lastRecoveredPriority.set(storedValues[1]);
        }
        catch (IOException ignoredAsAlreadyLogged) {
            this.lastRecoveredSequenceId.set(-1L);
            this.lastRecoveredPriority.set(126L);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.destination.getPhysicalName() + " setBatch: new sequenceId: " + this.lastRecoveredSequenceId.get() + ", priority: " + this.lastRecoveredPriority.get());
        }
    }

    public void setPrioritizedMessages(boolean prioritizedMessages) {
        super.setPrioritizedMessages(prioritizedMessages);
    }

    class Duration {
        static final int LIMIT = 100;
        final long start = System.currentTimeMillis();
        final String name;

        Duration(String name) {
            this.name = name;
        }

        void end() {
            this.end(null);
        }

        void end(Object o) {
            long duration = System.currentTimeMillis() - this.start;
            if (duration > 100L) {
                System.err.println(this.name + " took a long time: " + duration + "ms " + o);
            }
        }
    }
}

