/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.jdbc;

import com.bes.mq.BESMQMessageAudit;
import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.Locker;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.store.MessageStore;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.TransactionStore;
import com.bes.mq.store.jdbc.DataSourceServiceSupport;
import com.bes.mq.store.jdbc.DefaultDatabaseLocker;
import com.bes.mq.store.jdbc.JDBCAdapter;
import com.bes.mq.store.jdbc.JDBCMessageIdScanListener;
import com.bes.mq.store.jdbc.JDBCMessageStore;
import com.bes.mq.store.jdbc.JDBCTopicMessageStore;
import com.bes.mq.store.jdbc.JdbcMemoryTransactionStore;
import com.bes.mq.store.jdbc.Statements;
import com.bes.mq.store.jdbc.TransactionContext;
import com.bes.mq.store.jdbc.adapter.DefaultJDBCAdapter;
import com.bes.mq.store.memory.MemoryTransactionStore;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.FactoryFinder;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.LongSequenceGenerator;
import com.bes.mq.util.ServiceStopper;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPersistenceAdapter
extends DataSourceServiceSupport
implements PersistenceAdapter,
BrokerServiceAware {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCPersistenceAdapter.class);
    private static FactoryFinder adapterFactoryFinder = new FactoryFinder("META-INF/services/com/bes/mq/store/jdbc/");
    private static FactoryFinder lockFactoryFinder = new FactoryFinder("META-INF/services/com/bes/mq/store/jdbc/lock/");
    public static final long DEFAULT_LOCK_KEEP_ALIVE_PERIOD = 30000L;
    private ProtocolFormat protocolFormat = new BESMPFormat();
    private BrokerService brokerService;
    private Statements statements;
    private JDBCAdapter adapter;
    private MemoryTransactionStore transactionStore;
    private ScheduledThreadPoolExecutor clockDaemon;
    private ScheduledFuture<?> cleanupTicket;
    private int cleanupPeriod = 300000;
    private boolean useExternalMessageReferences;
    private boolean createTablesOnStartup = true;
    private DataSource lockDataSource;
    private int transactionIsolation;
    private File directory;
    protected int maxProducersToAudit = 1024;
    protected int maxAuditDepth = 1000;
    protected boolean enableAudit = false;
    protected int auditRecoveryDepth = 1024;
    protected BESMQMessageAudit audit;
    protected LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();
    protected int maxRows = 200;

    public JDBCPersistenceAdapter() {
        this.setLockKeepAlivePeriod(30000L);
    }

    public JDBCPersistenceAdapter(DataSource ds, ProtocolFormat protocolFormat) {
        super(ds);
        this.setLockKeepAlivePeriod(30000L);
        this.protocolFormat = protocolFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Set<BESMQDestination> getDestinations() {
        Set<BESMQDestination> set;
        TransactionContext c;
        block11: {
            c = null;
            c = this.getTransactionContext();
            set = this.getAdapter().doGetDestinations(c);
            Object var5_5 = null;
            if (c == null) break block11;
            try {
                c.close();
            }
            catch (Throwable e2) {
                // empty catch block
            }
        }
        return set;
        catch (IOException e) {
            Set<BESMQDestination> set2;
            block12: {
                set2 = this.emptyDestinationSet();
                Object var5_6 = null;
                if (c == null) break block12;
                try {
                    c.close();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
            return set2;
        }
        catch (SQLException e) {
            Set<BESMQDestination> set3;
            block13: {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                set3 = this.emptyDestinationSet();
                Object var5_7 = null;
                if (c == null) break block13;
                {
                    catch (Throwable throwable) {
                        block14: {
                            Object var5_8 = null;
                            if (c == null) break block14;
                            try {
                                c.close();
                            }
                            catch (Throwable e2) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    c.close();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
            return set3;
        }
    }

    private Set<BESMQDestination> emptyDestinationSet() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createMessageAudit() {
        if (!this.enableAudit || this.audit != null) return;
        this.audit = new BESMQMessageAudit(this.maxAuditDepth, this.maxProducersToAudit);
        TransactionContext c = null;
        c = this.getTransactionContext();
        this.getAdapter().doMessageIdScan(c, this.auditRecoveryDepth, new JDBCMessageIdScanListener(){

            public void messageId(MessageId id) {
                JDBCPersistenceAdapter.this.audit.isDuplicate(id);
            }
        });
        Object var4_2 = null;
        if (c == null) return;
        try {
            c.close();
            return;
        }
        catch (Throwable e2) {}
        return;
        {
            catch (Exception e) {
                LOG.error("Failed to reload store message audit for JDBC persistence adapter", e);
                Object var4_3 = null;
                if (c == null) return;
                try {
                    c.close();
                    return;
                }
                catch (Throwable e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (c == null) throw throwable;
            try {
                c.close();
                throw throwable;
            }
            catch (Throwable e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initSequenceIdGenerator() {
        TransactionContext c = null;
        c = this.getTransactionContext();
        this.getAdapter().doMessageIdScan(c, this.auditRecoveryDepth, new JDBCMessageIdScanListener(){

            public void messageId(MessageId id) {
                JDBCPersistenceAdapter.this.audit.isDuplicate(id);
            }
        });
        Object var4_2 = null;
        if (c == null) return;
        try {
            c.close();
            return;
        }
        catch (Throwable e2) {}
        return;
        {
            catch (Exception e) {
                LOG.error("Failed to reload store message audit for JDBC persistence adapter", e);
                Object var4_3 = null;
                if (c == null) return;
                try {
                    c.close();
                    return;
                }
                catch (Throwable e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (c == null) throw throwable;
            try {
                c.close();
                throw throwable;
            }
            catch (Throwable e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    @Override
    public MessageStore createQueueMessageStore(BESMQQueue destination) throws IOException {
        MessageStore rc = new JDBCMessageStore(this, this.getAdapter(), this.protocolFormat, destination, this.audit);
        if (this.transactionStore != null) {
            rc = this.transactionStore.proxy(rc);
        }
        return rc;
    }

    @Override
    public TopicMessageStore createTopicMessageStore(BESMQTopic destination) throws IOException {
        TopicMessageStore rc = new JDBCTopicMessageStore(this, this.getAdapter(), this.protocolFormat, destination, this.audit);
        if (this.transactionStore != null) {
            rc = this.transactionStore.proxy(rc);
        }
        return rc;
    }

    @Override
    public void removeQueueMessageStore(BESMQQueue destination) {
        if (destination.isQueue() && this.getBrokerService().shouldRecordVirtualDestination(destination)) {
            try {
                this.removeConsumerDestination(destination);
            }
            catch (IOException ioe) {
                LOG.error("Failed to remove consumer destination: " + destination, ioe);
            }
        }
    }

    private void removeConsumerDestination(BESMQQueue destination) throws IOException {
        TransactionContext c = this.getTransactionContext();
        try {
            try {
                String id = destination.getQualifiedName();
                this.getAdapter().doDeleteSubscription(c, destination, id, id);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to remove consumer destination: " + destination, e);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    @Override
    public void removeTopicMessageStore(BESMQTopic destination) {
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            this.transactionStore = new JdbcMemoryTransactionStore(this);
        }
        return this.transactionStore;
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        long l;
        TransactionContext c = this.getTransactionContext();
        try {
            long seq = this.getAdapter().doGetLastMessageStoreSequenceId(c);
            this.sequenceGenerator.setLastSequenceId(seq);
            long brokerSeq = 0L;
            if (seq != 0L) {
                byte[] msg = this.getAdapter().doGetMessageById(c, seq);
                if (msg != null) {
                    Message last = (Message)this.protocolFormat.unmarshal(new ByteSequence(msg));
                    brokerSeq = last.getMessageId().getBrokerSequenceId();
                } else {
                    LOG.warn("Broker sequence id wasn't recovered properly, possible duplicates!");
                }
            }
            l = brokerSeq;
            Object var9_8 = null;
        }
        catch (SQLException e) {
            try {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to get last broker message id: " + e, e);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                c.close();
                throw throwable;
            }
        }
        c.close();
        return l;
    }

    @Override
    public long getLastProducerSequenceId(ProducerId id) throws IOException {
        long l;
        TransactionContext c = this.getTransactionContext();
        try {
            l = this.getAdapter().doGetLastProducerSequenceId(c, id);
            Object var6_5 = null;
        }
        catch (SQLException e) {
            try {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to get last broker message id: " + e, e);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                c.close();
                throw throwable;
            }
        }
        c.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        this.getAdapter().setUseExternalMessageReferences(this.isUseExternalMessageReferences());
        if (this.isCreateTablesOnStartup()) {
            TransactionContext transactionContext = this.getTransactionContext();
            transactionContext.begin();
            try {
                try {
                    this.getAdapter().doCreateTables(transactionContext);
                }
                catch (SQLException e) {
                    LOG.warn("Cannot create tables due to: " + e);
                    JDBCPersistenceAdapter.log("Failure Details: ", e);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                transactionContext.commit();
                throw throwable;
            }
            transactionContext.commit();
            {
            }
        }
    }

    @Override
    public void doStart() throws Exception {
        if (this.cleanupPeriod > 0) {
            this.cleanupTicket = this.getScheduledThreadPoolExecutor().scheduleWithFixedDelay(new Runnable(){

                public void run() {
                    JDBCPersistenceAdapter.this.cleanup();
                }
            }, 0L, this.cleanupPeriod, TimeUnit.MILLISECONDS);
        }
        this.createMessageAudit();
    }

    @Override
    public synchronized void doStop(ServiceStopper stopper) throws Exception {
        if (this.cleanupTicket != null) {
            this.cleanupTicket.cancel(true);
            this.cleanupTicket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void cleanup() {
        block14: {
            TransactionContext c;
            block13: {
                c = null;
                LOG.debug("Cleaning up old messages.");
                c = this.getTransactionContext();
                this.getAdapter().doDeleteOldMessages(c);
                Object var4_2 = null;
                if (c == null) break block13;
                try {
                    c.close();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
            LOG.debug("Cleanup done.");
            {
                break block14;
                catch (IOException e) {
                    LOG.warn("Old message cleanup failed due to: " + e, e);
                    Object var4_3 = null;
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                    }
                    LOG.debug("Cleanup done.");
                    break block14;
                }
                catch (SQLException e) {
                    LOG.warn("Old message cleanup failed due to: " + e);
                    JDBCPersistenceAdapter.log("Failure Details: ", e);
                    Object var4_4 = null;
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                    }
                    LOG.debug("Cleanup done.");
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                }
                LOG.debug("Cleanup done.");
                throw throwable;
            }
        }
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor clockDaemon) {
        this.clockDaemon = clockDaemon;
    }

    @Override
    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        if (this.clockDaemon == null) {
            this.clockDaemon = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "BESMQ Cleanup Timer");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return this.clockDaemon;
    }

    public JDBCAdapter getAdapter() throws IOException {
        if (this.adapter == null) {
            this.setAdapter(this.createAdapter());
        }
        return this.adapter;
    }

    @Deprecated
    public Locker getDatabaseLocker() throws IOException {
        return this.getLocker();
    }

    public void setDatabaseLocker(Locker locker) throws IOException {
        this.setLocker(locker);
    }

    public DataSource getLockDataSource() throws IOException {
        if (this.lockDataSource == null) {
            this.lockDataSource = this.getDataSource();
            if (this.lockDataSource == null) {
                throw new IllegalArgumentException("No dataSource property has been configured");
            }
        } else {
            LOG.info("Using a separate dataSource for locking: " + this.lockDataSource);
        }
        return this.lockDataSource;
    }

    public void setLockDataSource(DataSource dataSource) {
        this.lockDataSource = dataSource;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        super.setBrokerService(brokerService);
        this.brokerService = brokerService;
    }

    protected JDBCAdapter createAdapter() throws IOException {
        this.adapter = (JDBCAdapter)this.loadAdapter(adapterFactoryFinder, "adapter");
        if (this.adapter == null) {
            this.adapter = new DefaultJDBCAdapter();
            LOG.debug("Using default JDBC Adapter: " + this.adapter);
        }
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadAdapter(FactoryFinder finder, String kind) throws IOException {
        Object adapter = null;
        TransactionContext c = this.getTransactionContext();
        try {
            try {
                String dirverName = c.getConnection().getMetaData().getDriverName();
                dirverName = dirverName.replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase(Locale.ENGLISH);
                try {
                    adapter = finder.newInstance(dirverName);
                    LOG.info("Database " + kind + " driver override recognized for : [" + dirverName + "] - adapter: " + adapter.getClass());
                }
                catch (Throwable e) {
                    LOG.info("Database " + kind + " driver override not found for : [" + dirverName + "].  Will use default implementation.");
                }
            }
            catch (SQLException e) {
                LOG.warn("JDBC error occurred while trying to detect database type for overrides. Will use default implementations: " + e.getMessage());
                JDBCPersistenceAdapter.log("Failure Details: ", e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            c.close();
            throw throwable;
        }
        c.close();
        return adapter;
    }

    public void setAdapter(JDBCAdapter adapter) {
        this.adapter = adapter;
        this.adapter.setStatements(this.getStatements());
        this.adapter.setMaxRows(this.getMaxRows());
    }

    public ProtocolFormat getProtocolFormat() {
        return this.protocolFormat;
    }

    public void setProtocolFormat(ProtocolFormat protocolFormat) {
        this.protocolFormat = protocolFormat;
    }

    public TransactionContext getTransactionContext(ConnectionContext context) throws IOException {
        if (context == null) {
            return this.getTransactionContext();
        }
        TransactionContext answer = (TransactionContext)context.getLongTermStoreContext();
        if (answer == null) {
            answer = this.getTransactionContext();
            context.setLongTermStoreContext(answer);
        }
        return answer;
    }

    public TransactionContext getTransactionContext() throws IOException {
        TransactionContext answer = new TransactionContext(this);
        if (this.transactionIsolation > 0) {
            answer.setTransactionIsolation(this.transactionIsolation);
        }
        return answer;
    }

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.begin();
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.commit();
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.rollback();
    }

    public int getCleanupPeriod() {
        return this.cleanupPeriod;
    }

    public void setCleanupPeriod(int cleanupPeriod) {
        this.cleanupPeriod = cleanupPeriod;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        TransactionContext c = this.getTransactionContext();
        try {
            try {
                this.getAdapter().doDropTables(c);
                this.getAdapter().setUseExternalMessageReferences(this.isUseExternalMessageReferences());
                this.getAdapter().doCreateTables(c);
                LOG.info("Persistence store purged.");
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create(e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public boolean isUseExternalMessageReferences() {
        return this.useExternalMessageReferences;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.useExternalMessageReferences = useExternalMessageReferences;
    }

    public boolean isCreateTablesOnStartup() {
        return this.createTablesOnStartup;
    }

    public void setCreateTablesOnStartup(boolean createTablesOnStartup) {
        this.createTablesOnStartup = createTablesOnStartup;
    }

    @Deprecated
    public void setUseDatabaseLock(boolean useDatabaseLock) {
        this.setUseLock(useDatabaseLock);
    }

    public static void log(String msg, SQLException e) {
        String s = msg + e.getMessage();
        while (e.getNextException() != null) {
            e = e.getNextException();
            s = s + ", due to: " + e.getMessage();
        }
        LOG.warn(s, e);
    }

    public Statements getStatements() {
        if (this.statements == null) {
            this.statements = new Statements();
        }
        return this.statements;
    }

    public void setStatements(Statements statements) {
        this.statements = statements;
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
    }

    @Override
    public Locker createDefaultLocker() throws IOException {
        DefaultDatabaseLocker locker = (DefaultDatabaseLocker)this.loadAdapter(lockFactoryFinder, "lock");
        if (locker == null) {
            locker = new DefaultDatabaseLocker();
            LOG.debug("Using default JDBC Locker: " + locker);
        }
        locker.configure(this);
        return locker;
    }

    @Override
    public void setBrokerName(String brokerName) {
    }

    @Override
    public String toString() {
        return "JDBCPersistenceAdapter(" + super.toString() + ")";
    }

    @Override
    public void setDirectory(File dir) {
        this.directory = dir;
    }

    @Override
    public File getDirectory() {
        if (this.directory == null && this.brokerService != null) {
            this.directory = this.brokerService.getBrokerDataDirectory();
        }
        return this.directory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkpoint(boolean sync) throws IOException {
        Connection connection = null;
        try {
            try {
                connection = this.getDataSource().getConnection();
            }
            catch (SQLException e) {
                LOG.debug("Could not get JDBC connection for checkpoint: " + e);
                throw IOExceptionSupport.create(e);
            }
            Object var5_3 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable ignored) {}
        connection.close();
        return;
    }

    @Override
    public long size() {
        return 0L;
    }

    public void setLockAcquireSleepInterval(long lockAcquireSleepInterval) throws IOException {
        this.getLocker().setLockAcquireSleepInterval(lockAcquireSleepInterval);
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public int getMaxProducersToAudit() {
        return this.maxProducersToAudit;
    }

    public void setMaxProducersToAudit(int maxProducersToAudit) {
        this.maxProducersToAudit = maxProducersToAudit;
    }

    public int getMaxAuditDepth() {
        return this.maxAuditDepth;
    }

    public void setMaxAuditDepth(int maxAuditDepth) {
        this.maxAuditDepth = maxAuditDepth;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    public int getAuditRecoveryDepth() {
        return this.auditRecoveryDepth;
    }

    public void setAuditRecoveryDepth(int auditRecoveryDepth) {
        this.auditRecoveryDepth = auditRecoveryDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSequenceId() {
        LongSequenceGenerator longSequenceGenerator = this.sequenceGenerator;
        synchronized (longSequenceGenerator) {
            return this.sequenceGenerator.getNextSequenceId();
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void recover(JdbcMemoryTransactionStore jdbcMemoryTransactionStore) throws IOException {
        TransactionContext c = this.getTransactionContext();
        try {
            try {
                this.getAdapter().doRecoverPreparedOps(c, jdbcMemoryTransactionStore);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to recover from: " + jdbcMemoryTransactionStore + ". Reason: " + e, e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public void commitAdd(ConnectionContext context, MessageId messageId) throws IOException {
        TransactionContext c = this.getTransactionContext(context);
        try {
            try {
                long sequence = (Long)messageId.getDataLocator();
                this.getAdapter().doCommitAddOp(c, sequence);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to commit add: " + messageId + ". Reason: " + e, e);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public void commitRemove(ConnectionContext context, MessageAck ack) throws IOException {
        TransactionContext c = this.getTransactionContext(context);
        try {
            try {
                this.getAdapter().doRemoveMessage(c, (Long)ack.getLastMessageId().getDataLocator(), null);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to commit last ack: " + ack + ". Reason: " + e, e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public void commitLastAck(ConnectionContext context, long xidLastAck, long priority, BESMQDestination destination, String subName, String clientId) throws IOException {
        TransactionContext c = this.getTransactionContext(context);
        try {
            try {
                this.getAdapter().doSetLastAck(c, destination, null, clientId, subName, xidLastAck, priority);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to commit last ack with priority: " + priority + " on " + destination + " for " + subName + ":" + clientId + ". Reason: " + e, e);
            }
            Object var12_8 = null;
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public void rollbackLastAck(ConnectionContext context, JDBCTopicMessageStore store, MessageAck ack, String subName, String clientId) throws IOException {
        TransactionContext c = this.getTransactionContext(context);
        try {
            try {
                byte priority = (byte)store.getCachedStoreSequenceId(c, store.getDestination(), ack.getLastMessageId())[1];
                this.getAdapter().doClearLastAck(c, store.getDestination(), priority, clientId, subName);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to rollback last ack: " + ack + " on " + store.getDestination() + " for " + subName + ":" + clientId + ". Reason: " + e, e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public void rollbackLastAck(ConnectionContext context, byte priority, BESMQDestination destination, String subName, String clientId) throws IOException {
        TransactionContext c = this.getTransactionContext(context);
        try {
            try {
                this.getAdapter().doClearLastAck(c, destination, priority, clientId, subName);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to rollback last ack with priority: " + priority + " on " + destination + " for " + subName + ":" + clientId + ". Reason: " + e, e);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    long[] getStoreSequenceIdForMessageId(MessageId messageId, BESMQDestination destination) throws IOException {
        long[] result = new long[]{-1L, 126L};
        TransactionContext c = this.getTransactionContext();
        try {
            try {
                result = this.adapter.getStoreSequenceId(c, destination, messageId);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to get store sequenceId for messageId: " + messageId + ", on: " + destination + ". Reason: " + e, e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            c.close();
            throw throwable;
        }
        c.close();
        return result;
    }
}

