/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.jdbc;

import com.bes.mq.BESMQMessageAudit;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.SubscriptionInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.store.MessageRecoveryListener;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.jdbc.JDBCAdapter;
import com.bes.mq.store.jdbc.JDBCMessageRecoveryListener;
import com.bes.mq.store.jdbc.JDBCMessageStore;
import com.bes.mq.store.jdbc.JDBCPersistenceAdapter;
import com.bes.mq.store.jdbc.TransactionContext;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.IOExceptionSupport;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JDBCTopicMessageStore
extends JDBCMessageStore
implements TopicMessageStore {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCTopicMessageStore.class);
    private Map<String, LastRecovered> subscriberLastRecoveredMap = new ConcurrentHashMap<String, LastRecovered>();
    private Set<String> pendingCompletion = new HashSet<String>();
    public static final String PROPERTY_SEQUENCE_ID_CACHE_SIZE = "com.bes.mq.store.jdbc.SEQUENCE_ID_CACHE_SIZE";
    private static final int SEQUENCE_ID_CACHE_SIZE = Integer.parseInt(System.getProperty("com.bes.mq.store.jdbc.SEQUENCE_ID_CACHE_SIZE", "1000"), 10);
    private final ReentrantReadWriteLock sequenceIdCacheSizeLock = new ReentrantReadWriteLock();
    private Map<MessageId, long[]> sequenceIdCache = new LinkedHashMap<MessageId, long[]>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<MessageId, long[]> eldest) {
            return this.size() > SEQUENCE_ID_CACHE_SIZE;
        }
    };

    public JDBCTopicMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, ProtocolFormat protocolFormat, BESMQTopic topic, BESMQMessageAudit audit) throws IOException {
        super(persistenceAdapter, adapter, protocolFormat, topic, audit);
    }

    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
        if (ack != null && ack.isUnmatchedAck()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ignoring unmatched selector ack for: " + messageId + ", cleanup will get to this message after subsequent acks.");
            }
            return;
        }
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            block8: {
                try {
                    long[] res = this.getCachedStoreSequenceId(c, this.destination, messageId);
                    if (this.isPrioritizedMessages()) {
                        this.adapter.doSetLastAckWithPriority(c, this.destination, context != null ? context.getXid() : null, clientId, subscriptionName, res[0], res[1]);
                    } else {
                        this.adapter.doSetLastAck(c, this.destination, context != null ? context.getXid() : null, clientId, subscriptionName, res[0], res[1]);
                    }
                    if (!LOG.isTraceEnabled()) break block8;
                    LOG.trace(clientId + ":" + subscriptionName + " ack, seq: " + res[0] + ", priority: " + res[1] + " mid:" + messageId);
                }
                catch (SQLException e) {
                    JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                    throw IOExceptionSupport.create("Failed to store acknowledgment for: " + clientId + " on message " + messageId + " in container: " + e, e);
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getCachedStoreSequenceId(TransactionContext transactionContext, BESMQDestination destination, MessageId messageId) throws SQLException, IOException {
        long[] val = null;
        this.sequenceIdCacheSizeLock.readLock().lock();
        try {
            val = this.sequenceIdCache.get(messageId);
            Object var6_5 = null;
            this.sequenceIdCacheSizeLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.sequenceIdCacheSizeLock.readLock().unlock();
            throw throwable;
        }
        if (val == null) {
            val = this.adapter.getStoreSequenceId(transactionContext, destination, messageId);
        }
        return val;
    }

    public void recoverSubscription(String clientId, String subscriptionName, final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            try {
                this.adapter.doRecoverSubscription(c, this.destination, clientId, subscriptionName, new JDBCMessageRecoveryListener(){

                    public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
                        Message msg = (Message)JDBCTopicMessageStore.this.protocolFormat.unmarshal(new ByteSequence(data));
                        msg.getMessageId().setBrokerSequenceId(sequenceId);
                        return listener.recoverMessage(msg);
                    }

                    public boolean recoverMessageReference(String reference) throws Exception {
                        return listener.recoverMessageReference(new MessageId(reference));
                    }
                });
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to recover subscription: " + clientId + ". Reason: " + e, e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void recoverNextMessages(String clientId, String subscriptionName, int maxReturned, MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        if (!this.subscriberLastRecoveredMap.containsKey(key)) {
            this.subscriberLastRecoveredMap.put(key, new LastRecovered());
        }
        LastRecovered lastRecovered = this.subscriberLastRecoveredMap.get(key);
        LastRecoveredAwareListener recoveredAwareListener = new LastRecoveredAwareListener(listener, maxReturned);
        try {
            block9: {
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(this + ", " + key + " existing last recovered: " + lastRecovered);
                    }
                    if (!this.isPrioritizedMessages()) {
                        LastRecoveredEntry last = lastRecovered.defaultPriority();
                        recoveredAwareListener.setLastRecovered(last);
                        this.adapter.doRecoverNextMessages(c, this.destination, clientId, subscriptionName, last.recovered, 0L, maxReturned, recoveredAwareListener);
                    } else {
                        Iterator<LastRecoveredEntry> it = lastRecovered.iterator();
                        while (it.hasNext() && !recoveredAwareListener.complete()) {
                            LastRecoveredEntry entry = it.next();
                            recoveredAwareListener.setLastRecovered(entry);
                            this.adapter.doRecoverNextMessagesWithPriority(c, this.destination, clientId, subscriptionName, entry.recovered, entry.priority, maxReturned, recoveredAwareListener);
                            if (!recoveredAwareListener.stalled()) continue;
                            if (recoveredAwareListener.complete()) break;
                            entry.exhausted();
                        }
                    }
                    if (!LOG.isTraceEnabled()) break block9;
                    LOG.trace(key + " last recovered: " + lastRecovered);
                }
                catch (SQLException e) {
                    JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                    Object var12_14 = null;
                    c.close();
                    return;
                }
            }
            Object var12_13 = null;
            c.close();
            return;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            c.close();
            throw throwable;
        }
    }

    public void resetBatching(String clientId, String subscriptionName) {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        if (!this.pendingCompletion.contains(key)) {
            this.subscriberLastRecoveredMap.remove(key);
        } else {
            LOG.trace(this + ", skip resetBatch during pending completion for: " + key);
        }
    }

    public void pendingCompletion(String clientId, String subscriptionName, long sequenceId, byte priority) {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        LastRecovered recovered = new LastRecovered();
        recovered.perPriority[this.isPrioritizedMessages() ? priority : 4].recovered = sequenceId;
        this.subscriberLastRecoveredMap.put(key, recovered);
        this.pendingCompletion.add(key);
        LOG.trace(this + ", pending completion: " + key + ", last: " + recovered);
    }

    public void complete(String clientId, String subscriptionName) {
        this.pendingCompletion.remove(this.getSubscriptionKey(clientId, subscriptionName));
        LOG.trace(this + ", completion for: " + this.getSubscriptionKey(clientId, subscriptionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAdd(MessageId messageId, long sequenceId, byte priority) {
        for (LastRecovered last : this.subscriberLastRecoveredMap.values()) {
            last.updateStored(sequenceId, priority);
        }
        this.sequenceIdCacheSizeLock.writeLock().lock();
        try {
            this.sequenceIdCache.put(messageId, new long[]{sequenceId, priority});
            Object var8_6 = null;
            this.sequenceIdCacheSizeLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.sequenceIdCacheSizeLock.writeLock().unlock();
            throw throwable;
        }
    }

    public void addSubsciption(SubscriptionInfo subscriptionInfo, boolean retroactive) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            try {
                c = this.persistenceAdapter.getTransactionContext();
                this.adapter.doSetSubscriberEntry(c, subscriptionInfo, retroactive, this.isPrioritizedMessages());
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to lookup subscription for info: " + subscriptionInfo.getClientId() + ". Reason: " + e, e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            c.close();
            throw throwable;
        }
        c.close();
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        SubscriptionInfo subscriptionInfo;
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            subscriptionInfo = this.adapter.doGetSubscriberEntry(c, this.destination, clientId, subscriptionName);
            Object var6_6 = null;
        }
        catch (SQLException e) {
            try {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to lookup subscription for: " + clientId + ". Reason: " + e, e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                c.close();
                throw throwable;
            }
        }
        c.close();
        return subscriptionInfo;
    }

    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            try {
                this.adapter.doDeleteSubscription(c, this.destination, clientId, subscriptionName);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to remove subscription for: " + clientId + ". Reason: " + e, e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            c.close();
            this.resetBatching(clientId, subscriptionName);
            throw throwable;
        }
        c.close();
        this.resetBatching(clientId, subscriptionName);
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        SubscriptionInfo[] subscriptionInfoArray;
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            subscriptionInfoArray = this.adapter.doGetAllSubscriptions(c, this.destination);
            Object var4_4 = null;
        }
        catch (SQLException e) {
            try {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to lookup subscriptions. Reason: " + e, e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                c.close();
                throw throwable;
            }
        }
        c.close();
        return subscriptionInfoArray;
    }

    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        int result = 0;
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            try {
                result = this.adapter.doGetDurableSubscriberMessageCount(c, this.destination, clientId, subscriberName, this.isPrioritizedMessages());
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("JDBC Failure: ", e);
                throw IOExceptionSupport.create("Failed to get Message Count: " + clientId + ". Reason: " + e, e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            c.close();
            throw throwable;
        }
        c.close();
        if (LOG.isTraceEnabled()) {
            LOG.trace(clientId + ":" + subscriberName + ", messageCount: " + result);
        }
        return result;
    }

    protected String getSubscriptionKey(String clientId, String subscriberName) {
        String result = clientId + ":";
        result = result + (subscriberName != null ? subscriberName : "NOT_SET");
        return result;
    }

    class LastRecoveredAwareListener
    implements JDBCMessageRecoveryListener {
        final MessageRecoveryListener delegate;
        final int maxMessages;
        LastRecoveredEntry lastRecovered;
        int recoveredCount;
        int recoveredMarker;

        public LastRecoveredAwareListener(MessageRecoveryListener delegate, int maxMessages) {
            this.delegate = delegate;
            this.maxMessages = maxMessages;
        }

        public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
            if (this.delegate.hasSpace() && this.recoveredCount < this.maxMessages) {
                Message msg = (Message)JDBCTopicMessageStore.this.protocolFormat.unmarshal(new ByteSequence(data));
                msg.getMessageId().setBrokerSequenceId(sequenceId);
                this.lastRecovered.recovered = sequenceId;
                if (this.delegate.recoverMessage(msg)) {
                    ++this.recoveredCount;
                    return true;
                }
            }
            return false;
        }

        public boolean recoverMessageReference(String reference) throws Exception {
            return this.delegate.recoverMessageReference(new MessageId(reference));
        }

        public void setLastRecovered(LastRecoveredEntry lastRecovered) {
            this.lastRecovered = lastRecovered;
            this.recoveredMarker = this.recoveredCount;
        }

        public boolean complete() {
            return !this.delegate.hasSpace() || this.recoveredCount == this.maxMessages;
        }

        public boolean stalled() {
            return this.recoveredMarker == this.recoveredCount;
        }
    }

    private class LastRecoveredEntry {
        final int priority;
        long recovered = 0L;
        long stored = Integer.MAX_VALUE;

        public LastRecoveredEntry(int priority) {
            this.priority = priority;
        }

        public String toString() {
            return this.priority + "-" + this.stored + ":" + this.recovered;
        }

        public void exhausted() {
            this.stored = this.recovered;
        }

        public boolean hasMessages() {
            return this.stored > this.recovered;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastRecovered
    implements Iterable<LastRecoveredEntry> {
        LastRecoveredEntry[] perPriority = new LastRecoveredEntry[10];

        LastRecovered() {
            for (int i = 0; i < this.perPriority.length; ++i) {
                this.perPriority[i] = new LastRecoveredEntry(i);
            }
        }

        public void updateStored(long sequence, int priority) {
            this.perPriority[priority].stored = sequence;
        }

        public LastRecoveredEntry defaultPriority() {
            return this.perPriority[4];
        }

        public String toString() {
            return Arrays.deepToString(this.perPriority);
        }

        @Override
        public Iterator<LastRecoveredEntry> iterator() {
            return new PriorityIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PriorityIterator
        implements Iterator<LastRecoveredEntry> {
            int current = 9;

            PriorityIterator() {
            }

            @Override
            public boolean hasNext() {
                for (int i = this.current; i >= 0; --i) {
                    if (!LastRecovered.this.perPriority[i].hasMessages()) continue;
                    this.current = i;
                    return true;
                }
                return false;
            }

            @Override
            public LastRecoveredEntry next() {
                return LastRecovered.this.perPriority[this.current];
            }

            @Override
            public void remove() {
                throw new RuntimeException("Not implemented");
            }
        }
    }
}

