/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.jdbc;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.XATransactionId;
import com.bes.mq.store.MessageStore;
import com.bes.mq.store.ProxyTopicMessageStore;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.TransactionRecoveryListener;
import com.bes.mq.store.jdbc.JDBCMessageStore;
import com.bes.mq.store.jdbc.JDBCPersistenceAdapter;
import com.bes.mq.store.jdbc.JDBCTopicMessageStore;
import com.bes.mq.store.memory.MemoryTransactionStore;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.DataByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class JdbcMemoryTransactionStore
extends MemoryTransactionStore {
    private HashMap<BESMQDestination, MessageStore> topicStores = new HashMap();

    public JdbcMemoryTransactionStore(JDBCPersistenceAdapter jdbcPersistenceAdapter) {
        super(jdbcPersistenceAdapter);
    }

    public void prepare(TransactionId txid) throws IOException {
        MemoryTransactionStore.Tx tx = (MemoryTransactionStore.Tx)this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        ConnectionContext ctx = new ConnectionContext();
        ctx.setXid((XATransactionId)txid);
        this.persistenceAdapter.beginTransaction(ctx);
        try {
            for (MemoryTransactionStore.AddMessageCommand addMessageCommand : tx.messages) {
                addMessageCommand.run(ctx);
            }
            for (MemoryTransactionStore.RemoveMessageCommand removeMessageCommand : tx.acks) {
                removeMessageCommand.run(ctx);
            }
        }
        catch (IOException e) {
            this.persistenceAdapter.rollbackTransaction(ctx);
            throw e;
        }
        this.persistenceAdapter.commitTransaction(ctx);
        ctx.setXid(null);
        ArrayList<1> updateFromPreparedStateCommands = new ArrayList<1>();
        for (final MemoryTransactionStore.AddMessageCommand addMessageCommand : tx.messages) {
            updateFromPreparedStateCommands.add(new MemoryTransactionStore.AddMessageCommand(){

                public Message getMessage() {
                    return addMessageCommand.getMessage();
                }

                public MessageStore getMessageStore() {
                    return addMessageCommand.getMessageStore();
                }

                public void run(ConnectionContext context) throws IOException {
                    JDBCPersistenceAdapter jdbcPersistenceAdapter = (JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter;
                    Message message = addMessageCommand.getMessage();
                    jdbcPersistenceAdapter.commitAdd(context, message.getMessageId());
                    ((JDBCMessageStore)addMessageCommand.getMessageStore()).onAdd(message.getMessageId(), (Long)message.getMessageId().getDataLocator(), message.getPriority());
                }
            });
        }
        tx.messages = updateFromPreparedStateCommands;
        this.preparedTransactions.put(txid, tx);
    }

    public void rollback(TransactionId txid) throws IOException {
        MemoryTransactionStore.Tx tx = (MemoryTransactionStore.Tx)this.inflightTransactions.remove(txid);
        if (tx == null && (tx = (MemoryTransactionStore.Tx)this.preparedTransactions.remove(txid)) != null) {
            ConnectionContext ctx = new ConnectionContext();
            this.persistenceAdapter.beginTransaction(ctx);
            try {
                Iterator<Object> iter = tx.messages.iterator();
                while (iter.hasNext()) {
                    Message message = iter.next().getMessage();
                    ((JDBCPersistenceAdapter)this.persistenceAdapter).commitRemove(ctx, new MessageAck(message, 2, 1));
                }
                for (MemoryTransactionStore.RemoveMessageCommand removeMessageCommand : tx.acks) {
                    if (removeMessageCommand instanceof LastAckCommand) {
                        ((LastAckCommand)removeMessageCommand).rollback(ctx);
                        continue;
                    }
                    ((JDBCPersistenceAdapter)this.persistenceAdapter).commitAdd(ctx, removeMessageCommand.getMessageAck().getLastMessageId());
                }
            }
            catch (IOException e) {
                this.persistenceAdapter.rollbackTransaction(ctx);
                throw e;
            }
            this.persistenceAdapter.commitTransaction(ctx);
        }
    }

    public void recover(TransactionRecoveryListener listener) throws IOException {
        ((JDBCPersistenceAdapter)this.persistenceAdapter).recover(this);
        super.recover(listener);
    }

    public void recoverAdd(long id, byte[] messageBytes) throws IOException {
        final Message message = (Message)((JDBCPersistenceAdapter)this.persistenceAdapter).getProtocolFormat().unmarshal(new ByteSequence(messageBytes));
        message.getMessageId().setDataLocator(id);
        MemoryTransactionStore.Tx tx = this.getPreparedTx(message.getTransactionId());
        tx.add(new MemoryTransactionStore.AddMessageCommand(){

            public Message getMessage() {
                return message;
            }

            public MessageStore getMessageStore() {
                return null;
            }

            public void run(ConnectionContext context) throws IOException {
                ((JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter).commitAdd(null, message.getMessageId());
            }
        });
    }

    public void recoverAck(long id, byte[] xid, byte[] message) throws IOException {
        Message msg = (Message)((JDBCPersistenceAdapter)this.persistenceAdapter).getProtocolFormat().unmarshal(new ByteSequence(message));
        msg.getMessageId().setDataLocator(id);
        MemoryTransactionStore.Tx tx = this.getPreparedTx(new XATransactionId(xid));
        final MessageAck ack = new MessageAck(msg, 2, 1);
        tx.add(new MemoryTransactionStore.RemoveMessageCommand(){

            public MessageAck getMessageAck() {
                return ack;
            }

            public void run(ConnectionContext context) throws IOException {
                ((JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter).commitRemove(context, ack);
            }

            public MessageStore getMessageStore() {
                return null;
            }
        });
    }

    public void recoverLastAck(byte[] encodedXid, final BESMQDestination destination, final String subName, final String clientId) throws IOException {
        MemoryTransactionStore.Tx tx = this.getPreparedTx(new XATransactionId(encodedXid));
        DataByteArrayInputStream inputStream = new DataByteArrayInputStream(encodedXid);
        inputStream.skipBytes(1);
        final long lastAck = inputStream.readLong();
        final byte priority = inputStream.readByte();
        final MessageAck ack = new MessageAck();
        ack.setDestination(destination);
        tx.add(new LastAckCommand(){
            JDBCTopicMessageStore jdbcTopicMessageStore;

            public MessageAck getMessageAck() {
                return ack;
            }

            public MessageStore getMessageStore() {
                return this.jdbcTopicMessageStore;
            }

            public void run(ConnectionContext context) throws IOException {
                ((JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter).commitLastAck(context, lastAck, priority, destination, subName, clientId);
                this.jdbcTopicMessageStore.complete(clientId, subName);
            }

            public void rollback(ConnectionContext context) throws IOException {
                ((JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter).rollbackLastAck(context, priority, this.jdbcTopicMessageStore.getDestination(), subName, clientId);
                this.jdbcTopicMessageStore.complete(clientId, subName);
            }

            public String getClientId() {
                return clientId;
            }

            public String getSubName() {
                return subName;
            }

            public long getSequence() {
                return lastAck;
            }

            public byte getPriority() {
                return priority;
            }

            public void setMessageStore(JDBCTopicMessageStore jdbcTopicMessageStore) {
                this.jdbcTopicMessageStore = jdbcTopicMessageStore;
            }
        });
    }

    protected void onProxyTopicStore(ProxyTopicMessageStore proxyTopicMessageStore) {
        this.topicStores.put(proxyTopicMessageStore.getDestination(), proxyTopicMessageStore.getDelegate());
    }

    protected void onRecovered(MemoryTransactionStore.Tx tx) {
        for (MemoryTransactionStore.RemoveMessageCommand removeMessageCommand : tx.acks) {
            if (removeMessageCommand instanceof LastAckCommand) {
                LastAckCommand lastAckCommand = (LastAckCommand)removeMessageCommand;
                JDBCTopicMessageStore jdbcTopicMessageStore = (JDBCTopicMessageStore)this.topicStores.get(lastAckCommand.getMessageAck().getDestination());
                jdbcTopicMessageStore.pendingCompletion(lastAckCommand.getClientId(), lastAckCommand.getSubName(), lastAckCommand.getSequence(), lastAckCommand.getPriority());
                lastAckCommand.setMessageStore(jdbcTopicMessageStore);
                continue;
            }
            ((JDBCPersistenceAdapter)this.persistenceAdapter).getBrokerService().getRegionBroker().getDestinationMap().get(removeMessageCommand.getMessageAck().getDestination()).getDestinationStatistics().getMessages().increment();
        }
    }

    public void acknowledge(final TopicMessageStore topicMessageStore, final String clientId, final String subscriptionName, final MessageId messageId, final MessageAck ack) throws IOException {
        if (ack.isInTransaction()) {
            MemoryTransactionStore.Tx tx = this.getTx(ack.getTransactionId());
            tx.add(new LastAckCommand(){

                public MessageAck getMessageAck() {
                    return ack;
                }

                public void run(ConnectionContext ctx) throws IOException {
                    topicMessageStore.acknowledge(ctx, clientId, subscriptionName, messageId, ack);
                }

                public MessageStore getMessageStore() {
                    return topicMessageStore;
                }

                public void rollback(ConnectionContext context) throws IOException {
                    JDBCTopicMessageStore jdbcTopicMessageStore = (JDBCTopicMessageStore)topicMessageStore;
                    ((JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter).rollbackLastAck(context, jdbcTopicMessageStore, ack, subscriptionName, clientId);
                    jdbcTopicMessageStore.complete(clientId, subscriptionName);
                }

                public String getClientId() {
                    return clientId;
                }

                public String getSubName() {
                    return subscriptionName;
                }

                public long getSequence() {
                    throw new IllegalStateException("Sequence id must be inferred from ack");
                }

                public byte getPriority() {
                    throw new IllegalStateException("Priority must be inferred from ack or row");
                }

                public void setMessageStore(JDBCTopicMessageStore jdbcTopicMessageStore) {
                    throw new IllegalStateException("Message store already known!");
                }
            });
        } else {
            topicMessageStore.acknowledge(null, clientId, subscriptionName, messageId, ack);
        }
    }

    static interface LastAckCommand
    extends MemoryTransactionStore.RemoveMessageCommand {
        public void rollback(ConnectionContext var1) throws IOException;

        public String getClientId();

        public String getSubName();

        public long getSequence();

        public byte getPriority();

        public void setMessageStore(JDBCTopicMessageStore var1);
    }
}

