/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.jdbc;

import com.bes.mq.broker.AbstractLocker;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.jdbc.JDBCPersistenceAdapter;
import com.bes.mq.store.jdbc.Statements;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.ServiceStopper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class LeaseDatabaseLocker
extends AbstractLocker {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseDatabaseLocker.class);
    public static final long DEFAULT_LOCK_ACQUIRE_SLEEP_INTERVAL = 5000L;
    protected DataSource dataSource;
    protected Statements statements;
    protected boolean stopping;
    protected int maxAllowableDiffFromDBTime = 0;
    protected long diffFromCurrentTime = Long.MAX_VALUE;
    protected String leaseHolderId;
    protected int queryTimeout = -1;
    JDBCPersistenceAdapter persistenceAdapter;

    public void configure(PersistenceAdapter adapter) throws IOException {
        if (adapter instanceof JDBCPersistenceAdapter) {
            this.persistenceAdapter = (JDBCPersistenceAdapter)adapter;
            this.dataSource = ((JDBCPersistenceAdapter)adapter).getLockDataSource();
            this.statements = ((JDBCPersistenceAdapter)adapter).getStatements();
        }
        this.lockAcquireSleepInterval = 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        this.stopping = false;
        LOG.info(this.getLeaseHolderId() + " attempting to acquire exclusive lease to become the Master broker");
        String sql = this.statements.getLeaseObtainStatement();
        LOG.debug(this.getLeaseHolderId() + " locking Query is " + sql);
        while (!this.stopping) {
            block9: {
                Connection connection = null;
                PreparedStatement statement = null;
                try {
                    connection = this.getConnection();
                    this.initTimeDiff(connection);
                    statement = connection.prepareStatement(sql);
                    this.setQueryTimeout(statement);
                    long now = System.currentTimeMillis() + this.diffFromCurrentTime;
                    statement.setString(1, this.getLeaseHolderId());
                    statement.setLong(2, now + this.lockAcquireSleepInterval);
                    statement.setLong(3, now);
                    int result = statement.executeUpdate();
                    if (result == 1 && this.keepAlive()) {
                        this.close(statement);
                        this.close(connection);
                        break;
                    }
                    this.reportLeasOwnerShipAndDuration(connection);
                    this.close(statement);
                }
                catch (Exception e) {
                    this.lockAcquireFailed(e);
                    break block9;
                }
                finally {
                    this.close(statement);
                    this.close(connection);
                }
                this.close(connection);
            }
            TimeUnit.MILLISECONDS.sleep(this.lockAcquireSleepInterval);
        }
        if (this.stopping) {
            throw new RuntimeException(this.getLeaseHolderId() + " failing to acquire lease due to stop");
        }
        LOG.info(this.getLeaseHolderId() + ", becoming the master broker");
    }

    private void setQueryTimeout(PreparedStatement statement) throws SQLException {
        if (this.queryTimeout > 0) {
            statement.setQueryTimeout(this.queryTimeout);
        }
    }

    private Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    private void close(Connection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (SQLException e1) {
                LOG.debug(this.getLeaseHolderId() + " caught exception while closing connection: " + e1, e1);
            }
        }
    }

    private void close(PreparedStatement statement) {
        if (null != statement) {
            try {
                statement.close();
            }
            catch (SQLException e1) {
                LOG.debug(this.getLeaseHolderId() + ", caught while closing statement: " + e1, e1);
            }
        }
    }

    private void close(ResultSet resultSet) {
        if (null != resultSet) {
            try {
                resultSet.close();
            }
            catch (SQLException e1) {
                LOG.debug(this.getLeaseHolderId() + ", caught while closing resultSet: " + e1, e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportLeasOwnerShipAndDuration(Connection connection) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(this.statements.getLeaseOwnerStatement());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                LOG.info(this.getLeaseHolderId() + " Lease held by " + resultSet.getString(1) + " till " + new Date(resultSet.getLong(2)));
            }
            this.close(resultSet);
            this.close(statement);
        }
        catch (Throwable throwable) {
            this.close(resultSet);
            this.close(statement);
            throw throwable;
        }
    }

    protected long initTimeDiff(Connection connection) throws SQLException {
        if (Long.MAX_VALUE == this.diffFromCurrentTime) {
            this.diffFromCurrentTime = this.maxAllowableDiffFromDBTime > 0 ? this.determineTimeDifference(connection) : 0L;
        }
        return this.diffFromCurrentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long determineTimeDifference(Connection connection) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        long result = 0L;
        try {
            statement = connection.prepareStatement(this.statements.getCurrentDateTime());
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                Timestamp timestamp = resultSet.getTimestamp(1);
                long diff = System.currentTimeMillis() - timestamp.getTime();
                LOG.info(this.getLeaseHolderId() + " diff from db: " + diff + ", db time: " + timestamp);
                if (diff > (long)this.maxAllowableDiffFromDBTime || diff < (long)(-this.maxAllowableDiffFromDBTime)) {
                    result = diff;
                }
            }
            this.close(resultSet);
            this.close(statement);
        }
        catch (Throwable throwable) {
            this.close(resultSet);
            this.close(statement);
            throw throwable;
        }
        return result;
    }

    public void doStop(ServiceStopper stopper) throws Exception {
        this.releaseLease();
        this.stopping = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLease() {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.statements.getLeaseUpdateStatement());
            statement.setString(1, null);
            statement.setLong(2, 0L);
            statement.setString(3, this.getLeaseHolderId());
            if (statement.executeUpdate() == 1) {
                LOG.info(this.getLeaseHolderId() + ", released lease");
            }
            this.close(statement);
            this.close(connection);
        }
        catch (Exception e) {
            try {
                LOG.error(this.getLeaseHolderId() + " failed to release lease: " + e, e);
                this.close(statement);
                this.close(connection);
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(connection);
                throw throwable;
            }
        }
    }

    public boolean keepAlive() throws IOException {
        boolean result = false;
        String sql = this.statements.getLeaseUpdateStatement();
        LOG.debug(this.getLeaseHolderId() + ", lease keepAlive Query is " + sql);
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            this.initTimeDiff(connection);
            statement = connection.prepareStatement(sql);
            this.setQueryTimeout(statement);
            long now = System.currentTimeMillis() + this.diffFromCurrentTime;
            statement.setString(1, this.getLeaseHolderId());
            statement.setLong(2, now + this.lockAcquireSleepInterval);
            statement.setString(3, this.getLeaseHolderId());
            result = statement.executeUpdate() == 1;
            this.close(statement);
            this.close(connection);
        }
        catch (Exception e) {
            try {
                LOG.warn(this.getLeaseHolderId() + ", failed to update lease: " + e, e);
                IOException ioe = IOExceptionSupport.create(e);
                this.persistenceAdapter.getBrokerService().handleIOException(ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(connection);
                throw throwable;
            }
        }
        return result;
    }

    public long getLockAcquireSleepInterval() {
        return this.lockAcquireSleepInterval;
    }

    public void setLockAcquireSleepInterval(long lockAcquireSleepInterval) {
        this.lockAcquireSleepInterval = lockAcquireSleepInterval;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public String getLeaseHolderId() {
        if (this.leaseHolderId == null && this.persistenceAdapter.getBrokerService() != null) {
            this.leaseHolderId = this.persistenceAdapter.getBrokerService().getBrokerName();
        }
        return this.leaseHolderId;
    }

    public void setLeaseHolderId(String leaseHolderId) {
        this.leaseHolderId = leaseHolderId;
    }

    public int getMaxAllowableDiffFromDBTime() {
        return this.maxAllowableDiffFromDBTime;
    }

    public void setMaxAllowableDiffFromDBTime(int maxAllowableDiffFromDBTime) {
        this.maxAllowableDiffFromDBTime = maxAllowableDiffFromDBTime;
    }

    protected Logger getLogger() {
        return LOG;
    }
}

