/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.memory;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.store.AbstractMessageStore;
import com.bes.mq.store.MessageRecoveryListener;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryMessageStore
extends AbstractMessageStore {
    protected final Map<MessageId, Message> messageTable;
    protected MessageId lastBatchId;

    public MemoryMessageStore(BESMQDestination destination) {
        this(destination, new LinkedHashMap<MessageId, Message>());
    }

    public MemoryMessageStore(BESMQDestination destination, Map<MessageId, Message> messageTable) {
        super(destination);
        this.messageTable = Collections.synchronizedMap(messageTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        Map<MessageId, Message> map = this.messageTable;
        synchronized (map) {
            this.messageTable.put(message.getMessageId(), message);
        }
        message.incrementReferenceCount();
    }

    @Override
    public Message getMessage(MessageId identity) throws IOException {
        return this.messageTable.get(identity);
    }

    @Override
    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.removeMessage(ack.getLastMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(MessageId msgId) throws IOException {
        Map<MessageId, Message> map = this.messageTable;
        synchronized (map) {
            Message removed = this.messageTable.remove(msgId);
            if (removed != null) {
                removed.decrementReferenceCount();
            }
            if (this.lastBatchId != null && this.lastBatchId.equals(msgId) || this.messageTable.isEmpty()) {
                this.lastBatchId = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(MessageRecoveryListener listener) throws Exception {
        Map<MessageId, Message> map = this.messageTable;
        synchronized (map) {
            for (Message msg : this.messageTable.values()) {
                if (msg.getClass() == MessageId.class) {
                    listener.recoverMessageReference((MessageId)((Object)msg));
                    continue;
                }
                listener.recoverMessage(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMessages(ConnectionContext context) throws IOException {
        Map<MessageId, Message> map = this.messageTable;
        synchronized (map) {
            this.messageTable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Map<MessageId, Message> map = this.messageTable;
        synchronized (map) {
            this.messageTable.clear();
        }
    }

    @Override
    public int getMessageCount() {
        return this.messageTable.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverNextMessages(int maxReturned, MessageRecoveryListener listener) throws Exception {
        Map<MessageId, Message> map = this.messageTable;
        synchronized (map) {
            boolean pastLackBatch = this.lastBatchId == null;
            int count = 0;
            for (Map.Entry<MessageId, Message> entry : this.messageTable.entrySet()) {
                if (pastLackBatch) {
                    ++count;
                    Message msg = entry.getValue();
                    this.lastBatchId = entry.getKey();
                    if (msg.getClass() == MessageId.class) {
                        listener.recoverMessageReference((MessageId)((Object)msg));
                        continue;
                    }
                    listener.recoverMessage(msg);
                    continue;
                }
                pastLackBatch = ((Object)entry.getKey()).equals(this.lastBatchId);
            }
        }
    }

    @Override
    public void resetBatching() {
        this.lastBatchId = null;
    }

    @Override
    public void setBatch(MessageId messageId) {
        this.lastBatchId = messageId;
    }
}

