/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.memory;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.ProducerId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.MessageStore;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.ProxyMessageStore;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.TransactionStore;
import com.bes.mq.store.memory.MemoryMessageStore;
import com.bes.mq.store.memory.MemoryTopicMessageStore;
import com.bes.mq.store.memory.MemoryTransactionStore;
import com.bes.mq.usage.SystemUsage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryPersistenceAdapter
implements PersistenceAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryPersistenceAdapter.class);
    MemoryTransactionStore transactionStore;
    ConcurrentHashMap<BESMQDestination, TopicMessageStore> topics = new ConcurrentHashMap();
    ConcurrentHashMap<BESMQDestination, MessageStore> queues = new ConcurrentHashMap();
    private boolean useExternalMessageReferences;

    @Override
    public Set<BESMQDestination> getDestinations() {
        HashSet<BESMQDestination> rc = new HashSet<BESMQDestination>(this.queues.size() + this.topics.size());
        Iterator iter = this.queues.keySet().iterator();
        while (iter.hasNext()) {
            rc.add((BESMQDestination)iter.next());
        }
        iter = this.topics.keySet().iterator();
        while (iter.hasNext()) {
            rc.add((BESMQDestination)iter.next());
        }
        return rc;
    }

    public static MemoryPersistenceAdapter newInstance(File file) {
        return new MemoryPersistenceAdapter();
    }

    @Override
    public MessageStore createQueueMessageStore(BESMQQueue destination) throws IOException {
        MessageStore rc = this.queues.get(destination);
        if (rc == null) {
            rc = new MemoryMessageStore(destination);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.queues.put(destination, rc);
        }
        return rc;
    }

    @Override
    public TopicMessageStore createTopicMessageStore(BESMQTopic destination) throws IOException {
        TopicMessageStore rc = this.topics.get(destination);
        if (rc == null) {
            rc = new MemoryTopicMessageStore(destination);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.topics.put(destination, rc);
        }
        return rc;
    }

    @Override
    public void removeQueueMessageStore(BESMQQueue destination) {
        this.queues.remove(destination);
    }

    @Override
    public void removeTopicMessageStore(BESMQTopic destination) {
        this.topics.remove(destination);
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            this.transactionStore = new MemoryTransactionStore(this);
        }
        return this.transactionStore;
    }

    @Override
    public void beginTransaction(ConnectionContext context) {
    }

    @Override
    public void commitTransaction(ConnectionContext context) {
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return 0L;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        MemoryMessageStore store;
        Iterator<MessageStore> iter = this.topics.values().iterator();
        while (iter.hasNext()) {
            store = this.asMemoryMessageStore(iter.next());
            if (store == null) continue;
            store.delete();
        }
        iter = this.queues.values().iterator();
        while (iter.hasNext()) {
            store = this.asMemoryMessageStore(iter.next());
            if (store == null) continue;
            store.delete();
        }
        if (this.transactionStore != null) {
            this.transactionStore.delete();
        }
    }

    public boolean isUseExternalMessageReferences() {
        return this.useExternalMessageReferences;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.useExternalMessageReferences = useExternalMessageReferences;
    }

    protected MemoryMessageStore asMemoryMessageStore(Object value) {
        MessageStore delegate;
        if (value instanceof MemoryMessageStore) {
            return (MemoryMessageStore)value;
        }
        if (value instanceof ProxyMessageStore && (delegate = ((ProxyMessageStore)value).getDelegate()) instanceof MemoryMessageStore) {
            return (MemoryMessageStore)delegate;
        }
        LOG.warn("Expected an instance of MemoryMessageStore but was: " + value);
        return null;
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
    }

    public String toString() {
        return "MemoryPersistenceAdapter";
    }

    @Override
    public void setBrokerName(String brokerName) {
    }

    @Override
    public void setDirectory(File dir) {
    }

    @Override
    public File getDirectory() {
        return null;
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
    }

    @Override
    public long size() {
        return 0L;
    }

    public void setCreateTransactionStore(boolean create) throws IOException {
        if (create) {
            this.createTransactionStore();
        }
    }

    @Override
    public long getLastProducerSequenceId(ProducerId id) {
        return -1L;
    }
}

