/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.store.memory;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.SubscriptionInfo;
import com.bes.mq.store.MessageRecoveryListener;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.memory.MemoryMessageStore;
import com.bes.mq.store.memory.MemoryTopicSub;
import com.bes.mq.util.LRUCache;
import com.bes.mq.util.SubscriptionKey;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryTopicMessageStore
extends MemoryMessageStore
implements TopicMessageStore {
    private Map<SubscriptionKey, SubscriptionInfo> subscriberDatabase;
    private Map<SubscriptionKey, MemoryTopicSub> topicSubMap;

    public MemoryTopicMessageStore(BESMQDestination destination) {
        this(destination, new LRUCache<MessageId, Message>(100, 100, 0.75f, false), MemoryTopicMessageStore.makeSubscriptionInfoMap());
    }

    public MemoryTopicMessageStore(BESMQDestination destination, Map<MessageId, Message> messageTable, Map<SubscriptionKey, SubscriptionInfo> subscriberDatabase) {
        super(destination, messageTable);
        this.subscriberDatabase = subscriberDatabase;
        this.topicSubMap = MemoryTopicMessageStore.makeSubMap();
    }

    protected static Map<SubscriptionKey, SubscriptionInfo> makeSubscriptionInfoMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    protected static Map<SubscriptionKey, MemoryTopicSub> makeSubMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    @Override
    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        super.addMessage(context, message);
        for (MemoryTopicSub sub : this.topicSubMap.values()) {
            sub.addMessage(message.getMessageId(), message);
        }
    }

    @Override
    public synchronized void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
        Message message;
        SubscriptionKey key = new SubscriptionKey(clientId, subscriptionName);
        MemoryTopicSub sub = this.topicSubMap.get(key);
        if (sub != null) {
            sub.removeMessage(messageId);
        }
        if ((message = (Message)this.messageTable.get(messageId)) != null && message.isExpired()) {
            this.messageTable.remove(messageId);
        }
    }

    @Override
    public synchronized SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return this.subscriberDatabase.get(new SubscriptionKey(clientId, subscriptionName));
    }

    @Override
    public synchronized void addSubsciption(SubscriptionInfo info, boolean retroactive) throws IOException {
        SubscriptionKey key = new SubscriptionKey(info);
        MemoryTopicSub sub = new MemoryTopicSub();
        this.topicSubMap.put(key, sub);
        if (retroactive) {
            for (Map.Entry entry : this.messageTable.entrySet()) {
                sub.addMessage((MessageId)entry.getKey(), (Message)entry.getValue());
            }
        }
        this.subscriberDatabase.put(key, info);
    }

    @Override
    public synchronized void deleteSubscription(String clientId, String subscriptionName) {
        SubscriptionKey key = new SubscriptionKey(clientId, subscriptionName);
        this.subscriberDatabase.remove(key);
        this.topicSubMap.remove(key);
    }

    @Override
    public synchronized void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Exception {
        MemoryTopicSub sub = this.topicSubMap.get(new SubscriptionKey(clientId, subscriptionName));
        if (sub != null) {
            sub.recoverSubscription(listener);
        }
    }

    @Override
    public synchronized void delete() {
        super.delete();
        this.subscriberDatabase.clear();
        this.topicSubMap.clear();
    }

    @Override
    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        return this.subscriberDatabase.values().toArray(new SubscriptionInfo[this.subscriberDatabase.size()]);
    }

    @Override
    public synchronized int getMessageCount(String clientId, String subscriberName) throws IOException {
        int result = 0;
        MemoryTopicSub sub = this.topicSubMap.get(new SubscriptionKey(clientId, subscriberName));
        if (sub != null) {
            result = sub.size();
        }
        return result;
    }

    @Override
    public synchronized void recoverNextMessages(String clientId, String subscriptionName, int maxReturned, MessageRecoveryListener listener) throws Exception {
        MemoryTopicSub sub = this.topicSubMap.get(new SubscriptionKey(clientId, subscriptionName));
        if (sub != null) {
            sub.recoverNextMessages(maxReturned, listener);
        }
    }

    @Override
    public void resetBatching(String clientId, String subscriptionName) {
        MemoryTopicSub sub = this.topicSubMap.get(new SubscriptionKey(clientId, subscriptionName));
        if (sub != null) {
            sub.resetBatching();
        }
    }
}

