/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.thread;

import com.bes.mq.thread.Task;
import com.bes.mq.thread.TaskRunner;
import java.util.concurrent.Executor;

public class DeterministicTaskRunner
implements TaskRunner {
    private final Executor executor;
    private final Task task;
    private final Runnable runable;
    private boolean shutdown;

    public DeterministicTaskRunner(Executor executor, Task task) {
        this.executor = executor;
        this.task = task;
        this.runable = new Runnable(){

            public void run() {
                Thread.currentThread();
                DeterministicTaskRunner.this.runTask();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() throws InterruptedException {
        Runnable runnable = this.runable;
        synchronized (runnable) {
            if (this.shutdown) {
                return;
            }
            this.executor.execute(this.runable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(long timeout) throws InterruptedException {
        Runnable runnable = this.runable;
        synchronized (runnable) {
            this.shutdown = true;
        }
    }

    public void shutdown() throws InterruptedException {
        this.shutdown(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runTask() {
        Runnable runnable = this.runable;
        synchronized (runnable) {
            if (this.shutdown) {
                this.runable.notifyAll();
                return;
            }
        }
        this.task.iterate();
    }
}

