/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.thread;

import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;
import com.bes.mq.util.ThreadPoolUtils;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class Scheduler
extends ServiceSupport {
    private final String name;
    private final HashMap<Runnable, ScheduledFuture<?>> scheduledFutures = new HashMap();
    private ScheduledExecutorService service;
    private static final int DEFAULT_SCHEDULE_THREAD_NUM = Integer.getInteger("com.bes.mq.thread.schedulerThreadNum", 1);
    private static final TimeUnit DEFAULT_TIME_UINT = TimeUnit.MILLISECONDS;

    public Scheduler(String name) {
        this.name = name;
    }

    public synchronized void executePeriodically(Runnable task, long period) {
        ScheduledFuture<?> scheduledFuture = this.service.scheduleWithFixedDelay(task, period, period, DEFAULT_TIME_UINT);
        this.scheduledFutures.put(task, scheduledFuture);
    }

    public synchronized void schedualPeriodically(Runnable task, long period) {
        ScheduledFuture<?> scheduledFuture = this.service.scheduleWithFixedDelay(task, period, period, DEFAULT_TIME_UINT);
        this.scheduledFutures.put(task, scheduledFuture);
    }

    public synchronized void cancel(Runnable task) {
        ScheduledFuture<?> scheduledFuture = this.scheduledFutures.remove(task);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
    }

    public synchronized void executeAfterDelay(Runnable task, long redeliveryDelay) {
        ScheduledFuture<?> scheduledFuture = this.service.schedule(task, redeliveryDelay, DEFAULT_TIME_UINT);
        this.scheduledFutures.put(task, scheduledFuture);
    }

    public void shutdown() {
        ThreadPoolUtils.shutdown(this.service);
    }

    protected synchronized void doStart() throws Exception {
        this.service = Executors.newScheduledThreadPool(DEFAULT_SCHEDULE_THREAD_NUM, new BESMQSchedulerThreadFactory(this.name));
    }

    protected synchronized void doStop(ServiceStopper stopper) throws Exception {
        if (this.service != null) {
            this.service.shutdownNow();
        }
    }

    public String getName() {
        return this.name;
    }

    static class BESMQSchedulerThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        BESMQSchedulerThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name + " thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

