/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.tool;

import com.bes.mq.BESMQConnection;
import com.bes.mq.BESMQConnectionFactory;
import com.bes.mq.util.IndentPrinter;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;

public class ToolSupport {
    protected Destination destination;
    protected String subject = "TOOL.DEFAULT";
    protected boolean topic = true;
    protected String user = BESMQConnection.DEFAULT_USER;
    protected String pwd = BESMQConnection.DEFAULT_PASSWORD;
    protected String url = "failover://tcp://localhost:3200";
    protected boolean transacted;
    protected boolean durable;
    protected String clientID = this.getClass().getName();
    protected int ackMode = 1;
    protected String consumerName = "James";

    protected Session createSession(Connection connection) throws Exception {
        if (this.durable) {
            connection.setClientID(this.clientID);
        }
        Session session = connection.createSession(this.transacted, this.ackMode);
        this.destination = this.topic ? session.createTopic(this.subject) : session.createQueue(this.subject);
        return session;
    }

    protected Connection createConnection() throws JMSException, Exception {
        BESMQConnectionFactory connectionFactory = new BESMQConnectionFactory(this.user, this.pwd, this.url);
        return connectionFactory.createConnection();
    }

    protected void close(Connection connection, Session session) throws JMSException {
        this.dumpStats(connection);
        if (session != null) {
            session.close();
        }
        if (connection != null) {
            connection.close();
        }
    }

    protected void dumpStats(Connection connection) {
        BESMQConnection c = (BESMQConnection)connection;
        c.getConnectionStats().dump(new IndentPrinter());
    }
}

