/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport;

import com.bes.mq.command.KeepAliveInfo;
import com.bes.mq.command.ProtocolFormatInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.thread.SchedulerTimerTask;
import com.bes.mq.transport.InactivityIOException;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.util.ThreadPoolUtils;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractInactivityMonitor
extends TransportFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInactivityMonitor.class);
    private static ThreadPoolExecutor ASYNC_TASKS;
    private static int CHECKER_COUNTER;
    private static long DEFAULT_CHECK_TIME_MILLS;
    private static Timer READ_CHECK_TIMER;
    private static Timer WRITE_CHECK_TIMER;
    private final AtomicBoolean monitorStarted = new AtomicBoolean(false);
    private final AtomicBoolean commandSent = new AtomicBoolean(false);
    private final AtomicBoolean inSend = new AtomicBoolean(false);
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private final AtomicBoolean commandReceived = new AtomicBoolean(true);
    private final AtomicBoolean inReceive = new AtomicBoolean(false);
    private final AtomicInteger lastReceiveCounter = new AtomicInteger(0);
    private final ReentrantReadWriteLock sendLock = new ReentrantReadWriteLock();
    private SchedulerTimerTask writeCheckerTask;
    private SchedulerTimerTask readCheckerTask;
    private long readCheckTime = DEFAULT_CHECK_TIME_MILLS;
    private long writeCheckTime = DEFAULT_CHECK_TIME_MILLS;
    private long initialDelayTime = DEFAULT_CHECK_TIME_MILLS;
    private boolean useKeepAlive = true;
    private boolean keepAliveResponseRequired;
    protected ProtocolFormat protocolFormat;
    private final Runnable readChecker = new Runnable(){
        long lastRunTime;

        public void run() {
            long now = System.currentTimeMillis();
            long elapsed = now - this.lastRunTime;
            if (this.lastRunTime != 0L && LOG.isDebugEnabled()) {
                LOG.debug("" + elapsed + " ms elapsed since last read check.");
            }
            if (!AbstractInactivityMonitor.this.allowReadCheck(elapsed)) {
                LOG.debug("Aborting read check. Not enough time elapsed since last read check.");
                return;
            }
            this.lastRunTime = now;
            AbstractInactivityMonitor.this.readCheck();
        }

        public String toString() {
            return "ReadChecker";
        }
    };
    private final Runnable writeChecker = new Runnable(){
        long lastRunTime;

        public void run() {
            long now = System.currentTimeMillis();
            if (this.lastRunTime != 0L && LOG.isDebugEnabled()) {
                LOG.debug(this + " " + (now - this.lastRunTime) + " ms elapsed since last write check.");
            }
            this.lastRunTime = now;
            AbstractInactivityMonitor.this.writeCheck();
        }

        public String toString() {
            return "WriteChecker";
        }
    };
    private ThreadFactory factory = new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "BESMQ InactivityMonitor Worker");
            thread.setDaemon(true);
            return thread;
        }
    };

    private boolean allowReadCheck(long elapsed) {
        return elapsed > this.readCheckTime * 9L / 10L;
    }

    public AbstractInactivityMonitor(Transport next, ProtocolFormat protocolFormat) {
        super(next);
        this.protocolFormat = protocolFormat;
    }

    public void start() throws Exception {
        this.next.start();
        this.startMonitorThreads();
    }

    public void stop() throws Exception {
        this.stopMonitorThreads();
        this.next.stop();
    }

    final void writeCheck() {
        if (this.inSend.get()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("A send is in progress");
            }
            return;
        }
        if (!this.commandSent.get() && this.useKeepAlive && this.monitorStarted.get() && !ASYNC_TASKS.isTerminating()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + " no message sent since last write check, sending a KeepAliveInfo");
            }
            ASYNC_TASKS.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Running {}", this);
                    }
                    if (AbstractInactivityMonitor.this.monitorStarted.get()) {
                        try {
                            if (AbstractInactivityMonitor.this.sendLock.writeLock().tryLock()) {
                                KeepAliveInfo info = new KeepAliveInfo();
                                info.setResponseRequired(AbstractInactivityMonitor.this.keepAliveResponseRequired);
                                AbstractInactivityMonitor.this.doOnewaySend(info);
                            }
                        }
                        catch (IOException e) {
                            AbstractInactivityMonitor.this.onException(e);
                        }
                        finally {
                            if (AbstractInactivityMonitor.this.sendLock.writeLock().isHeldByCurrentThread()) {
                                AbstractInactivityMonitor.this.sendLock.writeLock().unlock();
                            }
                        }
                    }
                }

                public String toString() {
                    return "WriteCheck[" + AbstractInactivityMonitor.this.getRemoteAddress() + "]";
                }
            });
        } else if (LOG.isTraceEnabled()) {
            LOG.trace(this + " message sent since last write check, resetting flag");
        }
        this.commandSent.set(false);
    }

    final void readCheck() {
        int currentCounter = this.next.getReceiveCounter();
        int previousCounter = this.lastReceiveCounter.getAndSet(currentCounter);
        if (this.inReceive.get() || currentCounter != previousCounter) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("A receive is in progress");
            }
            return;
        }
        if (!this.commandReceived.get() && this.monitorStarted.get() && !ASYNC_TASKS.isTerminating()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No message received since last read check for " + this.toString() + ". Throwing InactivityIOException.");
            }
            ASYNC_TASKS.execute(new Runnable(){

                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Running {}", this);
                    }
                    AbstractInactivityMonitor.this.onException(new InactivityIOException("Channel was inactive for too (>" + AbstractInactivityMonitor.this.readCheckTime + ") long: " + AbstractInactivityMonitor.this.next.getRemoteAddress()));
                }

                public String toString() {
                    return "ReadCheck[" + AbstractInactivityMonitor.this.getRemoteAddress() + "]";
                }
            });
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Message received since last read check, resetting flag: ");
        }
        this.commandReceived.set(false);
    }

    protected abstract void processInboundProtocolFormatInfo(ProtocolFormatInfo var1) throws IOException;

    protected abstract void processOutboundProtocolFormatInfo(ProtocolFormatInfo var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(Object command) {
        block15: {
            this.commandReceived.set(true);
            this.inReceive.set(true);
            try {
                if (command.getClass() == KeepAliveInfo.class) {
                    KeepAliveInfo info = (KeepAliveInfo)command;
                    if (!info.isResponseRequired()) break block15;
                    this.sendLock.readLock().lock();
                    try {
                        info.setResponseRequired(false);
                        this.oneway(info);
                        break block15;
                    }
                    catch (IOException e) {
                        this.onException(e);
                        break block15;
                    }
                    finally {
                        this.sendLock.readLock().unlock();
                    }
                }
                if (command.getClass() == ProtocolFormatInfo.class) {
                    AbstractInactivityMonitor abstractInactivityMonitor = this;
                    synchronized (abstractInactivityMonitor) {
                        try {
                            this.processInboundProtocolFormatInfo((ProtocolFormatInfo)command);
                        }
                        catch (IOException e) {
                            this.onException(e);
                        }
                    }
                }
                this.transportListener.onCommand(command);
            }
            finally {
                this.inReceive.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneway(Object o) throws IOException {
        this.sendLock.readLock().lock();
        this.inSend.set(true);
        try {
            this.doOnewaySend(o);
        }
        finally {
            this.commandSent.set(true);
            this.inSend.set(false);
            this.sendLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnewaySend(Object command) throws IOException {
        if (this.failed.get()) {
            throw new InactivityIOException("Cannot send, channel has already failed: " + this.next.getRemoteAddress());
        }
        if (command.getClass() == ProtocolFormatInfo.class) {
            AbstractInactivityMonitor abstractInactivityMonitor = this;
            synchronized (abstractInactivityMonitor) {
                this.processOutboundProtocolFormatInfo((ProtocolFormatInfo)command);
            }
        }
        this.next.oneway(command);
    }

    public void onException(IOException error) {
        if (this.failed.compareAndSet(false, true)) {
            this.stopMonitorThreads();
            this.transportListener.onException(error);
        }
    }

    public void setUseKeepAlive(boolean val) {
        this.useKeepAlive = val;
    }

    public long getReadCheckTime() {
        return this.readCheckTime;
    }

    public void setReadCheckTime(long readCheckTime) {
        this.readCheckTime = readCheckTime;
    }

    public long getWriteCheckTime() {
        return this.writeCheckTime;
    }

    public void setWriteCheckTime(long writeCheckTime) {
        this.writeCheckTime = writeCheckTime;
    }

    public long getInitialDelayTime() {
        return this.initialDelayTime;
    }

    public void setInitialDelayTime(long initialDelayTime) {
        this.initialDelayTime = initialDelayTime;
    }

    public boolean isKeepAliveResponseRequired() {
        return this.keepAliveResponseRequired;
    }

    public void setKeepAliveResponseRequired(boolean value) {
        this.keepAliveResponseRequired = value;
    }

    public boolean isMonitorStarted() {
        return this.monitorStarted.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void startMonitorThreads() throws IOException {
        if (this.monitorStarted.get()) {
            return;
        }
        if (!this.configuredOk()) {
            return;
        }
        if (this.readCheckTime > 0L) {
            this.readCheckerTask = new SchedulerTimerTask(this.readChecker);
        }
        if (this.writeCheckTime > 0L) {
            this.writeCheckerTask = new SchedulerTimerTask(this.writeChecker);
        }
        if (this.writeCheckTime <= 0L && this.readCheckTime <= 0L) return;
        this.monitorStarted.set(true);
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            if (CHECKER_COUNTER == 0) {
                ASYNC_TASKS = this.createExecutor();
                READ_CHECK_TIMER = new Timer("BESMQ InactivityMonitor ReadCheckTimer", true);
                WRITE_CHECK_TIMER = new Timer("BESMQ InactivityMonitor WriteCheckTimer", true);
            }
            ++CHECKER_COUNTER;
            if (this.readCheckTime > 0L) {
                READ_CHECK_TIMER.schedule((TimerTask)this.readCheckerTask, this.initialDelayTime, this.readCheckTime);
            }
            if (this.writeCheckTime <= 0L) return;
            WRITE_CHECK_TIMER.schedule((TimerTask)this.writeCheckerTask, this.initialDelayTime, this.writeCheckTime);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected abstract boolean configuredOk() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void stopMonitorThreads() {
        if (!this.monitorStarted.compareAndSet(true, false)) return;
        if (this.readCheckerTask != null) {
            this.readCheckerTask.cancel();
        }
        if (this.writeCheckerTask != null) {
            this.writeCheckerTask.cancel();
        }
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            WRITE_CHECK_TIMER.purge();
            READ_CHECK_TIMER.purge();
            if (--CHECKER_COUNTER != 0) return;
            WRITE_CHECK_TIMER.cancel();
            READ_CHECK_TIMER.cancel();
            WRITE_CHECK_TIMER = null;
            READ_CHECK_TIMER = null;
            ThreadPoolUtils.shutdown(ASYNC_TASKS);
            ASYNC_TASKS = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ThreadPoolExecutor createExecutor() {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.factory);
        exec.allowCoreThreadTimeOut(true);
        return exec;
    }

    static {
        DEFAULT_CHECK_TIME_MILLS = 30000L;
    }
}

