/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.command.Command;
import com.bes.mq.command.LastPartialCommand;
import com.bes.mq.command.PartialCommand;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.util.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class CommandJoiner
extends TransportFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CommandJoiner.class);
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private BESMPFormat protocolFormat;

    public CommandJoiner(Transport next, BESMPFormat protocolFormat) {
        super(next);
        this.protocolFormat = protocolFormat;
    }

    public void onCommand(Object o) {
        Command command = (Command)o;
        byte type = command.getDataStructureType();
        if (type == 50 || type == 51) {
            PartialCommand header = (PartialCommand)command;
            byte[] partialData = header.getData();
            try {
                this.out.write(partialData);
            }
            catch (IOException e) {
                this.getTransportListener().onException(e);
            }
            if (type == 51) {
                try {
                    byte[] fullData = this.out.toByteArray();
                    this.out.reset();
                    DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(fullData));
                    Command completeCommand = (Command)this.protocolFormat.unmarshal(dataIn);
                    LastPartialCommand lastCommand = (LastPartialCommand)command;
                    lastCommand.configure(completeCommand);
                    this.getTransportListener().onCommand(completeCommand);
                }
                catch (IOException e) {
                    LOG.warn("Failed to unmarshal partial command: " + command);
                    this.getTransportListener().onException(e);
                }
            }
        } else {
            this.getTransportListener().onCommand(command);
        }
    }

    public void stop() throws Exception {
        super.stop();
        this.out = null;
    }

    public String toString() {
        return this.next.toString();
    }
}

