/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport;

import com.bes.mq.command.ProtocolFormatInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.AbstractInactivityMonitor;
import com.bes.mq.transport.Transport;
import java.io.IOException;

public class InactivityMonitor
extends AbstractInactivityMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(InactivityMonitor.class);
    private ProtocolFormatInfo localProtocolFormatInfo;
    private ProtocolFormatInfo remoteProtocolFormatInfo;
    private boolean ignoreRemoteProtocolFormat = false;
    private boolean ignoreAllProtocolFormatInfo = false;

    public InactivityMonitor(Transport next, ProtocolFormat protocolFormat) {
        super(next, protocolFormat);
        if (this.protocolFormat == null) {
            this.ignoreAllProtocolFormatInfo = true;
        }
    }

    protected void processInboundProtocolFormatInfo(ProtocolFormatInfo info) throws IOException {
        IOException error = null;
        this.remoteProtocolFormatInfo = info;
        try {
            this.startMonitorThreads();
        }
        catch (IOException e) {
            error = e;
        }
        if (error != null) {
            this.onException(error);
        }
    }

    protected void processOutboundProtocolFormatInfo(ProtocolFormatInfo info) throws IOException {
        this.localProtocolFormatInfo = info;
        this.startMonitorThreads();
    }

    protected synchronized void startMonitorThreads() throws IOException {
        if (this.isMonitorStarted()) {
            return;
        }
        long readCheckTime = this.getReadCheckTime();
        if (readCheckTime > 0L) {
            this.setWriteCheckTime(this.writeCheckValueFromReadCheck(readCheckTime));
        }
        super.startMonitorThreads();
    }

    private long writeCheckValueFromReadCheck(long readCheckTime) {
        return readCheckTime > 3L ? readCheckTime / 3L : readCheckTime;
    }

    protected boolean configuredOk() throws IOException {
        boolean configured = false;
        if (this.ignoreAllProtocolFormatInfo) {
            configured = true;
        } else if (this.localProtocolFormatInfo != null && this.remoteProtocolFormatInfo != null) {
            if (!this.ignoreRemoteProtocolFormat) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using min of local: " + this.localProtocolFormatInfo + " and remote: " + this.remoteProtocolFormatInfo);
                }
                long readCheckTime = Math.min(this.localProtocolFormatInfo.getMaxInactivityDuration(), this.remoteProtocolFormatInfo.getMaxInactivityDuration());
                long writeCheckTime = this.writeCheckValueFromReadCheck(readCheckTime);
                this.setReadCheckTime(readCheckTime);
                this.setInitialDelayTime(Math.min(this.localProtocolFormatInfo.getMaxInactivityDurationInitalDelay(), this.remoteProtocolFormatInfo.getMaxInactivityDurationInitalDelay()));
                this.setWriteCheckTime(writeCheckTime);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using local: " + this.localProtocolFormatInfo);
                }
                long readCheckTime = this.localProtocolFormatInfo.getMaxInactivityDuration();
                long writeCheckTime = this.writeCheckValueFromReadCheck(readCheckTime);
                this.setReadCheckTime(readCheckTime);
                this.setInitialDelayTime(this.localProtocolFormatInfo.getMaxInactivityDurationInitalDelay());
                this.setWriteCheckTime(writeCheckTime);
            }
            configured = true;
        }
        return configured;
    }

    public boolean isIgnoreAllProtocolFormatInfo() {
        return this.ignoreAllProtocolFormatInfo;
    }

    public void setIgnoreAllProtocolFormatInfo(boolean ignoreAllProtocolFormatInfo) {
        this.ignoreAllProtocolFormatInfo = ignoreAllProtocolFormatInfo;
    }

    public boolean isIgnoreRemoteProtocolFormat() {
        return this.ignoreRemoteProtocolFormat;
    }

    public void setIgnoreRemoteProtocolFormat(boolean ignoreRemoteProtocolFormat) {
        this.ignoreRemoteProtocolFormat = ignoreRemoteProtocolFormat;
    }
}

