/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.command.Command;
import com.bes.mq.command.ProtocolFormatInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.util.IOExceptionSupport;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProtocolFormatNegotiator
extends TransportFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolFormatNegotiator.class);
    private BESMPFormat protocolFormat;
    private final int minimumVersion;
    private long negotiateTimeout = 15000L;
    private final AtomicBoolean firstStart = new AtomicBoolean(true);
    private final CountDownLatch readyCountDownLatch = new CountDownLatch(1);
    private final CountDownLatch protocolInfoSentDownLatch = new CountDownLatch(1);

    public ProtocolFormatNegotiator(Transport next, BESMPFormat protocolFormat, int minimumVersion) {
        super(next);
        this.protocolFormat = protocolFormat;
        if (minimumVersion <= 0) {
            minimumVersion = 1;
        }
        this.minimumVersion = minimumVersion;
        try {
            if (protocolFormat.getPreferedProtocolFormatInfo() != null) {
                this.setNegotiateTimeout(protocolFormat.getPreferedProtocolFormatInfo().getMaxInactivityDurationInitalDelay());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void start() throws Exception {
        super.start();
        if (this.firstStart.compareAndSet(true, false)) {
            this.sendProtocolFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendProtocolFormat() throws IOException {
        try {
            ProtocolFormatInfo info = this.protocolFormat.getPreferedProtocolFormatInfo();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending: " + info);
            }
            this.sendProtocolFormat(info);
        }
        finally {
            this.protocolInfoSentDownLatch.countDown();
        }
    }

    public void stop() throws Exception {
        super.stop();
        this.readyCountDownLatch.countDown();
    }

    public void oneway(Object command) throws IOException {
        try {
            if (!this.readyCountDownLatch.await(this.negotiateTimeout, TimeUnit.MILLISECONDS)) {
                throw new IOException("Protocol format negotiation timeout: peer did not send his protocol format.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        super.oneway(command);
    }

    public void onCommand(Object o) {
        Command command = (Command)o;
        if (command.isProtocolFormatInfo()) {
            ProtocolFormatInfo info = (ProtocolFormatInfo)command;
            this.negociate(info);
        }
        this.getTransportListener().onCommand(command);
    }

    public void negociate(ProtocolFormatInfo info) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received ProtocolFormat: " + info);
        }
        try {
            this.protocolInfoSentDownLatch.await();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " before negotiation: " + this.protocolFormat);
            }
            if (!info.isValid()) {
                this.onException(new IOException("Remote protocol format magic is invalid"));
            } else if (info.getVersion() < this.minimumVersion) {
                this.onException(new IOException("Remote protocol format (" + info.getVersion() + ") is lower the minimum version required (" + this.minimumVersion + ")"));
            }
            this.protocolFormat.renegotiateProtocolFormat(info);
            Socket socket = this.next.narrow(Socket.class);
            if (socket != null) {
                socket.setTcpNoDelay(this.protocolFormat.isTcpNoDelayEnabled());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " after negotiation: " + this.protocolFormat);
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (InterruptedException e) {
            this.onException((IOException)new InterruptedIOException().initCause(e));
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        this.readyCountDownLatch.countDown();
        this.onProtocolFormatNegotiated(info);
    }

    public void onException(IOException error) {
        this.readyCountDownLatch.countDown();
        super.onException(error);
    }

    public String toString() {
        return this.next.toString();
    }

    protected void sendProtocolFormat(ProtocolFormatInfo info) throws IOException {
        this.next.oneway(info);
    }

    protected void onProtocolFormatNegotiated(ProtocolFormatInfo info) {
    }

    public long getNegotiateTimeout() {
        return this.negotiateTimeout;
    }

    public void setNegotiateTimeout(long negotiateTimeout) {
        this.negotiateTimeout = negotiateTimeout;
    }
}

