/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport;

import com.bes.mq.command.Command;
import com.bes.mq.command.ExceptionResponse;
import com.bes.mq.command.Response;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.FutureResponse;
import com.bes.mq.transport.ResponseCallback;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.util.IntSequenceGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ResponseCorrelator
extends TransportFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCorrelator.class);
    private final Map<Integer, FutureResponse> requestMap = new HashMap<Integer, FutureResponse>();
    private IntSequenceGenerator sequenceGenerator;
    private final boolean debug = LOG.isDebugEnabled();
    private IOException error;

    public ResponseCorrelator(Transport next) {
        this(next, new IntSequenceGenerator());
    }

    public ResponseCorrelator(Transport next, IntSequenceGenerator sequenceGenerator) {
        super(next);
        this.sequenceGenerator = sequenceGenerator;
    }

    public void oneway(Object o) throws IOException {
        Command command = (Command)o;
        command.setCommandId(this.sequenceGenerator.getNextSequenceId());
        command.setResponseRequired(false);
        this.next.oneway(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse asyncRequest(Object o, ResponseCallback responseCallback) throws IOException {
        Command command = (Command)o;
        command.setCommandId(this.sequenceGenerator.getNextSequenceId());
        command.setResponseRequired(true);
        FutureResponse future = new FutureResponse(responseCallback);
        IOException priorError = null;
        Map<Integer, FutureResponse> map = this.requestMap;
        synchronized (map) {
            priorError = this.error;
            if (priorError == null) {
                this.requestMap.put(new Integer(command.getCommandId()), future);
            }
        }
        if (priorError != null) {
            future.set(new ExceptionResponse(priorError));
            throw priorError;
        }
        this.next.oneway(command);
        return future;
    }

    public Object request(Object command) throws IOException {
        FutureResponse response = this.asyncRequest(command, null);
        return response.getResult();
    }

    public Object request(Object command, int timeout) throws IOException {
        FutureResponse response = this.asyncRequest(command, null);
        return response.getResult(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(Object o) {
        Command command = null;
        if (!(o instanceof Command)) {
            throw new ClassCastException("Object cannot be converted to a Command,  Object: " + o);
        }
        command = (Command)o;
        if (command.isResponse()) {
            Response response = (Response)command;
            FutureResponse future = null;
            Map<Integer, FutureResponse> map = this.requestMap;
            synchronized (map) {
                future = this.requestMap.remove(response.getCorrelationId());
            }
            if (future != null) {
                future.set(response);
            } else if (this.debug) {
                LOG.debug("Received unexpected response: {" + command + "}for command id: " + response.getCorrelationId());
            }
        } else {
            this.getTransportListener().onCommand(command);
        }
    }

    public void onException(IOException error) {
        this.dispose(error);
        super.onException(error);
    }

    public void stop() throws Exception {
        this.dispose(new IOException("Stopped."));
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(IOException error) {
        ArrayList<FutureResponse> requests = null;
        Map<Integer, FutureResponse> map = this.requestMap;
        synchronized (map) {
            if (this.error == null) {
                this.error = error;
                requests = new ArrayList<FutureResponse>(this.requestMap.values());
                this.requestMap.clear();
            }
        }
        if (requests != null) {
            for (FutureResponse fr : requests) {
                fr.set(new ExceptionResponse(error));
            }
        }
    }

    public IntSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public String toString() {
        return this.next.toString();
    }
}

