/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.protocolformat.ProtocolFormatFactory;
import com.bes.mq.transport.MutexTransport;
import com.bes.mq.transport.ResponseCorrelator;
import com.bes.mq.transport.ThreadNameFilter;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.WriteTimeoutFilter;
import com.bes.mq.util.FactoryFinder;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportFactory {
    private static final FactoryFinder TRANSPORT_FACTORY_FINDER = new FactoryFinder("META-INF/services/com/bes/mq/transport/");
    private static final FactoryFinder PROTOCOLFORMAT_FACTORY_FINDER = new FactoryFinder("META-INF/services/com/bes/mq/protocolformat/");
    private static final ConcurrentHashMap<String, TransportFactory> TRANSPORT_FACTORYS = new ConcurrentHashMap();
    private static final String WRITE_TIMEOUT_FILTER = "soWriteTimeout";
    private static final String THREAD_NAME_FILTER = "threadName";
    private static final String ENABLE_SSL = "enableSSL";
    private static final String SOCKET_TYPE = "socketType";

    public abstract TransportServer doBind(URI var1) throws IOException;

    public Transport doConnect(URI location, Executor ex) throws Exception {
        return this.doConnect(location);
    }

    public Transport doCompositeConnect(URI location, Executor ex) throws Exception {
        return this.doCompositeConnect(location);
    }

    public static Transport connect(URI location) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doConnect(location);
    }

    public static Transport connect(URI location, Executor ex) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doConnect(location, ex);
    }

    public static Transport compositeConnect(URI location) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doCompositeConnect(location);
    }

    public static Transport compositeConnect(URI location, Executor ex) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doCompositeConnect(location, ex);
    }

    public static TransportServer bind(URI location) throws IOException {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doBind(location);
    }

    public static TransportServer bind(BrokerService brokerService, URI location) throws IOException {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        if (brokerService != null && tf instanceof BrokerServiceAware) {
            ((BrokerServiceAware)((Object)tf)).setBrokerService(brokerService);
        }
        return tf.doBind(location);
    }

    public Transport doConnect(URI location) throws Exception {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            ProtocolFormat wf = this.createProtocolFormat(options);
            Transport transport = this.createTransport(location, wf);
            Transport rc = this.configure(transport, wf, options);
            if (!this.validOptions(options)) {
                throw new IllegalArgumentException("Invalid connect parameters: " + options);
            }
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public Transport doCompositeConnect(URI location) throws Exception {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            ProtocolFormat wf = this.createProtocolFormat(options);
            Transport transport = this.createTransport(location, wf);
            Transport rc = this.compositeConfigure(transport, wf, options);
            if (!this.validOptions(options)) {
                throw new IllegalArgumentException("Invalid connect parameters: " + options);
            }
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    private boolean validOptions(Map<String, String> options) {
        options.remove(ENABLE_SSL);
        options.remove(SOCKET_TYPE);
        return options.isEmpty();
    }

    public static void registerTransportFactory(String scheme, TransportFactory tf) {
        TRANSPORT_FACTORYS.put(scheme, tf);
    }

    protected Transport createTransport(URI location, ProtocolFormat wf) throws MalformedURLException, UnknownHostException, IOException {
        throw new IOException("createTransport() method not implemented!");
    }

    private static TransportFactory findTransportFactory(URI location) throws IOException {
        String scheme = location.getScheme();
        if (scheme == null) {
            throw new IOException("Transport not scheme specified: [" + location + "]");
        }
        scheme = scheme.toLowerCase();
        try {
            Map<String, String> map = URISupport.parseQuery(location.toString());
            String socketType = map.get(SOCKET_TYPE);
            Boolean enableSSL = Boolean.parseBoolean(map.get(ENABLE_SSL));
            if ("tcp".equalsIgnoreCase(scheme)) {
                if (enableSSL.booleanValue() && "nio".equalsIgnoreCase(socketType)) {
                    scheme = "nio+ssl";
                } else if (enableSSL.booleanValue()) {
                    scheme = "ssl";
                } else if ("nio".equalsIgnoreCase(socketType)) {
                    scheme = "nio";
                }
            } else if ("stomp".equalsIgnoreCase(scheme)) {
                if (enableSSL.booleanValue() && "nio".equalsIgnoreCase(socketType)) {
                    scheme = "stomp+nio+ssl";
                } else if (enableSSL.booleanValue()) {
                    scheme = "stomp+ssl";
                } else if ("nio".equalsIgnoreCase(socketType)) {
                    scheme = "stomp+nio";
                }
            } else if ("mqtt".equalsIgnoreCase(scheme)) {
                if (enableSSL.booleanValue() && "nio".equalsIgnoreCase(socketType)) {
                    scheme = "mqtt+nio+ssl";
                } else if (enableSSL.booleanValue()) {
                    scheme = "mqtt+ssl";
                } else if ("nio".equalsIgnoreCase(socketType)) {
                    scheme = "mqtt+nio";
                }
            } else if ("http".equalsIgnoreCase(scheme) && enableSSL.booleanValue()) {
                scheme = "https";
            }
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
        TransportFactory tf = TRANSPORT_FACTORYS.get(scheme);
        if (tf == null) {
            try {
                tf = (TransportFactory)TRANSPORT_FACTORY_FINDER.newInstance(scheme);
                TRANSPORT_FACTORYS.put(scheme, tf);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("Transport scheme NOT recognized: [" + scheme + "]", e);
            }
        }
        return tf;
    }

    protected ProtocolFormat createProtocolFormat(Map<String, String> options) throws IOException {
        ProtocolFormatFactory factory = this.createProtocolFormatFactory(options);
        ProtocolFormat format = factory.createProtocolFormat();
        return format;
    }

    protected ProtocolFormatFactory createProtocolFormatFactory(Map<String, String> options) throws IOException {
        String protocolFormat = options.remove("protocolFormat");
        if (protocolFormat == null) {
            protocolFormat = this.getDefaultProtocolFormatType();
        }
        try {
            ProtocolFormatFactory wff = (ProtocolFormatFactory)PROTOCOLFORMAT_FACTORY_FINDER.newInstance(protocolFormat);
            IntrospectionSupport.setProperties(wff, options, "protocolFormat.");
            return wff;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Could not create protocol format factory for: " + protocolFormat + ", reason: " + e, e);
        }
    }

    protected String getDefaultProtocolFormatType() {
        return "default";
    }

    public Transport configure(Transport transport, ProtocolFormat wf, Map options) throws Exception {
        transport = this.compositeConfigure(transport, wf, options);
        transport = new MutexTransport(transport);
        transport = new ResponseCorrelator(transport);
        return transport;
    }

    public Transport serverConfigure(Transport transport, ProtocolFormat format, HashMap options) throws Exception {
        if (options.containsKey(THREAD_NAME_FILTER)) {
            transport = new ThreadNameFilter(transport);
        }
        transport = this.compositeConfigure(transport, format, options);
        transport = new MutexTransport(transport);
        return transport;
    }

    public Transport compositeConfigure(Transport transport, ProtocolFormat format, Map options) {
        if (options.containsKey(WRITE_TIMEOUT_FILTER)) {
            transport = new WriteTimeoutFilter(transport);
            String soWriteTimeout = (String)options.remove(WRITE_TIMEOUT_FILTER);
            if (soWriteTimeout != null) {
                ((WriteTimeoutFilter)transport).setWriteTimeout(Long.parseLong(soWriteTimeout));
            }
        }
        IntrospectionSupport.setProperties(transport, options);
        return transport;
    }

    protected String getOption(Map options, String key, String def) {
        String rc = (String)options.remove(key);
        if (rc == null) {
            rc = def;
        }
        return rc;
    }
}

