/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport;

import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.transport.FutureResponse;
import com.bes.mq.transport.LogWriter;
import com.bes.mq.transport.ResponseCallback;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.transport.TransportLoggerView;
import java.io.IOException;

public class TransportLogger
extends TransportFilter {
    private final Logger log;
    private boolean logging;
    private final LogWriter logWriter;
    private TransportLoggerView view;

    public TransportLogger(Transport next, Logger log, boolean startLogging, LogWriter logWriter) {
        super(next);
        this.log = log;
        this.logging = startLogging;
        this.logWriter = logWriter;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public Object request(Object command) throws IOException {
        if (this.logging) {
            this.logWriter.logRequest(this.log, command);
        }
        Object rc = super.request(command);
        if (this.logging) {
            this.logWriter.logResponse(this.log, command);
        }
        return rc;
    }

    public Object request(Object command, int timeout) throws IOException {
        if (this.logging) {
            this.logWriter.logRequest(this.log, command);
        }
        Object rc = super.request(command, timeout);
        if (this.logging) {
            this.logWriter.logResponse(this.log, command);
        }
        return rc;
    }

    public FutureResponse asyncRequest(Object command, ResponseCallback responseCallback) throws IOException {
        if (this.logging) {
            this.logWriter.logAsyncRequest(this.log, command);
        }
        FutureResponse rc = this.next.asyncRequest(command, responseCallback);
        return rc;
    }

    public void oneway(Object command) throws IOException {
        if (this.logging && this.log.isDebugEnabled()) {
            this.logWriter.logOneWay(this.log, command);
        }
        this.next.oneway(command);
    }

    public void onCommand(Object command) {
        if (this.logging && this.log.isDebugEnabled()) {
            this.logWriter.logReceivedCommand(this.log, command);
        }
        this.getTransportListener().onCommand(command);
    }

    public void onException(IOException error) {
        if (this.logging && this.log.isDebugEnabled()) {
            this.logWriter.logReceivedException(this.log, error);
        }
        this.getTransportListener().onException(error);
    }

    public TransportLoggerView getView() {
        return this.view;
    }

    public void setView(TransportLoggerView view) {
        this.view = view;
    }

    public String toString() {
        return this.next.toString();
    }

    public void finalize() throws Throwable {
        if (this.view != null) {
            this.view.unregister();
        }
    }
}

