/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.discovery;

import com.bes.mq.transport.discovery.DiscoveryAgent;
import com.bes.mq.util.FactoryFinder;
import com.bes.mq.util.IOExceptionSupport;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DiscoveryAgentFactory {
    private static final FactoryFinder DISCOVERY_AGENT_FINDER = new FactoryFinder("META-INF/services/com/bes/mq/transport/discoveryagent/");
    private static final ConcurrentHashMap<String, DiscoveryAgentFactory> DISCOVERY_AGENT_FACTORYS = new ConcurrentHashMap();

    private static DiscoveryAgentFactory findDiscoveryAgentFactory(URI uri) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IOException("DiscoveryAgent scheme not specified: [" + uri + "]");
        }
        DiscoveryAgentFactory daf = DISCOVERY_AGENT_FACTORYS.get(scheme = scheme.toLowerCase());
        if (daf == null) {
            try {
                daf = (DiscoveryAgentFactory)DISCOVERY_AGENT_FINDER.newInstance(scheme);
                DISCOVERY_AGENT_FACTORYS.put(scheme, daf);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("DiscoveryAgent scheme NOT recognized: [" + scheme + "]", e);
            }
        }
        return daf;
    }

    public static DiscoveryAgent createDiscoveryAgent(URI uri) throws IOException {
        DiscoveryAgentFactory tf = DiscoveryAgentFactory.findDiscoveryAgentFactory(uri);
        return tf.doCreateDiscoveryAgent(uri);
    }

    protected abstract DiscoveryAgent doCreateDiscoveryAgent(URI var1) throws IOException;
}

