/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.discovery;

import com.bes.mq.command.DiscoveryEvent;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.CompositeTransport;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.transport.discovery.DiscoveryAgent;
import com.bes.mq.transport.discovery.DiscoveryListener;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.URISupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryTransport
extends TransportFilter
implements DiscoveryListener {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryTransport.class);
    private final CompositeTransport next;
    private DiscoveryAgent discoveryAgent;
    private final ConcurrentHashMap<String, URI> serviceURIs = new ConcurrentHashMap();
    private Map<String, String> parameters;

    public DiscoveryTransport(CompositeTransport next) {
        super(next);
        this.next = next;
    }

    @Override
    public void start() throws Exception {
        if (this.discoveryAgent == null) {
            throw new IllegalStateException("discoveryAgent not configured");
        }
        this.discoveryAgent.setDiscoveryListener(this);
        this.discoveryAgent.start();
        this.next.start();
    }

    @Override
    public void stop() throws Exception {
        ServiceStopper ss = new ServiceStopper();
        ss.stop(this.discoveryAgent);
        ss.stop(this.next);
        ss.throwFirstException();
    }

    @Override
    public void onServiceAdd(DiscoveryEvent event) {
        String url = event.getServiceName();
        if (url != null) {
            try {
                URI uri = new URI(url);
                LOG.info("Adding new broker connection URL: " + uri);
                uri = URISupport.applyParameters(uri, this.parameters, "discovered.");
                this.serviceURIs.put(event.getServiceName(), uri);
                this.next.add(false, new URI[]{uri});
            }
            catch (URISyntaxException e) {
                LOG.warn("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e, e);
            }
        }
    }

    @Override
    public void onServiceRemove(DiscoveryEvent event) {
        URI uri = this.serviceURIs.get(event.getServiceName());
        if (uri != null) {
            this.next.remove(false, new URI[]{uri});
        }
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }
}

