/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.discovery.http;

import com.bes.mq.transport.discovery.DiscoveryAgent;
import com.bes.mq.transport.discovery.DiscoveryAgentFactory;
import com.bes.mq.transport.discovery.http.HTTPDiscoveryAgent;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

public class HTTPDiscoveryAgentFactory
extends DiscoveryAgentFactory {
    @Override
    protected DiscoveryAgent doCreateDiscoveryAgent(URI uri) throws IOException {
        try {
            Map<String, String> options = URISupport.parseParameters(uri);
            uri = URISupport.removeQuery(uri);
            HTTPDiscoveryAgent rc = new HTTPDiscoveryAgent();
            rc.setRegistryURL(uri.toString());
            IntrospectionSupport.setProperties(rc, options);
            return rc;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Could not create discovery agent: " + uri, e);
        }
    }
}

