/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.discovery.multicast;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.command.DiscoveryEvent;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.discovery.DiscoveryAgent;
import com.bes.mq.transport.discovery.DiscoveryListener;
import com.bes.mq.util.ThreadPoolUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class MulticastDiscoveryAgent
implements BrokerServiceAware,
DiscoveryAgent,
Runnable {
    public static final String DEFAULT_DISCOVERY_URI_STRING = "multicast://239.255.9.2:4891";
    public static final String DEFAULT_HOST_STR = "default";
    public static final String DEFAULT_HOST_IP = System.getProperty("besmq.partition.discovery", "239.255.9.2");
    public static final int DEFAULT_PORT = 4891;
    public static final String DEFAULT_BROKER_ID = "localhost";
    private static final Logger LOG = LoggerFactory.getLogger(MulticastDiscoveryAgent.class);
    private static final String TYPE_SUFFIX = "BESMQ-1.";
    private static final String ALIVE = "alive.";
    private static final String DEAD = "dead.";
    private static final String DELIMITER = "%";
    private static final int BUFF_SIZE = 8192;
    private static final int DEFAULT_IDLE_TIME = 500;
    private static final int HEARTBEAT_MISS_BEFORE_DEATH = 10;
    private long initialReconnectDelay = 5000L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff;
    private int maxReconnectAttempts;
    private int heartBeatMissWarnThreshold = 10;
    private int timeToLive = 1;
    private boolean loopBackMode;
    private Map<String, RemoteBrokerData> brokersByService = new ConcurrentHashMap<String, RemoteBrokerData>();
    private String group = "default";
    private URI discoveryURI;
    private InetAddress inetAddress;
    private SocketAddress sockAddress;
    private DiscoveryListener discoveryListener;
    private String selfService;
    private MulticastSocket mcast;
    private Thread runner;
    private long keepAliveInterval = 500L;
    private String mcInterface;
    private String mcNetworkInterface;
    private String mcJoinNetworkInterface;
    private long lastAdvertizeTime;
    private AtomicBoolean started = new AtomicBoolean(false);
    private boolean reportAdvertizeFailed = true;
    private ExecutorService executor = null;
    private BrokerService brokerService;
    private long lastHeartbeatCheckTime = 0L;

    public void setDiscoveryListener(DiscoveryListener listener) {
        this.discoveryListener = listener;
    }

    public void registerService(String name) throws IOException {
        this.selfService = name;
        if (this.started.get()) {
            this.doAdvertizeSelf();
        }
    }

    public boolean isLoopBackMode() {
        return this.loopBackMode;
    }

    public void setLoopBackMode(boolean loopBackMode) {
        this.loopBackMode = loopBackMode;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public URI getDiscoveryURI() {
        return this.discoveryURI;
    }

    public void setDiscoveryURI(URI discoveryURI) {
        this.discoveryURI = discoveryURI;
    }

    public long getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(long keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public void setInterface(String mcInterface) {
        this.mcInterface = mcInterface;
    }

    public void setNetworkInterface(String mcNetworkInterface) {
        this.mcNetworkInterface = mcNetworkInterface;
    }

    public void setJoinNetworkInterface(String mcJoinNetwrokInterface) {
        this.mcJoinNetworkInterface = mcJoinNetwrokInterface;
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            if (this.group == null || this.group.length() == 0) {
                throw new IOException("Must specify a group to discover");
            }
            String type = this.getType();
            if (!type.endsWith(".")) {
                LOG.warn("The type '" + type + "' should end with '.' to be a valid Discovery type");
                type = type + ".";
            }
            if (this.discoveryURI == null) {
                this.discoveryURI = new URI(DEFAULT_DISCOVERY_URI_STRING);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Start - discoveryURI = " + this.discoveryURI);
            }
            String myHost = this.discoveryURI.getHost();
            int myPort = this.discoveryURI.getPort();
            if (DEFAULT_HOST_STR.equals(myHost)) {
                myHost = DEFAULT_HOST_IP;
            }
            if (myPort < 0) {
                myPort = 4891;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Start - myHost = " + myHost);
                LOG.trace("Start - myPort = " + myPort);
                LOG.trace("Start - group  = " + this.group);
                LOG.trace("Start - interface  = " + this.mcInterface);
                LOG.trace("Start - network interface  = " + this.mcNetworkInterface);
                LOG.trace("Start - join network interface  = " + this.mcJoinNetworkInterface);
            }
            this.inetAddress = InetAddress.getByName(myHost);
            this.sockAddress = new InetSocketAddress(this.inetAddress, myPort);
            this.mcast = new MulticastSocket(myPort);
            this.mcast.setLoopbackMode(this.loopBackMode);
            this.mcast.setTimeToLive(this.getTimeToLive());
            if (this.mcJoinNetworkInterface != null) {
                this.mcast.joinGroup(this.sockAddress, NetworkInterface.getByName(this.mcJoinNetworkInterface));
            } else {
                this.mcast.joinGroup(this.inetAddress);
            }
            this.mcast.setSoTimeout((int)this.keepAliveInterval);
            if (this.mcInterface != null) {
                this.mcast.setInterface(InetAddress.getByName(this.mcInterface));
            }
            if (this.mcNetworkInterface != null) {
                this.mcast.setNetworkInterface(NetworkInterface.getByName(this.mcNetworkInterface));
            }
            this.runner = new Thread(this);
            this.runner.setName(this.toString() + ":" + this.runner.getName());
            this.runner.setDaemon(true);
            this.runner.start();
            this.doAdvertizeSelf();
        }
    }

    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            this.doAdvertizeSelf();
            if (this.mcast != null) {
                this.mcast.close();
            }
            if (this.runner != null) {
                this.runner.interrupt();
            }
            if (this.executor != null) {
                ThreadPoolUtils.shutdownNow(this.executor);
                this.executor = null;
            }
        }
    }

    public String getType() {
        return this.group + "." + TYPE_SUFFIX;
    }

    public void run() {
        byte[] buf = new byte[8192];
        DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
        while (this.started.get()) {
            this.doTimeKeepingServices();
            try {
                this.mcast.receive(packet);
                if (packet.getLength() <= 0) continue;
                String str = new String(packet.getData(), packet.getOffset(), packet.getLength());
                this.processData(str);
            }
            catch (SocketTimeoutException se) {
            }
            catch (IOException e) {
                if (!this.started.get()) continue;
                LOG.error("failed to process packet: " + e);
            }
        }
    }

    private void processData(String str) {
        if (this.discoveryListener != null && str.startsWith(this.getType())) {
            String payload = str.substring(this.getType().length());
            if (payload.startsWith(ALIVE)) {
                String brokerId = this.getBrokerId(payload.substring(ALIVE.length()));
                if (!this.getLocalBrokerId().equals(brokerId)) {
                    String service = payload.substring(ALIVE.length() + brokerId.length() + 2);
                    this.processAlive(brokerId, service);
                }
            } else {
                String brokerId = this.getBrokerId(payload.substring(DEAD.length()));
                if (!this.getLocalBrokerId().equals(brokerId)) {
                    String service = payload.substring(DEAD.length() + brokerId.length() + 2);
                    this.processDead(service);
                }
            }
        }
    }

    private void doTimeKeepingServices() {
        if (this.started.get()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lastAdvertizeTime || currentTime - this.keepAliveInterval > this.lastAdvertizeTime) {
                this.doAdvertizeSelf();
                this.lastAdvertizeTime = currentTime;
            }
            this.doExpireOldServices();
        }
    }

    private void doAdvertizeSelf() {
        block3: {
            if (this.selfService != null) {
                String payload = this.getType();
                payload = payload + (this.started.get() ? ALIVE : DEAD);
                payload = payload + DELIMITER + this.getLocalBrokerId() + DELIMITER;
                payload = payload + this.selfService;
                try {
                    byte[] data = payload.getBytes();
                    DatagramPacket packet = new DatagramPacket(data, 0, data.length, this.sockAddress);
                    this.mcast.send(packet);
                }
                catch (IOException e) {
                    if (!this.reportAdvertizeFailed) break block3;
                    this.reportAdvertizeFailed = false;
                    LOG.error("Failed to advertise our service: " + payload, e);
                    if (!"Operation not permitted".equals(e.getMessage())) break block3;
                    LOG.error("The 'Operation not permitted' error has been known to be caused by improper firewall/network setup.  Please make sure that the OS is properly configured to allow multicast traffic over: " + this.mcast.getLocalAddress());
                }
            }
        }
    }

    private void processAlive(String brokerId, String service) {
        if (this.selfService == null || !service.equals(this.selfService)) {
            RemoteBrokerData data = this.brokersByService.get(service);
            if (data == null) {
                data = new RemoteBrokerData(brokerId, service);
                this.brokersByService.put(service, data);
                this.fireServiceAddEvent(data);
                this.doAdvertizeSelf();
            } else {
                data.updateHeartBeat();
                if (data.doRecovery()) {
                    this.fireServiceAddEvent(data);
                }
            }
        }
    }

    private void processDead(String service) {
        RemoteBrokerData data;
        if (!service.equals(this.selfService) && (data = this.brokersByService.remove(service)) != null && !data.isFailed()) {
            this.fireServiceRemovedEvent(data);
        }
    }

    private void doExpireOldServices() {
        long currentTimeMillis;
        if (this.heartBeatMissWarnThreshold > 0 && (currentTimeMillis = System.currentTimeMillis()) > this.lastHeartbeatCheckTime) {
            long expireTime = currentTimeMillis - this.keepAliveInterval * (long)this.heartBeatMissWarnThreshold;
            for (Map.Entry<String, RemoteBrokerData> next : this.brokersByService.entrySet()) {
                RemoteBrokerData data = next.getValue();
                if (data.getLastHeartBeat() >= expireTime) continue;
                double missTimeInSeconds = (double)(currentTimeMillis - data.getLastHeartBeat()) / 1000.0;
                LOG.warn(String.format("Miss heartbeat of the service %s for %.2f seconds", next.getKey(), missTimeInSeconds));
            }
            this.lastHeartbeatCheckTime = currentTimeMillis + this.keepAliveInterval * (long)this.heartBeatMissWarnThreshold;
        }
    }

    private String getBrokerId(String str) {
        String result = null;
        int start = str.indexOf(DELIMITER);
        if (start >= 0) {
            int end = str.indexOf(DELIMITER, start + 1);
            result = str.substring(start + 1, end);
        }
        return result;
    }

    public void serviceFailed(DiscoveryEvent event) throws IOException {
        RemoteBrokerData data = this.brokersByService.get(event.getServiceName());
        if (data != null && data.markFailed()) {
            this.fireServiceRemovedEvent(data);
        }
    }

    private void fireServiceRemovedEvent(RemoteBrokerData data) {
        if (this.discoveryListener != null && this.started.get()) {
            final DiscoveryEvent event = new DiscoveryEvent(data.service);
            event.setBrokerName(data.brokerId);
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    DiscoveryListener discoveryListener = MulticastDiscoveryAgent.this.discoveryListener;
                    if (discoveryListener != null) {
                        discoveryListener.onServiceRemove(event);
                    }
                }
            });
        }
    }

    private void fireServiceAddEvent(RemoteBrokerData data) {
        if (this.discoveryListener != null && this.started.get()) {
            final DiscoveryEvent event = new DiscoveryEvent(data.service);
            event.setBrokerName(data.brokerId);
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    DiscoveryListener discoveryListener = MulticastDiscoveryAgent.this.discoveryListener;
                    if (discoveryListener != null) {
                        discoveryListener.onServiceAdd(event);
                    }
                }
            });
        }
    }

    private ExecutorService getExecutor() {
        if (this.executor == null) {
            final String threadName = "Notifier-" + this.toString();
            this.executor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                public Thread newThread(Runnable runable) {
                    Thread t = new Thread(runable, threadName);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.executor;
    }

    public long getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(long backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String toString() {
        return "MulticastDiscoveryAgent-" + (this.selfService != null ? "advertise:" + this.selfService : "listener:" + this.discoveryListener);
    }

    public int getHeartBeatMissWarnThreshold() {
        return this.heartBeatMissWarnThreshold;
    }

    public void setHeartBeatMissWarnThreshold(int heartBeatMissWarnThreshold) {
        this.heartBeatMissWarnThreshold = heartBeatMissWarnThreshold;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public String getLocalBrokerId() {
        if (this.brokerService == null) {
            return DEFAULT_BROKER_ID;
        }
        String brokerId = null;
        try {
            brokerId = this.brokerService.getBroker().getBrokerId().getValue();
        }
        catch (Exception e) {
            LOG.warn("Failed to get local broker id, caused by: " + e.getMessage());
        }
        if (brokerId == null) {
            brokerId = DEFAULT_BROKER_ID;
            return DEFAULT_BROKER_ID;
        }
        return brokerId.replaceAll(DELIMITER, "#");
    }

    class RemoteBrokerData {
        final String brokerId;
        final String service;
        long lastHeartBeat;
        long recoveryTime;
        int failureCount;
        boolean failed;
        private long reconnectDelay;

        public RemoteBrokerData(String brokerId, String service) {
            this.brokerId = brokerId;
            this.service = service;
            this.lastHeartBeat = System.currentTimeMillis();
        }

        public synchronized void updateHeartBeat() {
            this.lastHeartBeat = System.currentTimeMillis();
            if (!this.failed && this.failureCount > 0 && this.lastHeartBeat - this.recoveryTime > 60000L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The " + this.service + " service has recovered.");
                }
                this.failureCount = 0;
                this.recoveryTime = 0L;
            }
        }

        public synchronized long getLastHeartBeat() {
            return this.lastHeartBeat;
        }

        public synchronized boolean markFailed() {
            if (!this.failed) {
                this.failed = true;
                ++this.failureCount;
                if (this.reconnectDelay == 0L) {
                    this.reconnectDelay = MulticastDiscoveryAgent.this.initialReconnectDelay;
                } else if (MulticastDiscoveryAgent.this.useExponentialBackOff && MulticastDiscoveryAgent.this.backOffMultiplier > 1L) {
                    this.reconnectDelay *= MulticastDiscoveryAgent.this.backOffMultiplier;
                    if (MulticastDiscoveryAgent.this.maxReconnectDelay != -1L && this.reconnectDelay > MulticastDiscoveryAgent.this.maxReconnectDelay) {
                        this.reconnectDelay = Math.max(MulticastDiscoveryAgent.this.maxReconnectDelay, MulticastDiscoveryAgent.this.initialReconnectDelay);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remote failure of " + this.service + " while still receiving multicast advertisements.  Advertising events will be suppressed for " + this.reconnectDelay + " ms, the current failure count is: " + this.failureCount);
                }
                this.recoveryTime = System.currentTimeMillis() + this.reconnectDelay;
                return true;
            }
            return false;
        }

        public synchronized boolean doRecovery() {
            if (!this.failed) {
                return false;
            }
            if (MulticastDiscoveryAgent.this.maxReconnectAttempts > 0 && this.failureCount > MulticastDiscoveryAgent.this.maxReconnectAttempts) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Max reconnect attempts of the " + this.service + " service has been reached.");
                }
                return false;
            }
            if (System.currentTimeMillis() < this.recoveryTime) {
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resuming event advertisement of the " + this.service + " service.");
            }
            this.failed = false;
            return true;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

