/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.discovery.multicast;

import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.discovery.DiscoveryAgent;
import com.bes.mq.transport.discovery.DiscoveryAgentFactory;
import com.bes.mq.transport.discovery.multicast.MulticastDiscoveryAgent;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

public class MulticastDiscoveryAgentFactory
extends DiscoveryAgentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MulticastDiscoveryAgentFactory.class);

    protected DiscoveryAgent doCreateDiscoveryAgent(URI uri) throws IOException {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("doCreateDiscoveryAgent: uri = " + uri.toString());
            }
            MulticastDiscoveryAgent mda = new MulticastDiscoveryAgent();
            mda.setDiscoveryURI(uri);
            Map<String, String> options = URISupport.parseParameters(uri);
            IntrospectionSupport.setProperties(mda, options);
            return mda;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Could not create discovery agent: " + uri, e);
        }
    }
}

