/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.failover;

import com.bes.mq.BESMQConnection;
import com.bes.mq.broker.SslContext;
import com.bes.mq.command.Command;
import com.bes.mq.command.ConnectionControl;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.MessagePull;
import com.bes.mq.command.RemoveInfo;
import com.bes.mq.command.Response;
import com.bes.mq.common.universal.net.NetUtils;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.state.ConnectionStateTracker;
import com.bes.mq.state.Tracked;
import com.bes.mq.thread.Task;
import com.bes.mq.thread.TaskRunner;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.transport.CompositeTransport;
import com.bes.mq.transport.DefaultTransportListener;
import com.bes.mq.transport.FutureResponse;
import com.bes.mq.transport.ResponseCallback;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.transport.TransportListener;
import com.bes.mq.transport.failover.BackupTransport;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.ServiceSupport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverTransport
implements CompositeTransport {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverTransport.class);
    private static final int DEFAULT_INITIAL_RECONNECT_DELAY = 10;
    private static final int INFINITE = -1;
    private TransportListener transportListener;
    private boolean disposed;
    private boolean connected;
    private final CopyOnWriteArrayList<URI> uris = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<URI> updated = new CopyOnWriteArrayList();
    private final Object reconnectMutex = new Object();
    private final Object backupMutex = new Object();
    private final Object sleepMutex = new Object();
    private final Object listenerMutex = new Object();
    private final ConnectionStateTracker stateTracker = new ConnectionStateTracker();
    private final Map<Integer, Command> requestMap = new LinkedHashMap<Integer, Command>();
    private URI connectedTransportURI;
    private URI failedConnectTransportURI;
    private final AtomicReference<Transport> connectedTransport = new AtomicReference();
    private final TaskRunnerFactory reconnectTaskFactory;
    private final TaskRunner reconnectTask;
    private boolean started;
    private boolean initialized;
    private long initialReconnectDelay = 10L;
    private long maxReconnectDelay = 30000L;
    private double backOffMultiplier = 2.0;
    private long timeout = 30000L;
    private boolean useExponentialBackOff = true;
    private boolean randomize = true;
    private int maxReconnectAttempts = -1;
    private int startupMaxReconnectAttempts = -1;
    private int connectFailures;
    private long reconnectDelay = 10L;
    private Exception connectionFailure;
    private boolean firstConnection = true;
    private boolean backup = false;
    private final List<BackupTransport> backups = new CopyOnWriteArrayList<BackupTransport>();
    private int backupPoolSize = 1;
    private boolean trackMessages = false;
    private boolean trackTransactionProducers = true;
    private int maxCacheSize = 131072;
    private final TransportListener disposedListener = new DefaultTransportListener(){};
    private final TransportListener myTransportListener = this.createTransportListener();
    private boolean updateURIsSupported = true;
    private boolean reconnectSupported = true;
    private SslContext brokerSslContext;
    private String updateURIsURL = null;
    private boolean rebalanceUpdateURIs = true;
    private boolean doRebalance = false;
    private boolean connectedToPriority = false;
    private boolean priorityBackup = false;
    private ArrayList<URI> priorityList = new ArrayList();
    private boolean priorityBackupAvailable = false;

    public FailoverTransport() throws InterruptedIOException {
        this.brokerSslContext = SslContext.getCurrentSslContext();
        this.stateTracker.setTrackTransactions(true);
        this.reconnectTaskFactory = new TaskRunnerFactory();
        this.reconnectTaskFactory.init();
        this.reconnectTask = this.reconnectTaskFactory.createTaskRunner(new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean iterate() {
                boolean result = false;
                if (!FailoverTransport.this.started) {
                    return result;
                }
                boolean buildBackup = true;
                Object object = FailoverTransport.this.backupMutex;
                synchronized (object) {
                    if ((FailoverTransport.this.connectedTransport.get() == null || FailoverTransport.this.doRebalance || FailoverTransport.this.priorityBackupAvailable) && !FailoverTransport.this.disposed) {
                        result = FailoverTransport.this.doReconnect();
                        buildBackup = false;
                        FailoverTransport.this.connectedToPriority = FailoverTransport.this.isPriority(FailoverTransport.this.connectedTransportURI);
                    }
                }
                if (buildBackup) {
                    FailoverTransport.this.buildBackups();
                    if (FailoverTransport.this.priorityBackup && !FailoverTransport.this.connectedToPriority) {
                        try {
                            FailoverTransport.this.doDelay();
                            if (FailoverTransport.this.reconnectTask == null) {
                                return true;
                            }
                            FailoverTransport.this.reconnectTask.wakeup();
                        }
                        catch (InterruptedException e) {
                            LOG.debug("Reconnect task has been interrupted.", e);
                        }
                    }
                } else {
                    buildBackup = true;
                    try {
                        if (FailoverTransport.this.reconnectTask == null) {
                            return true;
                        }
                        FailoverTransport.this.reconnectTask.wakeup();
                    }
                    catch (InterruptedException e) {
                        LOG.debug("Reconnect task has been interrupted.", e);
                    }
                }
                return result;
            }
        }, "BESMQ Failover Worker: " + System.identityHashCode(this));
    }

    TransportListener createTransportListener() {
        return new TransportListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCommand(Object o) {
                Command command = (Command)o;
                if (command == null) {
                    return;
                }
                if (command.isResponse()) {
                    Object object = null;
                    Map map = FailoverTransport.this.requestMap;
                    synchronized (map) {
                        object = FailoverTransport.this.requestMap.remove(((Response)command).getCorrelationId());
                    }
                    if (object != null && object.getClass() == Tracked.class) {
                        ((Tracked)object).onResponses(command);
                    }
                }
                if (!FailoverTransport.this.initialized) {
                    FailoverTransport.this.initialized = true;
                }
                if (command.isConnectionControl()) {
                    FailoverTransport.this.handleConnectionControl((ConnectionControl)command);
                }
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.onCommand(command);
                }
            }

            public void onException(IOException error) {
                try {
                    FailoverTransport.this.handleTransportFailure(error);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    FailoverTransport.this.transportListener.onException(new InterruptedIOException());
                }
            }

            public void transportInterupted() {
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.transportInterupted();
                }
            }

            public void transportResumed() {
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.transportResumed();
                }
            }
        };
    }

    public final void disposeTransport(Transport transport) {
        transport.setTransportListener(this.disposedListener);
        ServiceSupport.dispose(transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleTransportFailure(IOException e) throws InterruptedException {
        Transport transport;
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " handleTransportFailure: " + e);
        }
        if ((transport = (Transport)this.connectedTransport.getAndSet(null)) == null) {
            Object object = this.reconnectMutex;
            synchronized (object) {
                transport = this.connectedTransport.getAndSet(null);
            }
        }
        if (transport != null) {
            this.disposeTransport(transport);
            boolean reconnectOk = false;
            Object object = this.reconnectMutex;
            synchronized (object) {
                if (this.canReconnect()) {
                    reconnectOk = true;
                }
                if (!this.isClosedOrClosing(this.transportListener)) {
                    LOG.warn("Transport (" + transport.getRemoteAddress() + ") failed, reason:  " + e + (reconnectOk ? "," : ", not") + " attempting to automatically reconnect");
                }
                this.initialized = false;
                this.failedConnectTransportURI = this.connectedTransportURI;
                this.connectedTransportURI = null;
                this.connected = false;
                if (this.transportListener != null) {
                    this.transportListener.transportInterupted();
                }
                if (reconnectOk) {
                    this.updated.remove(this.failedConnectTransportURI);
                    this.reconnectTask.wakeup();
                } else if (!this.isDisposed()) {
                    this.propagateFailureToExceptionListener(e);
                }
            }
        }
    }

    private boolean isClosedOrClosing(TransportListener transportListener) {
        if (transportListener instanceof TransportFilter) {
            transportListener = ((TransportFilter)transportListener).getTransportListener();
            return this.isClosedOrClosing(transportListener);
        }
        if (transportListener instanceof BESMQConnection) {
            return ((BESMQConnection)transportListener).isClosing() || ((BESMQConnection)transportListener).isClosed();
        }
        return false;
    }

    private boolean canReconnect() {
        return this.started && 0 != this.calculateReconnectAttemptLimit();
    }

    public final void handleConnectionControl(ConnectionControl control) {
        String reconnectStr = control.getReconnectTo();
        if (reconnectStr != null && (reconnectStr = reconnectStr.trim()).length() > 0) {
            try {
                URI uri = new URI(reconnectStr);
                if (this.isReconnectSupported()) {
                    this.reconnect(uri);
                    LOG.info("Reconnected to: " + uri);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to handle ConnectionControl reconnect to " + reconnectStr, e);
            }
        }
        this.processNewTransports(control.isRebalanceConnection(), control.getConnectedBrokers());
    }

    private final void processNewTransports(boolean rebalance, String newTransports) {
        if (newTransports != null && (newTransports = newTransports.trim()).length() > 0 && this.isUpdateURIsSupported()) {
            ArrayList<URI> list = new ArrayList<URI>();
            StringTokenizer tokenizer = new StringTokenizer(newTransports, ",");
            while (tokenizer.hasMoreTokens()) {
                String str = tokenizer.nextToken();
                try {
                    URI uri = new URI(str);
                    list.add(uri);
                }
                catch (Exception e) {
                    LOG.error("Failed to parse broker address: " + str, e);
                }
            }
            if (!list.isEmpty()) {
                try {
                    this.updateURIs(rebalance, list.toArray(new URI[list.size()]));
                }
                catch (IOException e) {
                    LOG.error("Failed to update transport URI's from: " + newTransports, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.reconnectMutex;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Started " + this);
            }
            if (this.started) {
                return;
            }
            this.started = true;
            this.stateTracker.setMaxCacheSize(this.getMaxCacheSize());
            this.stateTracker.setTrackMessages(this.isTrackMessages());
            this.stateTracker.setTrackTransactionProducers(this.isTrackTransactionProducers());
            if (this.connectedTransport.get() != null) {
                this.stateTracker.restore(this.connectedTransport.get());
            } else {
                this.reconnect(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stop() throws Exception {
        Object object;
        ArrayList<Transport> backupsToStop;
        Transport transportToStop;
        block19: {
            block18: {
                transportToStop = null;
                backupsToStop = new ArrayList<Transport>(this.backups.size());
                try {
                    object = this.reconnectMutex;
                    synchronized (object) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Stopped " + this);
                        }
                        if (!this.started) {
                            // MONITOREXIT @DISABLED, blocks:[0, 17, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                            Object var7_4 = null;
                            break block18;
                        }
                        this.started = false;
                        this.disposed = true;
                        this.connected = false;
                        if (this.connectedTransport.get() != null) {
                            transportToStop = this.connectedTransport.getAndSet(null);
                        }
                        this.reconnectMutex.notifyAll();
                    }
                    object = this.sleepMutex;
                    synchronized (object) {
                        this.sleepMutex.notifyAll();
                    }
                    break block19;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.reconnectTask.shutdown();
                    this.reconnectTaskFactory.shutdownNow();
                    throw throwable;
                }
            }
            this.reconnectTask.shutdown();
            this.reconnectTaskFactory.shutdownNow();
            return;
        }
        Object var7_5 = null;
        this.reconnectTask.shutdown();
        this.reconnectTaskFactory.shutdownNow();
        object = this.backupMutex;
        synchronized (object) {
            for (BackupTransport backup : this.backups) {
                backup.setDisposed(true);
                Transport transport = backup.getTransport();
                if (transport == null) continue;
                transport.setTransportListener(this.disposedListener);
                backupsToStop.add(transport);
            }
            this.backups.clear();
        }
        for (Transport transport : backupsToStop) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Stopped backup: " + transport);
                }
                this.disposeTransport(transport);
            }
            catch (Exception e) {}
        }
        if (transportToStop != null) {
            transportToStop.stop();
        }
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public double getReconnectDelayExponent() {
        return this.backOffMultiplier;
    }

    public void setReconnectDelayExponent(double reconnectDelayExponent) {
        this.backOffMultiplier = reconnectDelayExponent;
    }

    public Transport getConnectedTransport() {
        return this.connectedTransport.get();
    }

    public URI getConnectedTransportURI() {
        return this.connectedTransportURI;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public int getStartupMaxReconnectAttempts() {
        return this.startupMaxReconnectAttempts;
    }

    public void setStartupMaxReconnectAttempts(int startupMaxReconnectAttempts) {
        this.startupMaxReconnectAttempts = startupMaxReconnectAttempts;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public int getBackupPoolSize() {
        return this.backupPoolSize;
    }

    public void setBackupPoolSize(int backupPoolSize) {
        this.backupPoolSize = backupPoolSize;
    }

    public int getCurrentBackups() {
        return this.backups.size();
    }

    public boolean isTrackMessages() {
        return this.trackMessages;
    }

    public void setTrackMessages(boolean trackMessages) {
        this.trackMessages = trackMessages;
    }

    public boolean isTrackTransactionProducers() {
        return this.trackTransactionProducers;
    }

    public void setTrackTransactionProducers(boolean trackTransactionProducers) {
        this.trackTransactionProducers = trackTransactionProducers;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public boolean isPriorityBackup() {
        return this.priorityBackup;
    }

    public void setPriorityBackup(boolean priorityBackup) {
        this.priorityBackup = priorityBackup;
    }

    public void setPriorityURIs(String priorityURIs) {
        StringTokenizer tokenizer = new StringTokenizer(priorityURIs, ",");
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            try {
                URI uri = new URI(str);
                this.priorityList.add(uri);
            }
            catch (Exception e) {
                LOG.error("Failed to parse broker address: " + str, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void oneway(Object o) throws IOException {
        Command command = (Command)o;
        Exception error = null;
        try {
            Object object = this.reconnectMutex;
            synchronized (object) {
                if (command != null && this.connectedTransport.get() == null) {
                    if (command.isShutdownInfo()) {
                        return;
                    }
                    if (command instanceof RemoveInfo || command.isMessageAck()) {
                        this.stateTracker.track(command);
                        if (command.isResponseRequired()) {
                            Response response = new Response();
                            response.setCorrelationId(command.getCommandId());
                            this.myTransportListener.onCommand(response);
                        }
                        return;
                    }
                    if (command instanceof MessagePull) {
                        MessagePull pullRequest = (MessagePull)command;
                        if (pullRequest.getTimeout() != 0L) {
                            MessageDispatch dispatch = new MessageDispatch();
                            dispatch.setConsumerId(pullRequest.getConsumerId());
                            dispatch.setDestination(pullRequest.getDestination());
                            this.myTransportListener.onCommand(dispatch);
                        }
                        return;
                    }
                }
                int i = 0;
                while (!this.disposed) {
                    try {
                        Transport transport = this.connectedTransport.get();
                        long start = System.currentTimeMillis();
                        boolean timedout = false;
                        while (transport == null && !this.disposed && this.connectionFailure == null && !Thread.currentThread().isInterrupted()) {
                            block34: {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Waiting for transport to reconnect..: " + command);
                                }
                                long end = System.currentTimeMillis();
                                if (this.timeout > 0L && end - start > this.timeout) {
                                    timedout = true;
                                    if (!LOG.isInfoEnabled()) break;
                                    LOG.info("Failover timed out after " + (end - start) + "ms");
                                    break;
                                }
                                try {
                                    this.reconnectMutex.wait(100L);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    if (!LOG.isDebugEnabled()) break block34;
                                    LOG.debug("Interupted: " + e, e);
                                }
                            }
                            transport = this.connectedTransport.get();
                        }
                        if (transport == null) {
                            error = this.disposed ? new IOException("Transport disposed.") : (this.connectionFailure != null ? this.connectionFailure : (timedout ? new IOException("Failover timeout of " + this.timeout + " ms reached.") : new IOException("Unexpected failure.")));
                            break;
                        }
                        Tracked tracked = this.stateTracker.track(command);
                        Map<Integer, Command> map = this.requestMap;
                        synchronized (map) {
                            if (tracked != null && tracked.isWaitingForResponse()) {
                                this.requestMap.put(command.getCommandId(), tracked);
                            } else if (tracked == null && command.isResponseRequired()) {
                                this.requestMap.put(command.getCommandId(), command);
                            }
                        }
                        try {
                            transport.oneway(command);
                            this.stateTracker.trackBack(command);
                        }
                        catch (IOException e) {
                            if (tracked == null) {
                                if (command.isResponseRequired()) {
                                    this.requestMap.remove(command.getCommandId());
                                }
                                throw e;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Send oneway attempt: " + i + " failed for command:" + command);
                            }
                            this.handleTransportFailure(e);
                        }
                        return;
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Send oneway attempt: " + i + " failed for command:" + command);
                        }
                        this.handleTransportFailure(e);
                        ++i;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        if (!this.disposed && error != null) {
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            throw IOExceptionSupport.create(error);
        }
    }

    @Override
    public FutureResponse asyncRequest(Object command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public Object request(Object command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public Object request(Object command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public void add(boolean rebalance, URI[] u) {
        boolean newURI = false;
        for (URI uri : u) {
            if (this.contains(uri)) continue;
            this.uris.add(uri);
            newURI = true;
        }
        if (newURI) {
            this.reconnect(rebalance);
        }
    }

    @Override
    public void remove(boolean rebalance, URI[] u) {
        for (URI uri : u) {
            this.uris.remove(uri);
        }
    }

    public void add(boolean rebalance, String u) {
        try {
            URI newURI = new URI(u);
            if (!this.contains(newURI)) {
                this.uris.add(newURI);
                this.reconnect(rebalance);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse URI: " + u);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(boolean rebalance) {
        Object object = this.reconnectMutex;
        synchronized (object) {
            if (this.started) {
                if (rebalance) {
                    this.doRebalance = true;
                }
                LOG.debug("Waking up reconnect task");
                try {
                    this.reconnectTask.wakeup();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                LOG.debug("Reconnect was triggered but transport is not started yet. Wait for start to connect the transport.");
            }
        }
    }

    private List<URI> getConnectList() {
        if (!this.updated.isEmpty()) {
            boolean removed;
            if (this.failedConnectTransportURI != null && (removed = this.updated.remove(this.failedConnectTransportURI))) {
                this.updated.add(this.failedConnectTransportURI);
            }
            return this.updated;
        }
        ArrayList<URI> l = new ArrayList<URI>(this.uris);
        boolean removed = false;
        if (this.failedConnectTransportURI != null) {
            removed = l.remove(this.failedConnectTransportURI);
        }
        if (this.randomize) {
            for (int i = 0; i < l.size(); ++i) {
                int p = (int)(Math.random() * 100.0 % (double)l.size());
                URI t = l.get(p);
                l.set(p, l.get(i));
                l.set(i, t);
            }
        }
        if (removed) {
            l.add(this.failedConnectTransportURI);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("urlList connectionList:" + l + ", from: " + this.uris);
        }
        return l;
    }

    @Override
    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransportListener(TransportListener commandListener) {
        Object object = this.listenerMutex;
        synchronized (object) {
            this.transportListener = commandListener;
            this.listenerMutex.notifyAll();
        }
    }

    @Override
    public <T> T narrow(Class<T> target) {
        if (target.isAssignableFrom(this.getClass())) {
            return target.cast(this);
        }
        Transport transport = this.connectedTransport.get();
        if (transport != null) {
            return transport.narrow(target);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreTransport(Transport t) throws Exception, IOException {
        t.start();
        ConnectionControl cc = new ConnectionControl();
        cc.setFaultTolerant(true);
        t.oneway(cc);
        this.stateTracker.restore(t);
        LinkedHashMap<Integer, Command> tmpMap = null;
        Map<Integer, Command> map = this.requestMap;
        synchronized (map) {
            tmpMap = new LinkedHashMap<Integer, Command>(this.requestMap);
        }
        for (Command command : tmpMap.values()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Restore requestMap, replay: " + command);
            }
            t.oneway(command);
        }
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public String toString() {
        return this.connectedTransportURI == null ? "unconnected" : this.connectedTransportURI.toString();
    }

    @Override
    public String getRemoteAddress() {
        Transport transport = this.connectedTransport.get();
        if (transport != null) {
            return transport.getRemoteAddress();
        }
        return null;
    }

    @Override
    public boolean isFaultTolerant() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doUpdateURIsFromDisk() {
        fileURL = this.getUpdateURIsURL();
        if (fileURL != null) {
            block13: {
                in = null;
                newUris = null;
                buffer = new StringBuffer();
                try {
                    in = new BufferedReader(this.getURLStream(fileURL));
                    while ((line = in.readLine()) != null) {
                        buffer.append(line);
                    }
                    newUris = buffer.toString();
                    var7_7 = null;
                    ** if (in == null) goto lbl-1000
                }
                catch (Throwable var6_13) {
                    var7_9 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    throw var6_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block13;
                    catch (IOException ioe) {
                        FailoverTransport.LOG.error("Failed to read updateURIsURL: " + fileURL, ioe);
                        var7_8 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                }
            }
            this.processNewTransports(this.isRebalanceUpdateURIs(), newUris);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final boolean doReconnect() {
        Exception failure = null;
        Object object = this.reconnectMutex;
        // MONITORENTER : object
        this.doUpdateURIsFromDisk();
        if (this.disposed || this.connectionFailure != null) {
            this.reconnectMutex.notifyAll();
        }
        if (this.connectedTransport.get() != null && !this.doRebalance && !this.priorityBackupAvailable || this.disposed || this.connectionFailure != null) {
            // MONITOREXIT : object
            return false;
        }
        List<URI> connectList = this.getConnectList();
        if (connectList.isEmpty()) {
            failure = new IOException("No uris available to connect to.");
        } else {
            Transport transport;
            if (this.doRebalance) {
                block55: {
                    if (this.connectedTransportURI != null) {
                        boolean equalsScheme = connectList.get(0).getScheme().equals(this.connectedTransportURI.getScheme());
                        boolean equalsHost = NetUtils.isEqual(connectList.get(0).getHost(), this.connectedTransportURI.getHost());
                        boolean equalsPort = connectList.get(0).getPort() == this.connectedTransportURI.getPort();
                        boolean bl = this.doRebalance = !equalsScheme || !equalsHost || !equalsPort;
                    }
                    if (!this.doRebalance) {
                        // MONITOREXIT : object
                        return false;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Doing rebalance from: " + this.connectedTransportURI + " to " + connectList);
                    }
                    try {
                        transport = this.connectedTransport.getAndSet(null);
                        if (transport != null) {
                            this.disposeTransport(transport);
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block55;
                        LOG.debug("Caught an exception stopping existing transport for rebalance", e);
                    }
                }
                this.doRebalance = false;
            }
            this.resetReconnectDelay();
            transport = null;
            URI uri = null;
            Object equalsPort = this.backupMutex;
            // MONITORENTER : equalsPort
            if ((this.priorityBackup || this.backup) && !this.backups.isEmpty()) {
                ArrayList<BackupTransport> l = new ArrayList<BackupTransport>(this.backups);
                if (this.randomize) {
                    Collections.shuffle(l);
                }
                BackupTransport bt = l.remove(0);
                this.backups.remove(bt);
                transport = bt.getTransport();
                uri = bt.getUri();
                if (this.priorityBackup && this.priorityBackupAvailable) {
                    Transport old = this.connectedTransport.getAndSet(null);
                    if (transport != null) {
                        this.disposeTransport(old);
                    }
                    this.priorityBackupAvailable = false;
                }
            }
            // MONITOREXIT : equalsPort
            if (transport == null && !this.firstConnection && this.reconnectDelay > 0L && !this.disposed) {
                equalsPort = this.sleepMutex;
                // MONITORENTER : equalsPort
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Waiting " + this.reconnectDelay + " ms before attempting connection. ");
                }
                try {
                    this.sleepMutex.wait(this.reconnectDelay);
                }
                catch (InterruptedException e232) {
                    Thread.currentThread().interrupt();
                }
            }
            Iterator<URI> iter = connectList.iterator();
            while ((transport != null || iter.hasNext()) && this.connectedTransport.get() == null && !this.disposed) {
                Object var14_21;
                try {
                    boolean e232;
                    try {
                        SslContext.setCurrentSslContext(this.brokerSslContext);
                        if (transport == null) {
                            uri = iter.next();
                            transport = TransportFactory.compositeConnect(uri);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Attempting  " + this.connectFailures + "th  connect to: " + uri);
                        }
                        transport.setTransportListener(this.myTransportListener);
                        transport.start();
                        if (this.started && !this.firstConnection) {
                            this.restoreTransport(transport);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Connection established");
                        }
                        this.reconnectDelay = this.initialReconnectDelay;
                        this.connectedTransportURI = uri;
                        this.connectedTransport.set(transport);
                        this.reconnectMutex.notifyAll();
                        this.connectFailures = 0;
                        Object e232 = this.listenerMutex;
                        // MONITORENTER : e232
                        if (this.transportListener == null) {
                            try {
                                this.listenerMutex.wait(2000L);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                        }
                        // MONITOREXIT : e232
                        if (this.transportListener != null) {
                            this.transportListener.transportResumed();
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Transport resumed by transport listener not set");
                        }
                        if (this.firstConnection) {
                            this.firstConnection = false;
                            LOG.info("Successfully connected to " + uri);
                        } else {
                            LOG.info("Successfully reconnected to " + uri);
                        }
                        this.connected = true;
                        e232 = false;
                        var14_21 = null;
                    }
                    catch (Exception e) {
                        block56: {
                            failure = e;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Connect fail to: " + uri + ", reason: " + e);
                            }
                            if (transport != null) {
                                try {
                                    transport.stop();
                                    transport = null;
                                }
                                catch (Exception ee) {
                                    if (!LOG.isDebugEnabled()) break block56;
                                    LOG.debug("Stop of failed transport: " + transport + " failed with reason: " + ee);
                                }
                            }
                        }
                        var14_21 = null;
                        SslContext.setCurrentSslContext(null);
                        continue;
                    }
                    SslContext.setCurrentSslContext(null);
                    return e232;
                }
                catch (Throwable throwable) {
                    var14_21 = null;
                    SslContext.setCurrentSslContext(null);
                    throw throwable;
                }
            }
        }
        int reconnectLimit = this.calculateReconnectAttemptLimit();
        ++this.connectFailures;
        if (reconnectLimit != -1 && this.connectFailures >= reconnectLimit) {
            LOG.error("Failed to connect to " + this.uris + " after: " + this.connectFailures + " attempt(s)");
            this.connectionFailure = failure;
            Object object2 = this.listenerMutex;
            // MONITORENTER : object2
            if (this.transportListener == null) {
                try {
                    this.listenerMutex.wait(2000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            // MONITOREXIT : object2
            this.propagateFailureToExceptionListener(this.connectionFailure);
            // MONITOREXIT : object
            return false;
        }
        // MONITOREXIT : object
        if (!this.disposed) {
            this.doDelay();
        }
        if (this.disposed) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelay() {
        if (this.reconnectDelay > 0L) {
            Object object = this.sleepMutex;
            synchronized (object) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Waiting " + this.reconnectDelay + " ms before attempting connection");
                }
                try {
                    this.sleepMutex.wait(this.reconnectDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (this.useExponentialBackOff) {
            this.reconnectDelay = (long)((double)this.reconnectDelay * this.backOffMultiplier);
            if (this.reconnectDelay > this.maxReconnectDelay) {
                this.reconnectDelay = this.maxReconnectDelay;
            }
        }
    }

    private void resetReconnectDelay() {
        if (!this.useExponentialBackOff || this.reconnectDelay == 10L) {
            this.reconnectDelay = this.initialReconnectDelay;
        }
    }

    private void propagateFailureToExceptionListener(Exception exception) {
        if (this.transportListener != null) {
            if (exception instanceof IOException) {
                this.transportListener.onException((IOException)exception);
            } else {
                this.transportListener.onException(IOExceptionSupport.create(exception));
            }
        }
        this.reconnectMutex.notifyAll();
    }

    private int calculateReconnectAttemptLimit() {
        int maxReconnectValue = this.maxReconnectAttempts;
        if (this.firstConnection && this.startupMaxReconnectAttempts != -1) {
            maxReconnectValue = this.startupMaxReconnectAttempts;
        }
        return maxReconnectValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean buildBackups() {
        Object object = this.backupMutex;
        synchronized (object) {
            if (this.disposed) return false;
            if (!this.backup) {
                if (!this.priorityBackup) return false;
            }
            if (this.backups.size() >= this.backupPoolSize) return false;
            ArrayList<URI> backupList = new ArrayList<URI>(this.priorityList);
            List<URI> connectList = this.getConnectList();
            for (URI uri : connectList) {
                if (backupList.contains(uri)) continue;
                backupList.add(uri);
            }
            ArrayList<BackupTransport> disposedList = new ArrayList<BackupTransport>();
            for (BackupTransport bt : this.backups) {
                if (!bt.isDisposed()) continue;
                disposedList.add(bt);
            }
            this.backups.removeAll(disposedList);
            disposedList.clear();
            Iterator<URI> iter = backupList.iterator();
            while (!this.disposed) {
                Object var10_10;
                if (!iter.hasNext()) return false;
                if (this.backups.size() >= this.backupPoolSize) return false;
                URI uri = iter.next();
                if (this.connectedTransportURI == null || this.connectedTransportURI.equals(uri)) continue;
                try {
                    block10: {
                        try {
                            SslContext.setCurrentSslContext(this.brokerSslContext);
                            BackupTransport bt = new BackupTransport(this);
                            bt.setUri(uri);
                            if (this.backups.contains(bt)) break block10;
                            Transport t = TransportFactory.compositeConnect(uri);
                            t.setTransportListener(bt);
                            t.start();
                            bt.setTransport(t);
                            this.backups.add(bt);
                            if (!this.priorityBackup || !this.isPriority(uri)) break block10;
                            this.priorityBackupAvailable = true;
                        }
                        catch (Exception e) {
                            LOG.debug("Failed to build backup ", e);
                            var10_10 = null;
                            SslContext.setCurrentSslContext(null);
                            continue;
                        }
                    }
                    var10_10 = null;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    SslContext.setCurrentSslContext(null);
                    throw throwable;
                }
                SslContext.setCurrentSslContext(null);
            }
            return false;
        }
    }

    protected boolean isPriority(URI uri) {
        if (!this.priorityList.isEmpty()) {
            return this.priorityList.contains(uri);
        }
        return this.uris.indexOf(uri) == 0;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void reconnect(URI uri) throws IOException {
        this.add(true, new URI[]{uri});
    }

    @Override
    public boolean isReconnectSupported() {
        return this.reconnectSupported;
    }

    public void setReconnectSupported(boolean value) {
        this.reconnectSupported = value;
    }

    @Override
    public boolean isUpdateURIsSupported() {
        return this.updateURIsSupported;
    }

    public void setUpdateURIsSupported(boolean value) {
        this.updateURIsSupported = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateURIs(boolean rebalance, URI[] updatedURIs) throws IOException {
        if (this.isUpdateURIsSupported()) {
            HashSet<URI> copy = new HashSet<URI>(this.updated);
            this.updated.clear();
            if (updatedURIs != null && updatedURIs.length > 0) {
                for (URI uri : updatedURIs) {
                    if (uri == null || this.updated.contains(uri)) continue;
                    this.updated.add(uri);
                }
                if (!(copy.isEmpty() && this.updated.isEmpty() || copy.equals(new HashSet<URI>(this.updated)))) {
                    this.buildBackups();
                    Object object = this.reconnectMutex;
                    synchronized (object) {
                        this.reconnect(rebalance);
                    }
                }
            }
        }
    }

    public String getUpdateURIsURL() {
        return this.updateURIsURL;
    }

    public void setUpdateURIsURL(String updateURIsURL) {
        this.updateURIsURL = updateURIsURL;
    }

    public boolean isRebalanceUpdateURIs() {
        return this.rebalanceUpdateURIs;
    }

    public void setRebalanceUpdateURIs(boolean rebalanceUpdateURIs) {
        this.rebalanceUpdateURIs = rebalanceUpdateURIs;
    }

    @Override
    public int getReceiveCounter() {
        Transport transport = this.connectedTransport.get();
        if (transport == null) {
            return 0;
        }
        return transport.getReceiveCounter();
    }

    public int getConnectFailures() {
        return this.connectFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionInterruptProcessingComplete(ConnectionId connectionId) {
        Object object = this.reconnectMutex;
        synchronized (object) {
            this.stateTracker.connectionInterruptProcessingComplete(this, connectionId);
        }
    }

    public ConnectionStateTracker getStateTracker() {
        return this.stateTracker;
    }

    private boolean contains(URI newURI) {
        boolean result = false;
        for (URI uri : this.uris) {
            if (newURI.getPort() != uri.getPort()) continue;
            InetAddress newAddr = null;
            InetAddress addr = null;
            try {
                newAddr = InetAddress.getByName(newURI.getHost());
                addr = InetAddress.getByName(uri.getHost());
            }
            catch (IOException e) {
                if (newAddr == null) {
                    LOG.error("Failed to Lookup INetAddress for URI[ " + newURI + " ] : " + e);
                } else {
                    LOG.error("Failed to Lookup INetAddress for URI[ " + uri + " ] : " + e);
                }
                if (!newURI.getHost().equalsIgnoreCase(uri.getHost())) continue;
                result = true;
                break;
            }
            if (!addr.equals(newAddr)) continue;
            result = true;
            break;
        }
        return result;
    }

    private InputStreamReader getURLStream(String path) throws IOException {
        InputStreamReader result = null;
        URL url = null;
        try {
            url = new URL(path);
            result = new InputStreamReader(url.openStream());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (result == null) {
            result = new FileReader(path);
        }
        return result;
    }
}

