/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.failover;

import com.bes.mq.transport.MutexTransport;
import com.bes.mq.transport.ResponseCorrelator;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.failover.FailoverTransport;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverTransportFactory
extends TransportFactory {
    @Override
    public Transport doConnect(URI location) throws IOException {
        try {
            Transport transport = this.createTransport(URISupport.parseComposite(location));
            transport = new MutexTransport(transport);
            transport = new ResponseCorrelator(transport);
            return transport;
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }

    @Override
    public Transport doCompositeConnect(URI location) throws IOException {
        try {
            return this.createTransport(URISupport.parseComposite(location));
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }

    public Transport createTransport(URISupport.CompositeData compositData) throws IOException {
        Map<String, String> options = compositData.getParameters();
        FailoverTransport transport = this.createTransport(options);
        if (!options.isEmpty()) {
            throw new IllegalArgumentException("Invalid connect parameters: " + options);
        }
        transport.add(false, compositData.getComponents());
        return transport;
    }

    public FailoverTransport createTransport(Map<String, String> parameters) throws IOException {
        FailoverTransport transport = new FailoverTransport();
        IntrospectionSupport.setProperties(transport, parameters);
        return transport;
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("Invalid server URI: " + location);
    }
}

