/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.fanout;

import com.bes.mq.transport.MutexTransport;
import com.bes.mq.transport.ResponseCorrelator;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.discovery.DiscoveryTransport;
import com.bes.mq.transport.discovery.DiscoveryTransportFactory;
import com.bes.mq.transport.fanout.FanoutTransport;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FanoutTransportFactory
extends TransportFactory {
    @Override
    public Transport doConnect(URI location) throws IOException {
        try {
            Transport transport = this.createTransport(location);
            transport = new MutexTransport(transport);
            transport = new ResponseCorrelator(transport);
            return transport;
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }

    @Override
    public Transport doCompositeConnect(URI location) throws IOException {
        try {
            return this.createTransport(location);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }

    public Transport createTransport(URI location) throws IOException, URISyntaxException {
        URISupport.CompositeData compositeData = URISupport.parseComposite(location);
        Map<String, String> parameters = compositeData.getParameters();
        FanoutTransport fanoutTransport = this.createTransport(parameters);
        DiscoveryTransport discoveryTransport = DiscoveryTransportFactory.createTransport(fanoutTransport, compositeData, parameters);
        return discoveryTransport;
    }

    public FanoutTransport createTransport(Map<String, String> parameters) throws IOException {
        FanoutTransport transport = new FanoutTransport();
        IntrospectionSupport.setProperties(transport, parameters);
        return transport;
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("Invalid server URI: " + location);
    }
}

