/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.http;

import com.bes.mq.transport.TransportSupport;
import com.bes.mq.util.ServiceStopper;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingQueueTransport
extends TransportSupport {
    public static final long MAX_TIMEOUT = 30000L;
    private BlockingQueue<Object> queue;

    public BlockingQueueTransport(BlockingQueue<Object> channel) {
        this.queue = channel;
    }

    public BlockingQueue<Object> getQueue() {
        return this.queue;
    }

    @Override
    public void oneway(Object command) throws IOException {
        try {
            boolean success = this.queue.offer(command, 30000L, TimeUnit.MILLISECONDS);
            if (!success) {
                throw new IOException("Fail to add to BlockingQueue. Add timed out after 30000ms: size=" + this.queue.size());
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Fail to add to BlockingQueue. Interrupted while waiting for space: size=" + this.queue.size());
        }
    }

    @Override
    public String getRemoteAddress() {
        return "blockingQueue_" + this.queue.hashCode();
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
    }

    @Override
    public int getReceiveCounter() {
        return 0;
    }
}

