/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.http;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.transport.TransportAcceptListener;
import com.bes.mq.transport.http.HttpTransportFactory;
import com.bes.mq.transport.http.HttpTransportServer;
import com.bes.mq.transport.http.HttpTunnelServlet;
import java.net.URI;
import javax.servlet.ServletException;

public class HttpEmbeddedTunnelServlet
extends HttpTunnelServlet {
    private static final long serialVersionUID = -3705734740251302361L;
    protected BrokerService broker;
    protected HttpTransportServer transportConnector;

    @Override
    public synchronized void init() throws ServletException {
        try {
            if (this.broker == null) {
                this.broker = this.createBroker();
                String url = this.getConnectorURL();
                HttpTransportFactory factory = new HttpTransportFactory();
                this.transportConnector = (HttpTransportServer)factory.doBind(new URI(url));
                this.broker.addConnector(this.transportConnector);
                String brokerURL = this.getServletContext().getInitParameter("com.bes.mq.brokerURL");
                if (brokerURL != null) {
                    this.log("Listening for internal communication on: " + brokerURL);
                }
            }
            this.broker.start();
        }
        catch (Exception e) {
            throw new ServletException("Failed to start embedded broker: " + e, (Throwable)e);
        }
        TransportAcceptListener listener = this.transportConnector.getAcceptListener();
        this.getServletContext().setAttribute("transportChannelListener", (Object)listener);
        super.init();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        return answer;
    }

    protected String getConnectorURL() {
        return "http://localhost/" + this.getServletContext().getServletContextName();
    }
}

